/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.domain.entities;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.IdcardUtil;
import com.alibaba.excel.util.DateUtils;
import com.bcxin.Infrastructures.TenantContext;
import com.bcxin.Infrastructures.components.EventDispatcher;
import com.bcxin.Infrastructures.entities.EntityAbstract;
import com.bcxin.Infrastructures.entities.IAggregate;
import com.bcxin.Infrastructures.entities.OperatorValueType;
import com.bcxin.Infrastructures.enums.CredentialType;
import com.bcxin.Infrastructures.enums.EmploymentStatus;
import com.bcxin.Infrastructures.enums.MasterSlaveType;
import com.bcxin.Infrastructures.enums.OccupationType;
import com.bcxin.Infrastructures.enums.PersonStatus;
import com.bcxin.Infrastructures.enums.Sex;
import com.bcxin.Infrastructures.enums.TrueFalseStatus;
import com.bcxin.Infrastructures.events.DomainEventAbstract;
import com.bcxin.Infrastructures.exceptions.ArgumentTenantException;
import com.bcxin.Infrastructures.exceptions.BadTenantException;
import com.bcxin.Infrastructures.exceptions.NotAllowedTenantException;
import com.bcxin.Infrastructures.utils.AuthUtil;
import com.bcxin.Infrastructures.utils.RetirementAgeUtil;
import com.bcxin.Infrastructures.validations.DateValidator;
import com.bcxin.tenant.domain.entities.DepartmentEmployeeRelationEntity;
import com.bcxin.tenant.domain.entities.DepartmentEntity;
import com.bcxin.tenant.domain.entities.EmployeeEventEntity;
import com.bcxin.tenant.domain.entities.OrganizationEntity;
import com.bcxin.tenant.domain.entities.TenantUserCredentialsEntity;
import com.bcxin.tenant.domain.entities.TenantUserEntity;
import com.bcxin.tenant.domain.enums.EmployeeEventType;
import com.bcxin.tenant.domain.events.EmployeeAfterCreatedEvent;
import com.bcxin.tenant.domain.events.EmployeeBeforeCreatedEvent;
import com.bcxin.tenant.domain.events.EmployeeBeforeEntryValidationEvent;
import com.bcxin.tenant.domain.events.EmployeeHiredDateChangeEvent;
import com.bcxin.tenant.domain.events.EmployeeUpdatedEvent;
import com.bcxin.tenant.domain.utils.BusinessUtil;
import java.sql.Timestamp;
import java.text.ParseException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Optional;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.ConstraintMode;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import org.springframework.util.StringUtils;

@Table(name="tenant_employees", uniqueConstraints={@UniqueConstraint(name="unique_organization_employee", columnNames={"organization_id", "tenant_user_id"})})
@Entity
public class EmployeeEntity
extends EntityAbstract
implements IAggregate {
    @Id
    @Column(length=100)
    private String id;
    @Column(name="job_number", length=50)
    private String jobNumber;
    @Enumerated(value=EnumType.ORDINAL)
    @Column(name="occupation_type", nullable=false)
    private OccupationType occupationType;
    @Enumerated(value=EnumType.ORDINAL)
    @Column(name="status", nullable=false)
    private EmploymentStatus status;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="id", column=@Column(name="hired_operator_id", nullable=true, length=150)), @AttributeOverride(name="name", column=@Column(name="hired_operator_name", nullable=true, length=200)), @AttributeOverride(name="createdTime", column=@Column(name="hired_operator_created_time", nullable=true))})
    private OperatorValueType hiredOperator;
    @Column(name="leave_time", nullable=true)
    private Timestamp leaveTime;
    @Column(name="leave_note", length=2000)
    private String leaveNote;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="id", column=@Column(name="leave_operator_id", nullable=true, length=150)), @AttributeOverride(name="name", column=@Column(name="leave_operator_name", nullable=true, length=200)), @AttributeOverride(name="createdTime", column=@Column(name="leave_operator_created_time", nullable=true))})
    private OperatorValueType leaveOperator;
    @Column(nullable=true, name="hired_date")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date hiredDate;
    @Column(nullable=true, name="positive_date")
    @Temporal(value=TemporalType.DATE)
    private Date positiveDate;
    @Column(nullable=false, name="created_time")
    private Timestamp createdTime = Timestamp.from(Instant.now());
    @Column(nullable=true, name="last_updated_time")
    private Timestamp lastUpdatedTime;
    @Column(name="last_sync_time")
    private Timestamp lastSyncTime;
    @Column(length=50)
    private String salary;
    @Column(length=200)
    private String position;
    @Column(length=1000)
    private String workPlace;
    @Column(length=100)
    private String salaryBankNumber;
    @ManyToOne(cascade={CascadeType.DETACH}, fetch=FetchType.LAZY)
    @JoinColumn(name="superior_id", referencedColumnName="id", nullable=true, foreignKey=@ForeignKey(name="fk_employee_self_superior_id"))
    private EmployeeEntity superior;
    @Column(length=50)
    private String email;
    @Column(name="unique_offset", length=100)
    private String uniqueOffset;
    @Column(name="insure", nullable=false)
    private TrueFalseStatus insure;
    @OneToMany(mappedBy="employee", cascade={CascadeType.ALL}, orphanRemoval=true)
    private Collection<DepartmentEmployeeRelationEntity> departmentEmployeeRelations;
    @ManyToOne(cascade={CascadeType.DETACH}, fetch=FetchType.LAZY)
    @JoinColumn(name="organization_id", referencedColumnName="id")
    private OrganizationEntity organization;
    @Column(name="master_slave_type", nullable=false)
    private MasterSlaveType masterSlaveType;
    @ManyToOne(cascade={CascadeType.DETACH}, fetch=FetchType.LAZY)
    @JoinColumn(name="tenant_user_id", referencedColumnName="id", nullable=false, foreignKey=@ForeignKey(name="", value=ConstraintMode.NO_CONSTRAINT))
    private TenantUserEntity tenantUser;
    @OneToMany(mappedBy="employee", cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    private Collection<EmployeeEventEntity> events;
    @Column(name="is_domain_admin", nullable=false)
    private TrueFalseStatus domainAdmin;
    @ManyToOne(cascade={CascadeType.DETACH}, fetch=FetchType.LAZY)
    @JoinColumn(name="department_id", referencedColumnName="id", foreignKey=@ForeignKey(name="fk_default_department_id", value=ConstraintMode.CONSTRAINT))
    private DepartmentEntity defaultDepartment;
    @Column(name="interview")
    private String interview;
    @Column(name="person_status")
    private PersonStatus personStatus;
    @Column(name="probation")
    private String probation;
    @Column(nullable=true, name="plan_positive_date")
    @Temporal(value=TemporalType.DATE)
    private Date planPositiveDate;

    protected EmployeeEntity() {
        this.setLastUpdatedTime(Timestamp.from(Instant.now()));
        this.setLastSyncTime(Timestamp.from(Instant.now()));
    }

    protected EmployeeEntity(OrganizationEntity organization, OccupationType occupationType, CredentialType credentialType, String credentialNumber) {
        this();
        this.changeOccupationType(occupationType, credentialType, credentialNumber, organization.getSuperviseRegionCode(), organization.getInstitutionalCode());
        this.setOrganization(organization);
        this.markAsDomainAdmin(false, true);
    }

    public void joinDepartment(DepartmentEntity department, MasterSlaveType masterSlaveType) {
        Collection<DepartmentEmployeeRelationEntity> departmentEmployeeRelationEntities = this.getDepartmentEmployeeRelations();
        if (departmentEmployeeRelationEntities == null) {
            departmentEmployeeRelationEntities = new ArrayList<DepartmentEmployeeRelationEntity>();
        }
        Optional<DepartmentEmployeeRelationEntity> departmentEmployeeRelationOptional = departmentEmployeeRelationEntities.stream().findFirst();
        DepartmentEmployeeRelationEntity selectedDepartmentEmployee = null;
        if (departmentEmployeeRelationOptional.isPresent()) {
            selectedDepartmentEmployee = departmentEmployeeRelationOptional.get();
        } else {
            selectedDepartmentEmployee = DepartmentEmployeeRelationEntity.create(department, this, masterSlaveType, true);
            departmentEmployeeRelationEntities.add(selectedDepartmentEmployee);
        }
        department.incrEmployee();
        selectedDepartmentEmployee.setDepartment(department);
        selectedDepartmentEmployee.setDepartmentIndexTree(department.getIndexTree());
        selectedDepartmentEmployee.setMasterSlaveType(masterSlaveType);
        this.setDepartmentEmployeeRelations(departmentEmployeeRelationEntities);
        this.markDefaultDepartment(department);
        this.setLastUpdatedTime(Timestamp.from(Instant.now()));
        this.setLastSyncTime(Timestamp.from(Instant.now()));
    }

    public void joinDepartments(Collection<DepartmentEntity> departments, MasterSlaveType masterSlaveType) {
        Collection<DepartmentEmployeeRelationEntity> dbDepartmentEmployeeRelationEntities = this.getDepartmentEmployeeRelations();
        ArrayList<DepartmentEmployeeRelationEntity> departmentEmployeeRelationEntities = new ArrayList<DepartmentEmployeeRelationEntity>();
        HashMap<String, DepartmentEmployeeRelationEntity> departMap = new HashMap<String, DepartmentEmployeeRelationEntity>();
        if (dbDepartmentEmployeeRelationEntities != null) {
            for (DepartmentEmployeeRelationEntity dbDepartmentEmployeeRelationEntity : dbDepartmentEmployeeRelationEntities) {
                departMap.put(dbDepartmentEmployeeRelationEntity.getDepartment().getId(), dbDepartmentEmployeeRelationEntity);
            }
        }
        for (DepartmentEntity department : departments) {
            if (departMap.get(department.getId()) != null) {
                departmentEmployeeRelationEntities.add((DepartmentEmployeeRelationEntity)((Object)departMap.get(department.getId())));
            } else {
                departmentEmployeeRelationEntities.add(DepartmentEmployeeRelationEntity.create(department, this, masterSlaveType, true));
            }
            department.incrEmployee();
            this.markDefaultDepartment(department);
        }
        this.setDepartmentEmployeeRelations(departmentEmployeeRelationEntities);
        this.setLastUpdatedTime(Timestamp.from(Instant.now()));
        this.setLastSyncTime(Timestamp.from(Instant.now()));
    }

    public void move2Department(DepartmentEntity destDepartment) {
        Collection<DepartmentEmployeeRelationEntity> departmentEmployeeRelationEntities = this.getDepartmentEmployeeRelations();
        for (DepartmentEmployeeRelationEntity relation : departmentEmployeeRelationEntities) {
            relation.gotoDepartment(destDepartment);
        }
        this.setDepartmentEmployeeRelations(departmentEmployeeRelationEntities);
        this.markDefaultDepartment(destDepartment);
        this.setLastUpdatedTime(Timestamp.from(Instant.now()));
        this.setLastSyncTime(Timestamp.from(Instant.now()));
    }

    public void markDefaultDepartment(DepartmentEntity department) {
        this.setDefaultDepartment(department);
        this.setLastUpdatedTime(Timestamp.from(Instant.now()));
        this.setLastSyncTime(Timestamp.from(Instant.now()));
    }

    public void markAsAdmin(MasterSlaveType masterSlaveType) {
        this.setMasterSlaveType(masterSlaveType);
        this.setLastUpdatedTime(Timestamp.from(Instant.now()));
        this.setLastSyncTime(Timestamp.from(Instant.now()));
    }

    public void change(String email, Date hiredDate) {
        this.setEmail(email);
        this.setHiredDate(hiredDate);
        this.setLastUpdatedTime(Timestamp.from(Instant.now()));
        this.setLastSyncTime(Timestamp.from(Instant.now()));
        Timestamp hiredDateTimestamp = Timestamp.valueOf(DateUtil.toLocalDateTime((Date)hiredDate));
        this.recordEvent(EmployeeHiredDateChangeEvent.create(this, EmployeeEventType.Other, hiredDateTimestamp, ""));
    }

    public void change(Date hiredDate, String position, Date positiveDate, EmployeeEntity superior, String interview, PersonStatus personStatus, String probation, Date planPositiveDate, String salary) {
        if (AuthUtil.isBeiJingCompany()) {
            this.setHiredDate(hiredDate);
        }
        this.setPosition(position);
        this.changeSuperior(superior);
        this.setPositiveDate(positiveDate);
        this.setInterview(interview);
        this.setPersonStatus(personStatus);
        this.setProbation(probation);
        this.setPlanPositiveDate(planPositiveDate);
        this.setSalary(salary);
        this.setLastUpdatedTime(Timestamp.from(Instant.now()));
        this.setLastSyncTime(Timestamp.from(Instant.now()));
        Timestamp hiredDateTimestamp = Timestamp.valueOf(DateUtil.toLocalDateTime((Date)hiredDate));
        this.recordEvent(EmployeeHiredDateChangeEvent.create(this, EmployeeEventType.Other, hiredDateTimestamp, ""));
    }

    public void leave(Date expectedDate, String note, OperatorValueType leaveOperator) {
        if (this.getStatus() == EmploymentStatus.OffJob) {
            throw new NotAllowedTenantException(String.format("\u8be5\u804c\u5458(%s)\u5df2\u7ecf\u5904\u4e8e\u79bb\u804c\u72b6\u6001", this.getId()));
        }
        if (this.getDomainAdmin() == TrueFalseStatus.True) {
            throw new NotAllowedTenantException(String.format("\u8be5\u804c\u5458(%s)\u4e3a\u7ec4\u7ec7\u7ba1\u7406\u5458\uff0c\u4e0d\u5141\u8bb8\u79bb\u804c\uff0c\u8bf7\u8f6c\u79fb\u540e\u91cd\u8bd5", this.getId()));
        }
        Timestamp leaveTimeStamp = Timestamp.from(expectedDate.toInstant());
        this.setStatus(EmploymentStatus.OffJob);
        this.setLeaveTime(leaveTimeStamp);
        this.setLeaveNote(note);
        this.setLeaveOperator(leaveOperator);
        this.setUniqueOffset(String.format("Lv%s", Instant.now()));
        this.setLastUpdatedTime(Timestamp.from(Instant.now()));
        this.setLastSyncTime(Timestamp.from(Instant.now()));
        this.recordEvent(EmployeeUpdatedEvent.create(this, EmployeeEventType.LeaveJob, this.leaveTime, note));
    }

    public void back(EventDispatcher eventDispatcher, DepartmentEntity department, OccupationType occupationType, Date hiredDate, OperatorValueType hiredOperator, boolean isDuplicateValidate) {
        if (this.getStatus() != EmploymentStatus.OffJob) {
            return;
        }
        TenantUserEntity tenantUser = this.getTenantUser();
        TenantUserCredentialsEntity userCredential = tenantUser.getSelectedCredential();
        CredentialType credentialType = null;
        String credentialNumber = null;
        if (userCredential != null) {
            credentialType = userCredential.getCredentialType();
            credentialNumber = userCredential.getNumber();
        }
        this.changeOccupationType(occupationType, credentialType, credentialNumber, this.getOrganization().getSuperviseRegionCode(), this.getOrganization().getInstitutionalCode());
        this.setStatus(EmploymentStatus.OnJob);
        this.setHiredDate(Timestamp.from(Instant.now()));
        this.setHiredOperator(hiredOperator);
        this.setLeaveTime(null);
        this.setLeaveNote("\u590d\u804c");
        ArrayList<DepartmentEmployeeRelationEntity> newDepartRelations = new ArrayList<DepartmentEmployeeRelationEntity>();
        newDepartRelations.add(DepartmentEmployeeRelationEntity.create(department, this, MasterSlaveType.Normal, true));
        this.setDepartmentEmployeeRelations(newDepartRelations);
        this.move2Department(department);
        this.setHiredDate(hiredDate);
        this.setLastUpdatedTime(Timestamp.from(Instant.now()));
        this.setLastSyncTime(Timestamp.from(Instant.now()));
        if (!isDuplicateValidate) {
            this.doValidateBeforeBackOrCreateEvent(eventDispatcher, true);
        }
        this.recordEvent(EmployeeUpdatedEvent.create(this, EmployeeEventType.EntryJob, Timestamp.valueOf(DateUtil.toLocalDateTime((Date)hiredDate)), "\u590d\u804c"));
    }

    public void changeSuperior(EmployeeEntity superior) {
        if (superior != null && superior.getId().equals(this.getId())) {
            throw new NotAllowedTenantException("\u65e0\u6cd5\u8bbe\u7f6e\u81ea\u5df1\u4e3a\u81ea\u5df1\u7684\u4e0a\u7ea7");
        }
        this.setSuperior(superior);
        this.setLastUpdatedTime(Timestamp.from(Instant.now()));
        this.setLastSyncTime(Timestamp.from(Instant.now()));
    }

    public String getSelectIdNum() {
        return this.getTenantUser().getSelectIdNum();
    }

    public void changeOccupationType(OccupationType occupationType, CredentialType credentialType, String credentialNumber, String areaCode, String institutionalCode) {
        if (occupationType == null) {
            throw new ArgumentTenantException("\u804c\u4e1a\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (occupationType == OccupationType.SecurityGuard) {
            if (credentialType != CredentialType.IdCard) {
                throw new ArgumentTenantException("\u4fdd\u5b89\u5458\u5fc5\u987b\u4e0a\u4f20\u8eab\u4efd\u8bc1\u4fe1\u606f");
            }
            if (!StringUtils.hasLength((String)credentialNumber)) {
                throw new ArgumentTenantException("\u8eab\u4efd\u8bc1\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            }
            Date d = new Date();
            d.setHours(0);
            d.setMinutes(0);
            d.setSeconds(0);
            DateTime birthDate = IdcardUtil.getBirthDate((String)credentialNumber);
            if ((institutionalCode == null || !institutionalCode.startsWith("02")) && DateValidator.dateAddYear((Date)birthDate, (int)18).after(d)) {
                throw new ArgumentTenantException("\u4fdd\u5b89\u5458\u5e74\u9f84\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e18\u5c81");
            }
            if (institutionalCode == null || !institutionalCode.startsWith("02")) {
                if (AuthUtil.isBeijingCompany((String)areaCode)) {
                    if (IdcardUtil.getGenderByIdCard((String)credentialNumber) == 0 ? RetirementAgeUtil.isExceedRetirementAge((Date)birthDate, (int)50) : RetirementAgeUtil.isExceedRetirementAge((Date)birthDate, (int)60)) {
                        throw new ArgumentTenantException("\u6839\u636e\u6700\u65b0\u4eba\u793e\u90e8\u89c4\u5b9a\uff0c\u8be5\u4eba\u5458\u5df2\u8d85\u9f84");
                    }
                } else if (AuthUtil.isHunanCompany((String)areaCode)) {
                    if (IdcardUtil.getGenderByIdCard((String)credentialNumber) == 0) {
                        if (DateValidator.dateAddYear((Date)birthDate, (int)60).before(d)) {
                            throw new ArgumentTenantException("\u5165\u804c\u5973\u4fdd\u5b89\u5458, \u5e74\u9f84\u5fc5\u987b\u5c0f\u4e8e\u7b49\u4e8e60\u5c81");
                        }
                    } else if (DateValidator.dateAddYear((Date)birthDate, (int)60).before(d)) {
                        throw new ArgumentTenantException("\u5165\u804c\u7537\u4fdd\u5b89\u5458, \u5e74\u9f84\u5fc5\u987b\u5c0f\u4e8e\u7b49\u4e8e60\u5c81");
                    }
                } else if (AuthUtil.isNingxiaCompany((String)areaCode)) {
                    if (IdcardUtil.getGenderByIdCard((String)credentialNumber) == 0) {
                        if (DateValidator.dateAddYear((Date)birthDate, (int)55).before(d)) {
                            throw new ArgumentTenantException("\u5165\u804c\u5973\u4fdd\u5b89\u5458, \u5e74\u9f84\u5fc5\u987b\u5c0f\u4e8e\u7b49\u4e8e55\u5c81");
                        }
                    } else if (DateValidator.dateAddYear((Date)birthDate, (int)60).before(d)) {
                        throw new ArgumentTenantException("\u5165\u804c\u7537\u4fdd\u5b89\u5458, \u5e74\u9f84\u5fc5\u987b\u5c0f\u4e8e\u7b49\u4e8e60\u5c81");
                    }
                } else if (AuthUtil.isShanxiCompany((String)areaCode)) {
                    if (IdcardUtil.getGenderByIdCard((String)credentialNumber) == 0) {
                        if (DateValidator.dateAddYear((Date)birthDate, (int)58).before(d)) {
                            throw new ArgumentTenantException("\u5165\u804c\u5973\u4fdd\u5b89\u5458, \u5e74\u9f84\u5fc5\u987b\u5c0f\u4e8e\u7b49\u4e8e58\u5c81");
                        }
                    } else if (DateValidator.dateAddYear((Date)birthDate, (int)63).before(d)) {
                        throw new ArgumentTenantException("\u5165\u804c\u7537\u4fdd\u5b89\u5458, \u5e74\u9f84\u5fc5\u987b\u5c0f\u4e8e\u7b49\u4e8e63\u5c81");
                    }
                }
            }
        }
        this.setOccupationType(occupationType);
        this.setLastUpdatedTime(Timestamp.from(Instant.now()));
        this.setLastSyncTime(Timestamp.from(Instant.now()));
    }

    public static EmployeeEntity create(EventDispatcher eventDispatcher, OrganizationEntity organization, DepartmentEntity defaultDepartment, String name, String telephone, String password, String position, Date hiredDate, MasterSlaveType masterSlaveType, CredentialType credentialType, String credentialNumber, OccupationType occupationType, boolean ensureExistsUser, OperatorValueType hiredOperator) {
        EmployeeEntity employee = new EmployeeEntity(organization, occupationType, credentialType, credentialNumber);
        employee.setStatus(EmploymentStatus.OnJob);
        employee.markAsAdmin(masterSlaveType);
        employee.setPosition(position);
        employee.setHiredDate(hiredDate);
        employee.setInsure(TrueFalseStatus.False);
        employee.setStatus(EmploymentStatus.OnJob);
        employee.joinDepartment(defaultDepartment, masterSlaveType);
        employee.setHiredOperator(hiredOperator);
        Sex sex = EmployeeEntity.getSexByCredential(credentialType, credentialNumber);
        Date birthdate = EmployeeEntity.getBirthdateByCredential(credentialType, credentialNumber);
        EmployeeBeforeCreatedEvent employeeBeforeCreatedEvent = EmployeeBeforeCreatedEvent.create(employee, name, telephone, password, credentialType, credentialNumber, masterSlaveType, ensureExistsUser, sex, birthdate);
        employee.recordEvent(employeeBeforeCreatedEvent);
        TenantUserEntity tenantUser = (TenantUserEntity)((Object)TenantContext.getInstance().getValueAndRemove((Object)employee));
        if (tenantUser == null) {
            throw new BadTenantException("\u79df\u6237\u4fe1\u606f\u65e0\u6548,\u65e0\u6cd5\u521b\u5efa\u5458\u5de5, \u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        employee.assignTenantUser(tenantUser, organization);
        employee.doValidateBeforeBackOrCreateEvent(eventDispatcher, false);
        return employee;
    }

    public static EmployeeEntity create(EventDispatcher eventDispatcher, OrganizationEntity organization, DepartmentEntity defaultDepartment, String name, String telephone, String password, String position, Date hiredDate, MasterSlaveType masterSlaveType, CredentialType credentialType, String credentialNumber, OccupationType occupationType, String nation, String education, String politicsStatus, String militaryStatus, String maritalStatus, String emergencyContact, String emergencyPhone, String address, String householdType, boolean ensureExistsUser, OperatorValueType hiredOperator) {
        EmployeeEntity employee = new EmployeeEntity(organization, occupationType, credentialType, credentialNumber);
        employee.setStatus(EmploymentStatus.OnJob);
        employee.markAsAdmin(masterSlaveType);
        employee.setPosition(position);
        employee.setHiredDate(hiredDate);
        employee.setInsure(TrueFalseStatus.False);
        employee.setStatus(EmploymentStatus.OnJob);
        employee.joinDepartment(defaultDepartment, masterSlaveType);
        employee.setHiredOperator(hiredOperator);
        Sex sex = EmployeeEntity.getSexByCredential(credentialType, credentialNumber);
        Date birthdate = EmployeeEntity.getBirthdateByCredential(credentialType, credentialNumber);
        EmployeeBeforeCreatedEvent employeeBeforeCreatedEvent = EmployeeBeforeCreatedEvent.create(employee, name, telephone, password, credentialType, credentialNumber, masterSlaveType, ensureExistsUser, sex, birthdate, nation, education, politicsStatus, militaryStatus, maritalStatus, emergencyContact, emergencyPhone, address, householdType);
        employee.recordEvent(employeeBeforeCreatedEvent);
        TenantUserEntity tenantUser = (TenantUserEntity)((Object)TenantContext.getInstance().getValueAndRemove((Object)employee));
        if (tenantUser == null) {
            throw new BadTenantException("\u79df\u6237\u4fe1\u606f\u65e0\u6548,\u65e0\u6cd5\u521b\u5efa\u5458\u5de5, \u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        employee.assignTenantUser(tenantUser, organization);
        employee.doValidateBeforeBackOrCreateEvent(eventDispatcher, false);
        return employee;
    }

    public static EmployeeEntity create(EventDispatcher eventDispatcher, OrganizationEntity organization, DepartmentEntity defaultDepartment, TenantUserEntity tenantUser, MasterSlaveType masterSlaveType, String position, OccupationType occupationType, CredentialType credentialType, String credentialNumber, boolean isDomainAdmin, OperatorValueType hiredOperator) {
        EmployeeEntity employee = new EmployeeEntity(organization, occupationType, credentialType, credentialNumber);
        employee.setStatus(EmploymentStatus.OnJob);
        employee.setHiredDate(new Date());
        employee.markAsAdmin(masterSlaveType);
        employee.setPosition(position);
        employee.setInsure(TrueFalseStatus.False);
        employee.markAsDomainAdmin(isDomainAdmin, true);
        employee.setHiredOperator(hiredOperator);
        employee.assignTenantUser(tenantUser, organization);
        employee.joinDepartment(defaultDepartment, masterSlaveType);
        employee.recordEvent(EmployeeBeforeCreatedEvent.create(employee, tenantUser.getName(), tenantUser.getTelephone(), null, tenantUser.getSelectedCredential() == null ? null : tenantUser.getSelectedCredential().getCredentialType(), tenantUser.getSelectedCredential() == null ? null : tenantUser.getSelectedCredential().getNumber(), masterSlaveType, false, null, null));
        employee.doValidateBeforeBackOrCreateEvent(eventDispatcher, false);
        return employee;
    }

    public void markAsDomainAdmin(boolean domainAdmin, boolean isFromNew) {
        this.setDomainAdmin(domainAdmin ? TrueFalseStatus.True : TrueFalseStatus.False);
        if (!isFromNew) {
            this.recordEvent(EmployeeUpdatedEvent.create(this, domainAdmin ? EmployeeEventType.AsAdmin : EmployeeEventType.AsUser, Timestamp.from(Instant.now()), domainAdmin ? "\u8bbe\u7f6e\u4e3a\u7ec4\u7ec7\u7ba1\u7406\u5458" : "\u79fb\u9664\u7ec4\u7ec7\u7ba1\u7406\u5458"));
        }
        this.setLastUpdatedTime(Timestamp.from(Instant.now()));
        this.setLastSyncTime(Timestamp.from(Instant.now()));
    }

    public void dispatchAfterCreatedEvent(boolean isRequiredPhoneAsLoginName) {
        EmployeeAfterCreatedEvent employeeAfterCreatedEvent = EmployeeAfterCreatedEvent.create(this, this.tenantUser.getTelephone(), isRequiredPhoneAsLoginName);
        this.recordEvent(employeeAfterCreatedEvent);
    }

    private static boolean isEvenNumber(int num) {
        if (num == 0) {
            return true;
        }
        return num % 2 == 0;
    }

    private static Sex getSexByCredential(CredentialType credentialType, String credentialNumber) {
        Sex sex = null;
        if (credentialType.ordinal() == CredentialType.IdCard.ordinal() && StringUtils.hasLength((String)credentialNumber)) {
            String sexText = "";
            if (credentialNumber.length() == 15) {
                sexText = credentialNumber.substring(14);
            } else if (credentialNumber.length() == 18) {
                sexText = credentialNumber.substring(16, 17);
            } else {
                throw new ArgumentTenantException("\u8eab\u4efd\u8bc1\u53f7\u7801\u683c\u5f0f\u9519\u8bef");
            }
            sex = EmployeeEntity.isEvenNumber(Integer.parseInt(sexText)) ? Sex.Female : Sex.Male;
        }
        return sex;
    }

    private static Date getBirthdateByCredential(CredentialType credentialType, String credentialNumber) {
        Date birthdate = null;
        if (credentialType.ordinal() == CredentialType.IdCard.ordinal() && StringUtils.hasLength((String)credentialNumber)) {
            String birthdateText = "";
            if (credentialNumber.length() == 15) {
                birthdateText = "19" + credentialNumber.substring(6, 12);
            } else if (credentialNumber.length() == 18) {
                birthdateText = credentialNumber.substring(6, 14);
            } else {
                throw new ArgumentTenantException("\u8eab\u4efd\u8bc1\u53f7\u7801\u683c\u5f0f\u9519\u8bef");
            }
            try {
                birthdate = DateUtils.parseDate((String)birthdateText, (String)"yyyyMMdd");
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        return birthdate;
    }

    private void doValidateBeforeBackOrCreateEvent(EventDispatcher eventDispatcher, boolean isBack) {
        TenantUserEntity tenantUser = this.getTenantUser();
        TenantUserCredentialsEntity userCredential = tenantUser.getSelectedCredential();
        CredentialType credentialType = null;
        String credentialNumber = null;
        if (userCredential != null) {
            credentialType = userCredential.getCredentialType();
            credentialNumber = userCredential.getNumber();
        }
        String tenantUserId = tenantUser.getId();
        EmployeeBeforeEntryValidationEvent employeeBeforeEntryValidationEvent = EmployeeBeforeEntryValidationEvent.create(this.getOrganization().getSuperviseRegionCode(), this.getOrganization().getId(), Collections.singleton(EmployeeBeforeEntryValidationEvent.TenantUserOccupationTypeInfo.create(tenantUserId, tenantUser.getName(), this.occupationType, credentialType, credentialNumber, tenantUser.getTelephone(), isBack)));
        eventDispatcher.dispatch((DomainEventAbstract)employeeBeforeEntryValidationEvent);
    }

    public void assignTenantUser(TenantUserEntity user, OrganizationEntity organization) {
        this.setId(BusinessUtil.generateEmpMemberId(organization.getId(), user.getId()));
        this.setTenantUser(user);
    }

    public String getId() {
        return this.id;
    }

    public String getJobNumber() {
        return this.jobNumber;
    }

    public OccupationType getOccupationType() {
        return this.occupationType;
    }

    public EmploymentStatus getStatus() {
        return this.status;
    }

    public OperatorValueType getHiredOperator() {
        return this.hiredOperator;
    }

    public Timestamp getLeaveTime() {
        return this.leaveTime;
    }

    public String getLeaveNote() {
        return this.leaveNote;
    }

    public OperatorValueType getLeaveOperator() {
        return this.leaveOperator;
    }

    public Date getHiredDate() {
        return this.hiredDate;
    }

    public Date getPositiveDate() {
        return this.positiveDate;
    }

    public Timestamp getCreatedTime() {
        return this.createdTime;
    }

    public Timestamp getLastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public Timestamp getLastSyncTime() {
        return this.lastSyncTime;
    }

    public String getSalary() {
        return this.salary;
    }

    public String getPosition() {
        return this.position;
    }

    public String getWorkPlace() {
        return this.workPlace;
    }

    public String getSalaryBankNumber() {
        return this.salaryBankNumber;
    }

    public EmployeeEntity getSuperior() {
        return this.superior;
    }

    public String getEmail() {
        return this.email;
    }

    public String getUniqueOffset() {
        return this.uniqueOffset;
    }

    public TrueFalseStatus getInsure() {
        return this.insure;
    }

    public Collection<DepartmentEmployeeRelationEntity> getDepartmentEmployeeRelations() {
        return this.departmentEmployeeRelations;
    }

    public OrganizationEntity getOrganization() {
        return this.organization;
    }

    public MasterSlaveType getMasterSlaveType() {
        return this.masterSlaveType;
    }

    public TenantUserEntity getTenantUser() {
        return this.tenantUser;
    }

    public Collection<EmployeeEventEntity> getEvents() {
        return this.events;
    }

    public TrueFalseStatus getDomainAdmin() {
        return this.domainAdmin;
    }

    public DepartmentEntity getDefaultDepartment() {
        return this.defaultDepartment;
    }

    public String getInterview() {
        return this.interview;
    }

    public PersonStatus getPersonStatus() {
        return this.personStatus;
    }

    public String getProbation() {
        return this.probation;
    }

    public Date getPlanPositiveDate() {
        return this.planPositiveDate;
    }

    protected void setId(String id) {
        this.id = id;
    }

    protected void setJobNumber(String jobNumber) {
        this.jobNumber = jobNumber;
    }

    protected void setOccupationType(OccupationType occupationType) {
        this.occupationType = occupationType;
    }

    protected void setStatus(EmploymentStatus status) {
        this.status = status;
    }

    protected void setHiredOperator(OperatorValueType hiredOperator) {
        this.hiredOperator = hiredOperator;
    }

    protected void setLeaveTime(Timestamp leaveTime) {
        this.leaveTime = leaveTime;
    }

    protected void setLeaveNote(String leaveNote) {
        this.leaveNote = leaveNote;
    }

    protected void setLeaveOperator(OperatorValueType leaveOperator) {
        this.leaveOperator = leaveOperator;
    }

    protected void setHiredDate(Date hiredDate) {
        this.hiredDate = hiredDate;
    }

    protected void setPositiveDate(Date positiveDate) {
        this.positiveDate = positiveDate;
    }

    protected void setCreatedTime(Timestamp createdTime) {
        this.createdTime = createdTime;
    }

    protected void setLastUpdatedTime(Timestamp lastUpdatedTime) {
        this.lastUpdatedTime = lastUpdatedTime;
    }

    protected void setLastSyncTime(Timestamp lastSyncTime) {
        this.lastSyncTime = lastSyncTime;
    }

    protected void setSalary(String salary) {
        this.salary = salary;
    }

    protected void setPosition(String position) {
        this.position = position;
    }

    protected void setWorkPlace(String workPlace) {
        this.workPlace = workPlace;
    }

    protected void setSalaryBankNumber(String salaryBankNumber) {
        this.salaryBankNumber = salaryBankNumber;
    }

    protected void setSuperior(EmployeeEntity superior) {
        this.superior = superior;
    }

    protected void setEmail(String email) {
        this.email = email;
    }

    protected void setUniqueOffset(String uniqueOffset) {
        this.uniqueOffset = uniqueOffset;
    }

    protected void setInsure(TrueFalseStatus insure) {
        this.insure = insure;
    }

    protected void setDepartmentEmployeeRelations(Collection<DepartmentEmployeeRelationEntity> departmentEmployeeRelations) {
        this.departmentEmployeeRelations = departmentEmployeeRelations;
    }

    protected void setOrganization(OrganizationEntity organization) {
        this.organization = organization;
    }

    protected void setMasterSlaveType(MasterSlaveType masterSlaveType) {
        this.masterSlaveType = masterSlaveType;
    }

    protected void setTenantUser(TenantUserEntity tenantUser) {
        this.tenantUser = tenantUser;
    }

    protected void setEvents(Collection<EmployeeEventEntity> events) {
        this.events = events;
    }

    protected void setDomainAdmin(TrueFalseStatus domainAdmin) {
        this.domainAdmin = domainAdmin;
    }

    protected void setDefaultDepartment(DepartmentEntity defaultDepartment) {
        this.defaultDepartment = defaultDepartment;
    }

    protected void setInterview(String interview) {
        this.interview = interview;
    }

    protected void setPersonStatus(PersonStatus personStatus) {
        this.personStatus = personStatus;
    }

    protected void setProbation(String probation) {
        this.probation = probation;
    }

    protected void setPlanPositiveDate(Date planPositiveDate) {
        this.planPositiveDate = planPositiveDate;
    }
}

