/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.domain.services.impls;

import com.bcxin.Infrastructures.TenantContext;
import com.bcxin.Infrastructures.TenantUserContext;
import com.bcxin.Infrastructures.enums.InviteType;
import com.bcxin.Infrastructures.exceptions.ForbidTenantException;
import com.bcxin.Infrastructures.utils.UUIDUtil;
import com.bcxin.api.interfaces.tenants.responses.CompanyUSCCResponse;
import com.bcxin.tenant.domain.entities.InviteOrganizationRelationshipEntity;
import com.bcxin.tenant.domain.repositories.InviteOrganizationRelationshipRepository;
import com.bcxin.tenant.domain.repositories.OrganizationRepository;
import com.bcxin.tenant.domain.repositories.dtos.OrganizationDto;
import com.bcxin.tenant.domain.services.InviteOrganizationRelationshipService;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class InviteOrganizationRelationshipServiceImpl
implements InviteOrganizationRelationshipService {
    private final Logger logger = LoggerFactory.getLogger(InviteOrganizationRelationshipServiceImpl.class);
    private final InviteOrganizationRelationshipRepository inviteOrganizationRelationshipRepository;
    private final OrganizationRepository organizationRepository;

    public InviteOrganizationRelationshipServiceImpl(InviteOrganizationRelationshipRepository inviteOrganizationRelationshipRepository, OrganizationRepository organizationRepository) {
        this.inviteOrganizationRelationshipRepository = inviteOrganizationRelationshipRepository;
        this.organizationRepository = organizationRepository;
    }

    @Override
    public String getGroupCode(String organizationId) {
        Collection<InviteOrganizationRelationshipEntity> inviteOrganizationRelationshipEntities = this.inviteOrganizationRelationshipRepository.findByOrganizationId(organizationId);
        if (inviteOrganizationRelationshipEntities != null && inviteOrganizationRelationshipEntities.size() > 0) {
            return inviteOrganizationRelationshipEntities.iterator().next().getCode();
        }
        TenantUserContext.UserModel currentUser = TenantContext.getInstance().getUserContext().get();
        if (currentUser == null) {
            throw new ForbidTenantException("\u5fc5\u987b\u6709\u4eba\u6765\u64cd\u4f5c\u79bb\u804c");
        }
        String code = UUIDUtil.getShortUuid();
        this.inviteOrganizationRelationshipRepository.save(InviteOrganizationRelationshipEntity.create(code, organizationId, InviteType.GroupCode, "", currentUser.getId()));
        return code;
    }

    @Override
    public CompanyUSCCResponse findCompanyUSCCByGroupCode(String groupCode) {
        String organizationId;
        OrganizationDto dtoById;
        Collection<InviteOrganizationRelationshipEntity> inviteOrganizationRelationshipEntities = this.inviteOrganizationRelationshipRepository.findByCode(groupCode);
        if (inviteOrganizationRelationshipEntities != null && inviteOrganizationRelationshipEntities.size() > 0 && (dtoById = this.organizationRepository.getDtoById(organizationId = inviteOrganizationRelationshipEntities.iterator().next().getOrganizationId())) != null) {
            return CompanyUSCCResponse.create((String)dtoById.getName(), (String)dtoById.getUnifySocialCreditCode());
        }
        return null;
    }
}

