package com.bcxin.tenant.domain.snapshots;

import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Data;
import org.springframework.util.StringUtils;

import java.io.Serializable;

@Data
public class DepartmentImportedItemSnapshot implements Serializable {
    private String name;
    private String displayOrder;
    private String parentTreeName;
    private String permissionType;
    private int paramIndex;

    public DepartmentImportedItemSnapshot(){}

    @JsonIgnore
    public int getTreeDepth() {
        if (!StringUtils.hasLength(this.getParentTreeName())) {
            return 0;
        }

        return this.getParentTreeName().split("/").length;
    }

    public static DepartmentImportedItemSnapshot create(int paramIndex, String name, String displayOrder, String parentTreeName, String permissionType) {
        DepartmentImportedItemSnapshot departmentImportedItemSnapshot = new DepartmentImportedItemSnapshot();
        departmentImportedItemSnapshot.setParamIndex(paramIndex);
        departmentImportedItemSnapshot.setName(name);
        departmentImportedItemSnapshot.setDisplayOrder(displayOrder);
        departmentImportedItemSnapshot.setParentTreeName(parentTreeName);
        departmentImportedItemSnapshot.setPermissionType(permissionType);

        return departmentImportedItemSnapshot;
    }
}
