package com.bcxin.tenant.domain.services.commands.tenantUsers;

import com.bcxin.Infrastructures.commands.CommandAbstract;
import com.bcxin.Infrastructures.enums.CredentialType;
import lombok.Getter;
import org.springframework.util.StringUtils;

import java.util.Date;

@Getter
public class TocWechatCgiConfirmCheckStatusCommand extends CommandAbstract {
    private final String tenantUserId;

    private final String name;

    private final String number;

    private final CredentialType credentialType;

    private final String headPhoto;

    private final String frontPhoto;

    private final String reversePhoto;

    private final String address;

    private final Date validDateFrom;

    private final Date validDateTo;

    private final String certificateImage;

    private final String phone;

    public TocWechatCgiConfirmCheckStatusCommand(String tenantUserId, String name, CredentialType credentialType, String number, String headPhoto,
                                                 String frontPhoto, String reversePhoto, String address,
                                                 Date validDateFrom, Date validDateTo, String certificateImage, String phone) {
        this.tenantUserId = tenantUserId;
        this.name = name;
        this.number = number;
        this.headPhoto = headPhoto;
        this.frontPhoto = frontPhoto;
        this.reversePhoto = reversePhoto;
        this.address = address;
        this.validDateFrom = validDateFrom;
        this.validDateTo = validDateTo;
        this.certificateImage = certificateImage;
        if(StringUtils.hasLength(phone)) {
            this.phone = phone;
        }else {
            this.phone = ".";
        }

        this.credentialType = credentialType;
    }

    public static TocWechatCgiConfirmCheckStatusCommand create(String tenantUserId, String name,CredentialType credentialType, String number,String headPhoto,
                                                               String frontPhoto, String reversePhoto, String address,
                                                               Date validDateFrom, Date validDateTo,String certificateImage, String phone) {
        return new TocWechatCgiConfirmCheckStatusCommand(tenantUserId, name,credentialType, number, headPhoto, frontPhoto,
                reversePhoto, address, validDateFrom, validDateTo, certificateImage, phone);
    }

    @Getter
    public static final class TocWechatCgiConfirmCheckStatusCommandResult{
        private final String tenantUserId;

        public TocWechatCgiConfirmCheckStatusCommandResult(String tenantUserId) {
            this.tenantUserId = tenantUserId;
        }

        public static TocWechatCgiConfirmCheckStatusCommandResult create(String tenantUserId){
            return new TocWechatCgiConfirmCheckStatusCommandResult(tenantUserId);
        }
    }
}
