package com.bcxin.tenant.domain.entities;

import com.bcxin.Infrastructures.entities.EntityAbstract;
import com.bcxin.Infrastructures.entities.IAggregate;
import com.bcxin.Infrastructures.enums.AppealStatus;
import lombok.AccessLevel;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.*;
import java.sql.Timestamp;
import java.time.Instant;

/**
 * 人员申诉记录
 */
@Getter
@Setter(AccessLevel.PROTECTED)
@Table(name = "tenant_user_appeals")
@Entity
public class TenantUserAppealsEntity extends EntityAbstract implements IAggregate {
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;

    /**
     * tenant_user人员id
     */
    @ManyToOne(cascade = CascadeType.DETACH)
    @JoinColumn(name = "tenant_user_id", referencedColumnName = "id")
    //@Column(name = "tenant_user_id", nullable = false)
    private TenantUserEntity tenantUser;

    /**
     * 监管区域编码
     */
    @Column(name = "region_code")
    private String regionCode;

    /**
     * 申诉图片
     */
    @Column(name = "appeal_photo")
    private String appeal_photo;

    /**
     * 申诉状态
     */
    @Enumerated(EnumType.ORDINAL)
    @Column(name = "status")
    private AppealStatus status;

    /**
     * 申诉结果
     */

    @Column(name = "result")
    private String result;

    /**
     * 内网审批机构名称
     */
    @Column(name = "last_approver_depart_name")
    private String lastApproverDepartName;

    /**
     *内网审批人
     */
    @Column( name = "last_approver_name")
    private String lastApproverName;

    /**
     * 审批时间
     */
    @Column(name = "last_approver_time")
    private Timestamp lastApproverTime;

    /**
     * 最后更新时间
     */
    @Column(name = "last_updated_time")
    private Timestamp lastUpdatedTime;

    /**
     * 创建时间
     */
    @Column(nullable = false, name = "created_time")
    private Timestamp createdTime;

    public static TenantUserAppealsEntity create(TenantUserEntity tenantUser, String appeal_photo, String regionCode) {
        TenantUserAppealsEntity tenantUserAppealsEntity = new TenantUserAppealsEntity();
        tenantUserAppealsEntity.setTenantUser(tenantUser);
        tenantUserAppealsEntity.setAppeal_photo(appeal_photo);
        tenantUserAppealsEntity.setRegionCode(regionCode);
        tenantUserAppealsEntity.setStatus(AppealStatus.Request);
        tenantUserAppealsEntity.setCreatedTime(Timestamp.from(Instant.now()));
        tenantUserAppealsEntity.setLastUpdatedTime(Timestamp.from(Instant.now()));
        return tenantUserAppealsEntity;
    }
}
