package com.bcxin.tenant.domain.v5.eventHandlers;

import com.bcxin.Infrastructures.events.handlers.DomainEventHandlerAbstract;
import com.bcxin.tenant.domain.entities.DepartmentEntity;
import com.bcxin.tenant.domain.events.DepartmentUpdatedEvent;
import com.bcxin.tenant.domain.v5.dispatches.DataDispatcher;
import com.bcxin.tenant.domain.v5.services.TDepartmentService;
import com.bcxin.tenant.domain.v5.services.commands.SyncDepartmentCommand;
import org.springframework.stereotype.Component;

@Component
public class V5DepartmentEditedEventHandler extends DomainEventHandlerAbstract<DepartmentUpdatedEvent> {
    private final DataDispatcher dataDispatcher;
    private final TDepartmentService departmentService;

    public V5DepartmentEditedEventHandler(DataDispatcher dataDispatcher, TDepartmentService departmentService) {
        this.dataDispatcher = dataDispatcher;
        this.departmentService = departmentService;
    }

    @Override
    protected void execute(DepartmentUpdatedEvent event) {
        DepartmentEntity department = event.getData();

        String superior = null;
        if (department.getParent() != null) {
            superior = department.getParent().getId();
        }

        SyncDepartmentCommand command = SyncDepartmentCommand.create(
                department.getId(), department.getName(),
                superior, department.getOrganization().getId(),
                department.getLevel());

        this.departmentService.create(command);
    }
}
