package com.bcxin.tenant.domain.v5.dispatches.requests;

import com.bcxin.tenant.domain.v5.snapshots.dataexchanges.DomainValueSnapshot;
import com.bcxin.tenant.domain.v5.snapshots.dataexchanges.ValueSnapshot;

public class DomainDispatchRequest extends DispatchRequestAbstract {
    public DomainDispatchRequest(DispatchType dispatchType, ValueSnapshot valueSnapshot) {
        super(dispatchType, valueSnapshot);
    }

    @Override
    public String getConfigKey() {
        return "domain";
    }

    public static DomainDispatchRequest create(DispatchType dispatchType,
                                               DomainValueSnapshot domainVO) {

        return new DomainDispatchRequest(dispatchType, domainVO);
    }
}
