package com.bcxin.tenant.domain.v5.entities;

import com.bcxin.Infrastructures.entities.EntityAbstract;
import com.bcxin.Infrastructures.entities.IAggregate;
import com.bcxin.Infrastructures.utils.UUIDUtil;
import com.bcxin.tenant.domain.v5.constants.IdCartConstant;
import com.bcxin.tenant.domain.v5.enums.IdCardType;
import lombok.AccessLevel;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import java.util.UUID;

@Getter
@Setter(AccessLevel.PROTECTED)
@Table(name = "t_user")
@Entity
public class TUserEntity extends EntityAbstract implements IAggregate {
    @Id
    private String id;

    @Column(name = "name")
    private String name;

    @Column(name = "loginno")
    private String loginNo;

    @Column(name = "LOGINPWD")
    private String password;

    @Column(name = "domainid")
    private String domainId;

    @Column(name = "dimission")
    private Integer dimission;

    @Column(name = "LEVELS")
    private Integer levels;

    @Column(name = "STATUS")
    private Integer status;

    @Column(name = "LIAISON_OFFICER")
    private Integer liaisonOfficer;

    @Column(name = "TELEPHONEPUBLIC")
    private Integer telephonePublic;

    @Column(name = "TELEPHONEPUBLIC2")
    private Integer telephonePublic2;

    @Column(name = "EMAILPUBLIC")
    private Integer emailPublic;

    @Column(name = "USERINFOPUBLIC")
    private Integer userInfoPublic;

    @Column(name = "DEFAULTDEPARTMENT")
    private String defaultDepartId;

    @Column(name = "PERMISSION_TYPE")
    private String permissionType;

    @Column(name = "field11")
    private String credentialType;


    @Column(name = "field12")
    private String credentialNumber;

    /**
     * 这样定义可以表示为可空，但是int不行
     */
    @Column(name = "ISDOMAINUSER")
    private String domainUser;

    @Column(name = "TELEPHONE")
    private String telephone;


    public void change(String name, String loginNo) {
        this.setName(name);
        this.setLoginNo(loginNo);
    }

    public void change(String defaultDepartId, boolean isDomainUser) {
        this.setDomainUser(isDomainUser ? "1" : "0");
        this.setDefaultDepartId(defaultDepartId);
    }

    public void changeNumber(String credentialType, String credentialNumber) {
        this.setCredentialNumber(credentialNumber);
        if (credentialType != null) {
            switch (credentialType) {
                case IdCartConstant.IdCardType.IdCard:
                    this.setCredentialType(IdCardType.IdCard.getText());
                    break;
                case IdCartConstant.IdCardType.IdCardOfXiangGang:
                    this.setCredentialType(IdCardType.IdCardOfXiangGang.getText());
                    break;
                case IdCartConstant.IdCardType.IdCardOfAoMen:
                    this.setCredentialType(IdCardType.IdCardOfAoMen.getText());
                    break;
                case IdCartConstant.IdCardType.IdCardOfTaiwan:
                    this.setCredentialType(IdCardType.IdCardOfTaiwan.getText());
                    break;
                case IdCartConstant.IdCardType.Passport:
                    this.setCredentialType(IdCardType.Passport.getText());
                    break;
                case IdCartConstant.IdCardType.Arms:
                    this.setCredentialType(IdCardType.Arms.getText());
                    break;
                case IdCartConstant.IdCardType.PoliceNo:
                    this.setCredentialType(IdCardType.PoliceNo.getText());
                    break;
            }
        }

    }

    public void markDeleted() {
        if (this.getDimission() == 1) {
            /*
            //不要删除用户
            String newLoginNo = String.format("DEL_%s", UUIDUtil.getShortUuid());
            if (newLoginNo.length() > 20) {
                newLoginNo = newLoginNo.substring(0, 20);
            }
            this.setLoginNo(newLoginNo);
             */

            this.setDimission(0);
        }
    }

    public void markUnDeleted()
    {
        this.setDimission(1);
    }

    protected TUserEntity() {
        this.setLevels(0);
        this.setStatus(1);
        this.setLiaisonOfficer(1);
        this.setTelephonePublic(1);
        this.setTelephonePublic2(1);
        this.setEmailPublic(1);
        this.setUserInfoPublic(1);
        this.setPermissionType("public");
    }

    public static TUserEntity create(String id, String name, String loginNo, String domainId,String telephone) {
        TUserEntity tUser = new TUserEntity();
        tUser.setId(id);

        tUser.change(name, loginNo);
        tUser.setDomainId(domainId);
        tUser.setDimission(1);
        tUser.setTelephone(telephone);
        tUser.setPassword(String.format("invalid%s", UUID.randomUUID()));

        return tUser;
    }
}
