/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.bus.domains.components.impls;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.http.HttpUtil;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.bcxin.Infrastructures.exceptions.ArgumentTenantException;
import com.bcxin.Infrastructures.exceptions.BadTenantException;
import com.bcxin.bus.domains.BusConfigProperty;
import com.bcxin.bus.domains.components.MessageProvider;
import com.bcxin.bus.domains.utils.MD5Util;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class SmsMessageProviderImpl
implements MessageProvider {
    public static final String PLATFORM = "platform";
    public static final String SMS_CODE = "smsCode";
    public static final String MOBILE = "mobile";
    private final BusConfigProperty.SmsMessageConfig smsMessageConfig;
    private static AtomicInteger _counter = new AtomicInteger(1);

    public SmsMessageProviderImpl(BusConfigProperty configProperty) {
        this.smsMessageConfig = configProperty.getSms();
        if (this.smsMessageConfig == null) {
            throw new BadTenantException("\u521d\u59cb\u5316\u53c2\u6570\u4e0d\u6b63\u786e");
        }
    }

    @Override
    public void execute(Map<String, Object> params) {
        int value;
        if (!params.containsKey(SMS_CODE)) {
            throw new ArgumentTenantException(String.format("\u77ed\u4fe1\u670d\u52a1\u4e2d\u7684: %s\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", SMS_CODE));
        }
        if (!params.containsKey(MOBILE)) {
            throw new ArgumentTenantException(String.format("\u77ed\u4fe1\u670d\u52a1\u4e2d\u7684: %s\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", MOBILE));
        }
        String telephone = this.getTelephone(params);
        String smsCode = (String)params.get(SMS_CODE);
        if (this.smsMessageConfig.getReceivers() != null && this.smsMessageConfig.getReceivers().size() > 0 && "B98".equals(smsCode) && (value = _counter.incrementAndGet()) % 500000 != 0 && value > 0) {
            System.err.println(String.format("\u4e0d\u53d1\u9001\u65b0\u589e\u7528\u6237\u7684\u77ed\u4fe1:%s-\u6a21\u677f=%s", telephone, smsCode));
            return;
        }
        HashMap<String, Object> huaWeiSmsContent = new HashMap<String, Object>();
        huaWeiSmsContent.put("channel", null);
        huaWeiSmsContent.put(PLATFORM, "V5");
        huaWeiSmsContent.put(SMS_CODE, smsCode);
        huaWeiSmsContent.put(MOBILE, telephone);
        huaWeiSmsContent.put("params", params.get("params"));
        huaWeiSmsContent.put("envi", this.smsMessageConfig.getEnvi());
        HashMap<String, String> smsMessageParams = new HashMap<String, String>();
        String randomKey = RandomUtil.randomNumbers((int)6);
        smsMessageParams.put("randomKey", randomKey);
        smsMessageParams.put("data", JSON.toJSONString(huaWeiSmsContent));
        smsMessageParams.put("token", MD5Util.string2MD5(String.format("BCXIN%s%s%s", telephone, DateUtil.today(), randomKey)));
        String responseContent = HttpUtil.post((String)this.smsMessageConfig.getApi(), smsMessageParams);
        JSONObject jsonObject = JSONUtil.parseObj((String)responseContent);
        String status = (String)jsonObject.get((Object)"status");
        if (StringUtils.hasLength((String)status) && status.equals("200")) {
            try {
                System.err.println(String.format("%s: \u77ed\u4fe1\u53d1\u9001\u6210\u529f:\u624b\u673a=%s;smsCode=%s;envi=%s; \u7ed3\u679c=%s", new Date(), telephone, smsCode, this.smsMessageConfig.getEnvi(), responseContent));
            }
            catch (Exception ex) {
                System.err.println("\u77ed\u4fe1\u8f93\u51fa\u6253\u5370\u5931\u8d25");
                ex.printStackTrace();
            }
            return;
        }
        try {
            System.err.println(String.format("\u77ed\u4fe1\u53d1\u9001\u5931\u8d25:request=%s:response=%s", JSONUtil.parseObj(smsMessageParams), responseContent));
        }
        catch (Exception ex) {
            System.err.println(String.format("\u77ed\u4fe1\u53d1\u9001\u5931\u8d25:response=%s", responseContent));
            ex.printStackTrace();
        }
        throw new BadTenantException(String.format("\u77ed\u4fe1\u53d1\u9001\u5931\u8d25:%s", responseContent));
    }

    public static String verificationCode() {
        Random random = new Random();
        String result = "";
        for (int i = 0; i < 6; ++i) {
            result = result + random.nextInt(10);
        }
        return result;
    }

    private String getTelephone(Map<String, Object> params) {
        String telephone = (String)params.get(MOBILE);
        return this.smsMessageConfig.getFormattedReceiver(telephone);
    }
}

