package com.bcxin.autodownloadupload.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bcxin.autodownloadupload.dao.mapper.PushRecordSqlLogMapper;
import com.bcxin.autodownloadupload.entity.PushRecordSqlLog;
import com.bcxin.autodownloadupload.service.PushRecordSqlLogService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.util.Date;

/**
 * description: 推送sql执行日志表service
 * author: linchunpeng
 * date:  2023-04-19 14:08
 */
@Slf4j
@Service
public class PushRecordSqlLogServiceImpl extends ServiceImpl<PushRecordSqlLogMapper, PushRecordSqlLog> implements PushRecordSqlLogService {


    /**
     * description: 新增日志
     * author: linchunpeng
     * date:  2023-04-21 10:27
     */
    @Override
    public void createLog(String requestId, Long pushRecordId, String fileName, long fileSize, Date startTime, Date endTime, String execResult) {
        PushRecordSqlLog  pushRecordSqlLog = new PushRecordSqlLog();
        pushRecordSqlLog.setRequestId(requestId);
        pushRecordSqlLog.setPushRecordId(pushRecordId);
        pushRecordSqlLog.setFileName(fileName);
        pushRecordSqlLog.setFileSize("" + fileSize);
        pushRecordSqlLog.setStartTime(startTime);
        pushRecordSqlLog.setEndTime(endTime);
        pushRecordSqlLog.setExecResult(StringUtils.length(execResult) > 2000 ? execResult.substring(0, 2000) : execResult);
        pushRecordSqlLog.setCreateTime(new Date());
        this.save(pushRecordSqlLog);
    }


}
