package com.bcxin.autodownloadupload.entity;

import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.util.Date;

/**
 * description: 推送sql执行日志表
 * author: linchunpeng
 * date:  2023-04-21 10:05
 */
@Data
@TableName("push_record_sql_log")
public class PushRecordSqlLog {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id")
    private Long id;

    //请求id
    private String requestId;

    //推送记录id
    private Long pushRecordId;

    //sql文件路径
    private String fileName;

    //文件大小
    private String fileSize;

    //执行sql的开始时间
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    private Date startTime;

    //执行sql的结束时间
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    private Date endTime;

    //访问结果
    private String execResult;

    //创建时间
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    private Date createTime;

}
