/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.autodownloadupload.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bcxin.autodownloadupload.configs.PullConfig;
import com.bcxin.autodownloadupload.dao.mapper.PullRecordMapper;
import com.bcxin.autodownloadupload.dtos.ChangeLogsRequestDto;
import com.bcxin.autodownloadupload.entity.PullRecord;
import com.bcxin.autodownloadupload.service.PullRecordService;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class PullRecordServiceImpl
extends ServiceImpl<PullRecordMapper, PullRecord>
implements PullRecordService {
    private static final Logger log = LoggerFactory.getLogger(PullRecordServiceImpl.class);
    @Value(value="${spring.profiles.active}")
    private String activeFile;
    private static final String OBPM2_NAME_ENV = "out-te;out-prod;out-pre;out-jincheng;out-dev;";

    public PullRecord createRecord(Long autoFerryTaskId, PullConfig pullConfig, ChangeLogsRequestDto requestDto, int pullType, String regionCode) {
        PullRecord record = new PullRecord();
        if (autoFerryTaskId != null) {
            record.setId(autoFerryTaskId);
        }
        record.setRequestApi(pullConfig.getApi());
        record.setRegionCode(regionCode);
        record.setStartTime(requestDto.getFromTime());
        record.setEndTime(requestDto.getEndTime());
        if (CollectionUtil.isNotEmpty((Collection)requestDto.getTables())) {
            record.setTables(String.join((CharSequence)";", requestDto.getTables()));
        }
        record.setRemoveRepeat(requestDto.getIsRemoveRepeat());
        record.setPullType(Integer.valueOf(pullType));
        record.setCreateTime(new Date());
        this.save((Object)record);
        return record;
    }

    public PullRecord getByRequestId(String requestId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"request_id", (Object)requestId);
        List list = this.list((Wrapper)queryWrapper);
        if (CollectionUtil.isEmpty((Collection)list)) {
            return null;
        }
        return (PullRecord)list.get(list.size() - 1);
    }

    public PullRecord getLastRecord(String regionCode) {
        LambdaQueryChainWrapper lqw = this.lambdaQuery();
        lqw.eq(PullRecord::getRegionCode, (Object)regionCode);
        lqw.orderByDesc(PullRecord::getCreateTime);
        lqw.last("LIMIT 3");
        List list = lqw.list();
        if (CollectionUtil.isEmpty((Collection)list)) {
            return null;
        }
        return (PullRecord)list.get(0);
    }

    public PullRecord getLastSameTimeRecord(String regionCode, Date startTime, Long id) {
        LambdaQueryChainWrapper lqw = this.lambdaQuery();
        lqw.ne(PullRecord::getId, (Object)id);
        lqw.eq(PullRecord::getRegionCode, (Object)regionCode);
        lqw.eq(PullRecord::getStartTime, (Object)startTime);
        lqw.orderByDesc(PullRecord::getCreateTime);
        lqw.last("LIMIT 3");
        List list = lqw.list();
        if (CollectionUtil.isEmpty((Collection)list)) {
            return null;
        }
        return (PullRecord)list.get(0);
    }

    public String selectErrorSyncChangeLogs(String id) {
        if (OBPM2_NAME_ENV.contains(this.activeFile)) {
            return ((PullRecordMapper)this.baseMapper).selectErrorSyncChangeLogsOut(id);
        }
        return ((PullRecordMapper)this.baseMapper).selectErrorSyncChangeLogsIn(id);
    }
}

