/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ferry.service;

import com.alibaba.fastjson.JSONObject;
import com.bcxin.ferry.common.utils.HttpUtil;
import com.bcxin.ferry.configs.BaiduutilServerConfig;
import com.bcxin.ferry.dtos.baiduutil.ChangeLogsRequestDto;
import com.bcxin.ferry.dtos.baiduutil.FerryReceiveTaskPushResult;
import com.bcxin.ferry.dtos.baiduutil.FerryTaskPullResult;
import com.bcxin.ferry.entity.FerryReceiveTaskEntity;
import com.bcxin.ferry.entity.FerryTaskEntity;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.retry.annotation.Backoff;
import org.springframework.retry.annotation.Retryable;
import org.springframework.stereotype.Service;

@Service
public class RetryService {
    private static final Logger log = LoggerFactory.getLogger(RetryService.class);
    @Autowired
    private BaiduutilServerConfig baiduutilServerConfig;
    @Value(value="${spring.profiles.active}")
    private String activeFile;

    @Retryable(value={Exception.class}, maxAttempts=3, backoff=@Backoff(delay=10000L, maxDelay=60000L, multiplier=2.0))
    public ChangeLogsRequestDto postToBaiduutilServerPull(FerryTaskEntity ferryTaskEntity) {
        ChangeLogsRequestDto requestDto = new ChangeLogsRequestDto();
        requestDto.setFromTime(ferryTaskEntity.getStartTime());
        requestDto.setEndTime(ferryTaskEntity.getEndTime());
        requestDto.setRegionCodes(ferryTaskEntity.getRegionCode());
        requestDto.setTables(new ArrayList());
        requestDto.setAutoFerryTaskId(ferryTaskEntity.getId());
        requestDto.setNeedServerTimeCheck(Boolean.valueOf(true));
        String pullResult = HttpUtil.post((String)this.baiduutilServerConfig.getRequestApi(ferryTaskEntity.getRegionCode()).getPullUrl(), (String)JSONObject.toJSONString((Object)requestDto));
        if ("fail".equals(pullResult)) {
            log.error("\u8c03\u7528\u6446\u6e21\u5de5\u5177\u670d\u52a1\u63a5\u53e3\u5931\u8d25");
            throw new RuntimeException("\u8c03\u7528\u6446\u6e21\u5de5\u5177\u670d\u52a1\u63a5\u53e3\u5931\u8d25");
        }
        JSONObject result = JSONObject.parseObject((String)pullResult);
        if (result.get((Object)"code") == null || result.getInteger("code") != 200) {
            log.error("\u8c03\u7528\u6446\u6e21\u5de5\u5177\u670d\u52a1\u63a5\u53e3\u5931\u8d25");
            throw new RuntimeException("\u8c03\u7528\u6446\u6e21\u5de5\u5177\u670d\u52a1\u63a5\u53e3\u5931\u8d25");
        }
        if (!"\u8c03\u7528\u6210\u529f".equals(result.getString("message"))) {
            String messageStr = result.getString("message");
            if (messageStr == null) {
                log.error("\u8c03\u7528\u6446\u6e21\u5de5\u5177\u670d\u52a1\u63a5\u53e3\u5931\u8d25\uff0cmessage\u5b57\u6bb5\u4e3anull");
                throw new RuntimeException("\u8c03\u7528\u6446\u6e21\u5de5\u5177\u670d\u52a1\u63a5\u53e3\u5931\u8d25\uff0cmessage\u5b57\u6bb5\u4e3anull");
            }
            try {
                ChangeLogsRequestDto message = (ChangeLogsRequestDto)JSONObject.parseObject((String)messageStr, ChangeLogsRequestDto.class);
                return message;
            }
            catch (Exception e) {
                log.error("\u8c03\u7528\u6446\u6e21\u5de5\u5177\u670d\u52a1\u63a5\u53e3\u5931\u8d25\uff0cmessage\u4e0d\u662fjson\u683c\u5f0f: {}", (Object)messageStr, (Object)e);
                throw new RuntimeException("\u8c03\u7528\u6446\u6e21\u5de5\u5177\u670d\u52a1\u63a5\u53e3\u5931\u8d25\uff0cmessage\u4e0d\u662fjson\u683c\u5f0f");
            }
        }
        log.info("\u8c03\u7528\u6446\u6e21\u5de5\u5177\u670d\u52a1\u63a5\u53e3\u6210\u529f");
        return null;
    }

    @Retryable(value={Exception.class}, maxAttempts=3, backoff=@Backoff(delay=10000L, maxDelay=60000L, multiplier=2.0))
    public void postToBaiduutilServerPush(FerryReceiveTaskEntity receiveTaskEntity) {
        String pullResult;
        String regionCode = "";
        if (this.activeFile.contains("out") && receiveTaskEntity.getRequestId().contains("zw")) {
            regionCode = "govout-to-govin";
        }
        if ("fail".equals(pullResult = HttpUtil.post((String)this.baiduutilServerConfig.getRequestApi(regionCode).getPushUrl().concat(receiveTaskEntity.getRequestId()).concat("?isNeedUnzip=true"), (String)"{}"))) {
            log.error("\u8c03\u7528\u6446\u6e21\u5de5\u5177\u670d\u52a1\u63a5\u53e3\u5931\u8d25");
            throw new RuntimeException("\u8c03\u7528\u6446\u6e21\u5de5\u5177\u670d\u52a1\u63a5\u53e3\u5931\u8d25");
        }
        JSONObject result = JSONObject.parseObject((String)pullResult);
        if (result.get((Object)"code") == null || result.getInteger("code") != 200) {
            log.error("\u8c03\u7528\u6446\u6e21\u5de5\u5177\u670d\u52a1\u63a5\u53e3\u5931\u8d25");
            throw new RuntimeException("\u8c03\u7528\u6446\u6e21\u5de5\u5177\u670d\u52a1\u63a5\u53e3\u5931\u8d25");
        }
        log.info("\u8c03\u7528\u6446\u6e21\u5de5\u5177\u670d\u52a1\u63a5\u53e3\u6210\u529f");
    }

    public FerryTaskPullResult postToBaiduutilServerPullResult(FerryTaskEntity ferryTaskEntity) {
        ChangeLogsRequestDto requestDto = new ChangeLogsRequestDto();
        requestDto.setAutoFerryTaskId(ferryTaskEntity.getId());
        String pullResult = HttpUtil.post((String)this.baiduutilServerConfig.getRequestApi(ferryTaskEntity.getRegionCode()).getPullQueryResultUrl(), (String)JSONObject.toJSONString((Object)requestDto));
        if ("fail".equals(pullResult)) {
            log.error("\u8c03\u7528\u6446\u6e21\u5de5\u5177\u670d\u52a1\u63a5\u53e3\u5931\u8d25");
            throw new RuntimeException("\u8c03\u7528\u6446\u6e21\u5de5\u5177\u670d\u52a1\u63a5\u53e3\u5931\u8d25");
        }
        JSONObject result = JSONObject.parseObject((String)pullResult);
        if (result.get((Object)"id") == null) {
            log.error("\u8c03\u7528\u6446\u6e21\u5de5\u5177\u670d\u52a1\u63a5\u53e3\u5931\u8d25");
            throw new RuntimeException("\u8c03\u7528\u6446\u6e21\u5de5\u5177\u670d\u52a1\u63a5\u53e3\u5931\u8d25");
        }
        log.info("\u8c03\u7528\u6446\u6e21\u5de5\u5177\u670d\u52a1\u63a5\u53e3\u6210\u529f");
        return (FerryTaskPullResult)JSONObject.parseObject((String)pullResult, FerryTaskPullResult.class);
    }

    public FerryReceiveTaskPushResult postToBaiduutilServerPushResult(FerryReceiveTaskEntity receiveTaskEntity) {
        String pullResult;
        String regionCode = "";
        if (this.activeFile.contains("out") && receiveTaskEntity.getRequestId().contains("zw")) {
            regionCode = "govout-to-govin";
        }
        if ("fail".equals(pullResult = HttpUtil.post((String)this.baiduutilServerConfig.getRequestApi(regionCode).getPushQueryResultUrl().concat(receiveTaskEntity.getRequestId()), (String)"{}"))) {
            log.error("\u8c03\u7528\u6446\u6e21\u5de5\u5177\u670d\u52a1\u63a5\u53e3\u5931\u8d25");
            throw new RuntimeException("\u8c03\u7528\u6446\u6e21\u5de5\u5177\u670d\u52a1\u63a5\u53e3\u5931\u8d25");
        }
        JSONObject result = JSONObject.parseObject((String)pullResult);
        if (result.get((Object)"requestId") == null) {
            log.error("\u8c03\u7528\u6446\u6e21\u5de5\u5177\u670d\u52a1\u63a5\u53e3\u5931\u8d25");
            throw new RuntimeException("\u8c03\u7528\u6446\u6e21\u5de5\u5177\u670d\u52a1\u63a5\u53e3\u5931\u8d25");
        }
        log.info("\u8c03\u7528\u6446\u6e21\u5de5\u5177\u670d\u52a1\u63a5\u53e3\u6210\u529f");
        return (FerryReceiveTaskPushResult)JSONObject.parseObject((String)pullResult, FerryReceiveTaskPushResult.class);
    }
}

