/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ferry.service;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.io.FileUtil;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bcxin.ferry.common.emus.FerryReceiveTaskStatusEnum;
import com.bcxin.ferry.common.utils.DateUtil;
import com.bcxin.ferry.common.utils.IdGeneratorSnowflake;
import com.bcxin.ferry.configs.FerryChannelConfig;
import com.bcxin.ferry.configs.FerrySwitchConfig;
import com.bcxin.ferry.configs.ReceiveConfig;
import com.bcxin.ferry.dao.mapper.FerryReceiveTaskMapper;
import com.bcxin.ferry.dtos.baiduutil.FerryReceiveTaskPushResult;
import com.bcxin.ferry.entity.FerryReceiveTaskEntity;
import com.bcxin.ferry.service.FerryTaskService;
import com.bcxin.ferry.service.RetryService;
import java.io.File;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class FerryReceiveTaskService
extends ServiceImpl<FerryReceiveTaskMapper, FerryReceiveTaskEntity> {
    private static final Logger log = LoggerFactory.getLogger(FerryReceiveTaskService.class);
    @Autowired
    private ReceiveConfig receiveConfig;
    @Autowired
    private FerrySwitchConfig ferrySwitchConfig;
    @Autowired
    private IdGeneratorSnowflake snowflake;
    @Autowired
    private RetryService retryService;
    @Autowired
    private FerryTaskService ferryTaskService;
    @Autowired
    private FerryChannelConfig ferryChannelConfig;
    @Value(value="${spring.profiles.active}")
    private String activeFile;

    @Transactional
    public FerryReceiveTaskEntity receiveRequest(String requestId) {
        log.info("\u63a5\u6536\u6446\u6e21\u4efb\u52a1\u6587\u4ef6");
        LambdaQueryChainWrapper lqw = this.lambdaQuery();
        lqw.eq(FerryReceiveTaskEntity::getRequestId, (Object)requestId);
        if (!lqw.exists()) {
            log.info("\u521b\u5efa\u63a5\u6536\u4efb\u52a1");
            FerryReceiveTaskEntity receiveTaskEntity = new FerryReceiveTaskEntity();
            receiveTaskEntity.setId(Long.valueOf(this.snowflake.snowflakeId()));
            receiveTaskEntity.setRequestId(requestId);
            receiveTaskEntity.setPackageUrl(this.receiveConfig.getPackageUrl().concat(requestId).concat(".zip"));
            receiveTaskEntity.setTaskStatus(Integer.valueOf(FerryReceiveTaskStatusEnum.RECEIVE_REQUEST.getCode()));
            receiveTaskEntity.setCreateTime(new Date());
            receiveTaskEntity.setUpdateTime(new Date());
            this.save((Object)receiveTaskEntity);
            return receiveTaskEntity;
        }
        return (FerryReceiveTaskEntity)lqw.list().get(0);
    }

    @Transactional
    public void pushData(FerryReceiveTaskEntity receiveTaskEntity) {
        log.info("\u8c03\u7528\u6446\u6e21\u5de5\u5177\u670d\u52a1\uff0c\u63a8\u9001\u6570\u636e");
        if (receiveTaskEntity != null) {
            this.retryService.postToBaiduutilServerPush(receiveTaskEntity);
            receiveTaskEntity.setTaskStatus(Integer.valueOf(FerryReceiveTaskStatusEnum.PUSH_DATA.getCode()));
            receiveTaskEntity.setUpdateTime(new Date());
            this.updateById((Object)receiveTaskEntity);
        }
    }

    @Transactional
    public void queryReceiveTaskIsComplete() {
        LambdaQueryChainWrapper lqw = this.lambdaQuery();
        lqw.eq(FerryReceiveTaskEntity::getTaskStatus, (Object)FerryReceiveTaskStatusEnum.PUSH_DATA.getCode());
        List list = lqw.list();
        if (CollectionUtil.isNotEmpty((Collection)list)) {
            for (FerryReceiveTaskEntity receiveTaskEntity : list) {
                if (receiveTaskEntity == null) continue;
                log.info("\u67e5\u8be2\u662f\u5426\u6709\u6446\u6e21\u5b8c\u6210\u7684\u4efb\u52a1\uff0crequestId\uff1a{}", (Object)receiveTaskEntity.getRequestId());
                FerryReceiveTaskPushResult result = this.retryService.postToBaiduutilServerPushResult(receiveTaskEntity);
                if (result == null || result.getTaskStatus() == null) continue;
                receiveTaskEntity.setReceiveResult(result.getReceiveResult());
                receiveTaskEntity.setTaskStatus(result.getTaskStatus());
                receiveTaskEntity.setUpdateTime(new Date());
                this.updateById((Object)receiveTaskEntity);
            }
        }
    }

    @Transactional
    public List<FerryReceiveTaskEntity> queryReceiveTaskComplete() {
        log.info("\u67e5\u8be2\u662f\u5426\u6709\u6446\u6e21\u5b8c\u6210\u7684\u4efb\u52a1");
        LambdaQueryChainWrapper lqw = this.lambdaQuery();
        lqw.eq(FerryReceiveTaskEntity::getTaskStatus, (Object)FerryReceiveTaskStatusEnum.FERRY_COMPLETE.getCode());
        return lqw.list();
    }

    @Transactional
    public void sendCompleteFile(FerryReceiveTaskEntity receiveTaskEntity) {
        log.info("\u751f\u6210.complete\u6587\u4ef6");
        String completeFile = this.receiveConfig.getPackageUrl().concat(receiveTaskEntity.getRequestId()).concat(".complete");
        try {
            if (this.ferrySwitchConfig.getEnablePull() != null && this.ferrySwitchConfig.getEnablePull().booleanValue()) {
                log.info("===================================\u6709\u5f00\u542f\u62c9\u53d6\u6446\u6e21\u5305\uff0c\u624d\u9700\u8981\u653e\u5165\u901a\u9053===================================");
                FileUtil.appendUtf8String((String)String.format("%s.zip\u6446\u6e21\u5b8c\u6210\uff0c\u56de\u8c03\u5bf9\u7aef\uff0c\u544a\u77e5\u6446\u6e21\u5b8c\u6210\uff0c\u4fee\u6539\u72b6\u6001\u3002", receiveTaskEntity.getRequestId()), (String)completeFile);
                String targetFilePath = this.ferryChannelConfig.getSendPath().concat(File.separator).concat(DateUtil.formatDate((Date)new Date())).concat(File.separator).concat(receiveTaskEntity.getRequestId()).concat(".complete");
                this.ferryTaskService.copyFileToFerryChannel(completeFile, targetFilePath);
            } else {
                log.info("===================================\u6ca1\u6709\u5f00\u542f\u62c9\u53d6\u6446\u6e21\u5305\uff0c\u4e0d\u9700\u8981\u653e\u5165\u901a\u9053===================================");
            }
            receiveTaskEntity.setTaskStatus(Integer.valueOf(FerryReceiveTaskStatusEnum.CALLBACK_COMPLETE.getCode()));
            receiveTaskEntity.setUpdateTime(new Date());
            this.updateById((Object)receiveTaskEntity);
        }
        catch (Exception e) {
            log.error("\u521b\u5efa{}.complete\u6587\u4ef6\u5931\u8d25\uff0c{}", new Object[]{receiveTaskEntity.getRequestId(), e.getMessage(), e});
            e.printStackTrace();
        }
    }
}

