/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ferry.dtos.response.result;

import com.bcxin.ferry.common.emus.StatusCode;
import com.bcxin.ferry.dtos.response.result.AbstractRespResult;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

@JsonPropertyOrder(value={"code", "msg", "timestamp", "data"})
public class RespResult<V>
extends AbstractRespResult {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private V data;

    protected RespResult(V result) {
        if (result == null) {
            Type[] actualTypeArguments;
            Type superClass = this.getClass().getGenericSuperclass();
            if (superClass == null) {
                this.data = new HashMap();
            } else if (superClass instanceof ParameterizedType && (actualTypeArguments = ((ParameterizedType)superClass).getActualTypeArguments()) != null && actualTypeArguments.length > 0) {
                Class clazz = (Class)actualTypeArguments[0];
                this.data = List.class.isAssignableFrom(clazz) ? new ArrayList() : new HashMap();
            }
        } else {
            this.data = result;
        }
    }

    protected RespResult(StatusCode statusCode, String message) {
        super(statusCode, message);
    }

    protected RespResult(int code, String message) {
        super(code, message);
    }

    protected RespResult(int code, String message, V result) {
        super(code, message);
        this.data = result;
    }

    public static final <T> RespResult<T> failure(StatusCode statusCode) {
        return new RespResult(statusCode, statusCode.getDefaultMessage());
    }

    public static final <T> RespResult<T> failure(int statusCode, String message) {
        return new RespResult(statusCode, message);
    }

    public static final <T> RespResult<T> failure(int statusCode, String message, T result) {
        return new RespResult(statusCode, message, result);
    }

    public static final <T> RespResult<T> successful() {
        return new RespResult(StatusCode.succeed, StatusCode.succeed.getDefaultMessage());
    }

    public static final <T> RespResult<T> successful(String message) {
        return new RespResult(StatusCode.succeed, message);
    }

    public static final <T> RespResult<T> create(int statusCode, String message, T result) {
        return new RespResult(statusCode, message, result);
    }

    public static final <T> RespResult<T> successful(T result) {
        return new RespResult(result);
    }

    public V getData() {
        return (V)this.data;
    }
}

