/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ferry.dtos.response.result;

import com.bcxin.ferry.common.emus.StatusCode;
import com.bcxin.ferry.dtos.response.result.AbstractRespResult;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonPropertyOrder(value={"code", "msg", "timestamp"})
public class ErrorRespResult
extends AbstractRespResult {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String debugMsg;

    protected ErrorRespResult(int code, String message) {
        super(code, message);
    }

    protected ErrorRespResult(int code, String message, String debugMsg) {
        super(code, message);
        this.debugMsg = debugMsg == null ? "" : debugMsg;
    }

    protected ErrorRespResult(StatusCode statusCode, String message) {
        super(statusCode, message);
    }

    protected ErrorRespResult(StatusCode statusCode, String message, String debugMsg) {
        super(statusCode, message);
        this.debugMsg = debugMsg == null ? "" : debugMsg;
    }

    public static final ErrorRespResult fail(int code, String errorMessage) {
        return new ErrorRespResult(code, errorMessage);
    }

    public static final ErrorRespResult fail(int code, String errorMessage, String debugMsg) {
        return new ErrorRespResult(code, errorMessage, debugMsg);
    }

    public static final ErrorRespResult fail(StatusCode statusCode, String errorMessage) {
        return new ErrorRespResult(statusCode, errorMessage);
    }

    public static final ErrorRespResult fail(StatusCode statusCode, String errorMessage, String debugMsg) {
        return new ErrorRespResult(statusCode, errorMessage, debugMsg);
    }

    public String getDebugMsg() {
        return this.debugMsg;
    }
}

