/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ferry.ascept;

import com.alibaba.fastjson.JSONObject;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.AntPathMatcher;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Component
@Aspect
public class AuthAspect {
    private static final Logger log = LoggerFactory.getLogger(AuthAspect.class);
    private AntPathMatcher antPathMatcher = new AntPathMatcher();

    @Around(value="execution(* com.bcxin.ferry.controller.*.*(..))")
    public Object doAround(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)requestAttributes;
        HttpServletRequest request = servletRequestAttributes.getRequest();
        String appid = request.getHeader("appid");
        String secret = request.getHeader("secret");
        String requestId = UUID.randomUUID().toString();
        log.info("\u8bf7\u6c42id\uff1a{}\uff0c\u8bf7\u6c42\u5730\u5740\uff1a{}\uff0c\u8bf7\u6c42\u5934\u90e8\uff1aappid={}\uff0csecret={}", new Object[]{requestId, request.getRequestURI(), appid, secret});
        request.setAttribute("API_REQUEST_ID", (Object)requestId);
        if (this.isMatch(request.getRequestURI(), this.getPublicUris())) {
            Object proceed = proceedingJoinPoint.proceed(proceedingJoinPoint.getArgs());
            log.info("\u8bf7\u6c42id\uff1a{}\uff0c\u8bf7\u6c42\u5730\u5740\uff1a{}\uff0c\u8fd4\u56de\u53c2\u6570\uff1a{}", new Object[]{requestId, request.getRequestURI(), JSONObject.toJSONString((Object)proceed)});
            return proceed;
        }
        Object proceed = proceedingJoinPoint.proceed(proceedingJoinPoint.getArgs());
        log.info("\u8bf7\u6c42id\uff1a{}\uff0c\u8bf7\u6c42\u5730\u5740\uff1a{}\uff0c\u8fd4\u56de\u53c2\u6570\uff1a{}", new Object[]{requestId, request.getRequestURI(), JSONObject.toJSONString((Object)proceed)});
        return proceed;
    }

    private boolean isMatch(String url, List<String> uris) {
        if (uris == null) {
            return false;
        }
        for (String uri : uris) {
            if (!this.antPathMatcher.match(uri, url)) continue;
            return true;
        }
        return false;
    }

    private List<String> getPublicUris() {
        return Arrays.asList("/zidingyi", "/zidingyi2");
    }
}

