package com.bcxin.ferry.configs;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

/**
 * description：定时任务配置
 * author：linchunpeng
 * date：2024/3/8
 */
@Data
@Component
@ConfigurationProperties(prefix = "scheduling-config")
public class SchedulingConfig {

    //创建摆渡任务
    private ConfigDetail createFerryTask;
    //查询摆渡任务状态
    private ConfigDetail queryPullComplete;
    //检测接收摆渡包
    private ConfigDetail detectionReceiveFile;
    //查询接收任务状态-摆渡完成
    private ConfigDetail queryReceiveTaskComplete;

    @Data
    public static class ConfigDetail {
        //定时任务表达式
        private String cron;
        //每次摆渡拉取时间间隔，分钟
        private Integer timeInterval;
    }

}
