package com.bcxin.ferry.common.emus;

/**
 * 接收任务状态，1-接收请求，9-执行推送操作，10-摆渡完成
 */
public enum FerryReceiveTaskStatusEnum {

    //接收请求
    RECEIVE_REQUEST(1, "接收请求"),
    //执行推送操作
    PUSH_DATA(9, "执行推送操作"),
    //摆渡完成
    FERRY_COMPLETE(10, "摆渡完成"),
    //回调完成
    CALLBACK_COMPLETE(11, "回调完成");
    /**
     * 状态代码
     */
    private int code;
    /**
     * 默认消息
     */
    private String defaultMessage;

    FerryReceiveTaskStatusEnum(int code, String defaultMessage) {
        this.code = code;
        this.defaultMessage = defaultMessage;
    }

    /**
     * 获取状态代码
     */
    public int getCode() {
        return this.code;
    }

    /**
     * 获取默认消息
     */
    public String getDefaultMessage() {
        return this.defaultMessage;
    }
}
