package com.bcxin.ferry.scheduling;

import com.bcxin.ferry.service.FerryTaskService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

/**
 * description：查询摆渡任务状态-放入发送文件夹完成
 * author：linchunpeng
 * date：2024/3/8
 */
@Slf4j
@Component
public class QueryPutSendComplete {

    @Autowired
    private FerryTaskService ferryTaskService;

    @Scheduled(cron = "${scheduling-config.query-put-send-complete.cron}")
    public void queryPutSendComplete() {
        log.info("===================================定时查询摆渡任务状态-放入发送文件夹完成===================================");
        ferryTaskService.queryPutSendComplete();
        log.info("===================================查询摆渡任务状态-放入发送文件夹完成结束===================================");
    }

}
