/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.domain.entities;

import com.bcxin.Infrastructures.entities.EntityAbstract;
import com.bcxin.Infrastructures.entities.EventEntityAbstract;
import com.bcxin.Infrastructures.entities.IAggregate;
import com.bcxin.Infrastructures.entities.OpEntityAbstract;
import com.bcxin.Infrastructures.enums.ProcessedStatus;
import com.bcxin.Infrastructures.enums.TrueFalseStatus;
import com.bcxin.tenant.domain.entities.EventSubscribedActionLogEntity;
import com.bcxin.tenant.domain.repositories.EventSubscribedActionLogRepository;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;

@Table(name="tenant_event_subscribers")
@Entity
public class EventSubscriberEntity
extends OpEntityAbstract
implements IAggregate {
    @Id
    private String id;
    @Column(name="name", length=200)
    private String name;
    @Column(name="handler", length=100)
    private String handler;
    @Column(name="selector", length=200)
    private String selector;
    @Column(name="last_version")
    private Long lastVersion;
    @Column(name="pre_version")
    private Long preVersion;
    @Column(name="is_online", nullable=false)
    private TrueFalseStatus isOnline;
    private ProcessedStatus status;

    @Transient
    public Long getFetchVersion() {
        return this.getLastVersion();
    }

    public void error(EventSubscribedActionLogRepository eventSubscribedActionLogRepository, EventEntityAbstract event, ProcessedStatus status, String message) {
        this.addActionLog(eventSubscribedActionLogRepository, event, status, message);
    }

    public void done(EventSubscribedActionLogRepository eventSubscribedActionLogRepository, EventEntityAbstract event, ProcessedStatus status, String message) {
        Long tmpVersion = this.getLastVersion();
        this.setLastVersion(event.getVersion());
        this.setPreVersion(tmpVersion);
        this.addActionLog(eventSubscribedActionLogRepository, event, status, message);
    }

    private void addActionLog(EventSubscribedActionLogRepository eventSubscribedActionLogRepository, EventEntityAbstract event, ProcessedStatus status, String message) {
        message = String.format("subscriber=%s; mapKey=%s; version=%s;:message=%s", this.getHandler(), event.getMapKey(), this.getLastVersion(), message);
        eventSubscribedActionLogRepository.save((EntityAbstract)EventSubscribedActionLogEntity.create(this, event.getId(), event.getVersion(), status, message));
    }

    public String toString() {
        return String.format("subscriber;selector=%s;handler=%s", this.getSelector(), this.getHandler());
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getHandler() {
        return this.handler;
    }

    public String getSelector() {
        return this.selector;
    }

    public Long getLastVersion() {
        return this.lastVersion;
    }

    public Long getPreVersion() {
        return this.preVersion;
    }

    public TrueFalseStatus getIsOnline() {
        return this.isOnline;
    }

    public ProcessedStatus getStatus() {
        return this.status;
    }

    protected void setId(String id) {
        this.id = id;
    }

    protected void setName(String name) {
        this.name = name;
    }

    protected void setHandler(String handler) {
        this.handler = handler;
    }

    protected void setSelector(String selector) {
        this.selector = selector;
    }

    protected void setLastVersion(Long lastVersion) {
        this.lastVersion = lastVersion;
    }

    protected void setPreVersion(Long preVersion) {
        this.preVersion = preVersion;
    }

    protected void setIsOnline(TrueFalseStatus isOnline) {
        this.isOnline = isOnline;
    }

    protected void setStatus(ProcessedStatus status) {
        this.status = status;
    }
}

