package com.bcxin.rbac.domain.repositories.custom;

import com.bcxin.Infrastructures.EntityRepository;
import com.bcxin.rbac.domain.entities.RbacCustomRoleUserEntity;
import org.springframework.data.repository.query.Param;

import java.util.List;
import java.util.Optional;

public interface RbacCustomRoleUserRepository extends EntityRepository<RbacCustomRoleUserEntity, Long> {

    long findCountByRbacRoleId(@Param("rbacRoleId") Long rbacRoleId);

    Optional<RbacCustomRoleUserEntity> findByRbacRoleIdAndTenantEmployeeId(Long rbacRoleId, String tenantEmployeeId);

    List<RbacCustomRoleUserEntity> findListByRbacRoleIdAndEmployeeIdList(@Param("rbacRoleId") Long rbacRoleId,
                                                                         @Param("employeeIdList") List<String> employeeIdList);

    List<RbacCustomRoleUserEntity> findByRbacRoleId(Long rbacRoleId);

}