package com.bcxin.rbac.domain.entities;

import com.bcxin.Infrastructures.entities.EntityAbstract;
import com.bcxin.Infrastructures.entities.IAggregate;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;

/**
 * 权限应用表
 */
@Data
@Table(name = "rbac_permit_app")
@Entity
public class RbacPermitAppEntity extends EntityAbstract implements IAggregate {

    /**
     * 主键id
     */
    @Id
    private Long id;
    /**
     * 应用代码/应用id
     */
    @Column(name = "app_code")
    private String appCode;
    /**
     * 应用名称
     */
    @Column(name = "app_name")
    private String appName;
    /**
     * 应用图标
     */
    @Column(name = "app_logo")
    private String appLogo;
    /**
     * 应用类型，1：web应用，2：app应用，3：都有
     */
    @Column(name = "app_type")
    private Integer appType;
    /**
     * 应用分类
     */
    @Column(name = "category")
    private String category;
    /**
     * 分类排序
     */
    @Column(name = "category_seq")
    private Integer categorySeq;
    /**
     * 排序
     */
    @Column(name = "seq")
    private Integer seq;


}
