package com.bcxin.rbac.domain.entities;

import com.bcxin.Infrastructures.entities.EntityAbstract;
import com.bcxin.Infrastructures.entities.IAggregate;
import com.bcxin.Infrastructures.entities.OperatorValueType;
import com.bcxin.Infrastructures.utils.UUIDUtil;
import lombok.AccessLevel;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.*;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.Collection;
import java.util.Date;

/**
 * 自定义角色表
 */
@Data
@Table(name = "rbac_custom_role")
@Entity
public class RbacCustomRoleEntity extends EntityAbstract implements IAggregate {

    /**
     * 主键id
     */
    @Id
    private Long id;
    /**
     * 企业id
     */
    @Column(name = "organization_id")
    private String organizationId;
    /**
     * 角色名称
     */
    @Column(name = "role_name")
    private String roleName;
    /**
     * 角色类型，1：系统默认，2：用户自定义，备注：系统默认不可删除
     */
    @Column(name = "role_type")
    private Integer roleType;
    /**
     * 备注说明
     */
    @Column(name = "remark")
    private String remark;
    /**
     * 排序
     */
    @Column(name = "seq")
    private Integer seq;
    /**
     * 角色状态，1：启用，0：禁用，备注：系统默认不可改状态
     */
    @Column(name = "status")
    private Integer status;
    /**
     * 创建时间
     */
    @Column(name = "create_time")
    private Date createTime;
    /**
     * 创建人id
     */
    @Column(name = "create_user_id")
    private String createUserId;
    /**
     * 更新时间
     */
    @Column(name = "update_time")
    private Date updateTime;
    /**
     * 更新人id
     */
    @Column(name = "update_user_id")
    private String updateUserId;

    public static RbacCustomRoleEntity create(Long id, String organizationId, String roleName, String remark, Integer seq, String createUserId) {
        RbacCustomRoleEntity role = new RbacCustomRoleEntity();
        role.setId(id);
        role.setOrganizationId(organizationId);
        role.setRoleName(roleName);
        role.setRoleType(2);
        role.setRemark(remark);
        role.setSeq(seq == null ? 0 : seq);
        role.setStatus(1);
        role.setCreateTime(new Date());
        role.setCreateUserId(createUserId);
        return role;
    }

    public static RbacCustomRoleEntity copy(Long id, RbacCustomRoleEntity source, Integer maxSeq, String createUserId) {
        RbacCustomRoleEntity role = new RbacCustomRoleEntity();
        role.setId(id);
        role.setOrganizationId(source.getOrganizationId());
        role.setRoleName(source.getRoleName().concat("（复制）"));
        role.setRoleType(2);
        role.setRemark(source.getRemark());
        role.setSeq(maxSeq + 1);
        role.setStatus(1);
        role.setCreateTime(new Date());
        role.setCreateUserId(createUserId);
        return role;
    }

    public void update(String roleName, String remark, Integer seq, String updateUserId) {
        this.setRoleName(roleName);
        this.setRemark(remark);
        this.setSeq(seq == null ? 0 : seq);
        this.setUpdateTime(new Date());
        this.setUpdateUserId(updateUserId);
    }
}
