/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.rbac.domain.services.impls;

import com.bcxin.Infrastructures.UnitWork;
import com.bcxin.Infrastructures.entities.EntityAbstract;
import com.bcxin.Infrastructures.exceptions.NotFoundTenantException;
import com.bcxin.rbac.domain.entities.CategoryEntity;
import com.bcxin.rbac.domain.repositories.CategoryRepository;
import com.bcxin.rbac.domain.services.CategoryService;
import com.bcxin.rbac.domain.services.commands.categories.BatchCategoryResourceCommand;
import com.bcxin.rbac.domain.services.commands.categories.CreateCategoryCommand;
import com.bcxin.rbac.domain.services.commands.categories.DeleteCategoryCommand;
import com.bcxin.rbac.domain.services.commands.categories.UpdateCategoryCommand;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class CategoryServiceImpl
implements CategoryService {
    private final CategoryRepository categoryRepository;
    private final UnitWork unitWork;

    public CategoryServiceImpl(CategoryRepository categoryRepository, UnitWork unitWork) {
        this.categoryRepository = categoryRepository;
        this.unitWork = unitWork;
    }

    @Override
    public void dispatch(CreateCategoryCommand command) {
        this.unitWork.executeTran(() -> {
            CategoryEntity category = CategoryEntity.create(command.getCode(), command.getName(), command.getNote());
            this.categoryRepository.save((EntityAbstract)category);
        });
    }

    @Override
    public void dispatch(UpdateCategoryCommand command) {
        Optional categoryOptional = this.categoryRepository.findById(command.getId());
        if (!categoryOptional.isPresent()) {
            throw new NotFoundTenantException("\u627e\u4e0d\u5230\u5206\u7c7b\u4fe1\u606f");
        }
        this.unitWork.executeTran(() -> {
            ((CategoryEntity)((Object)((Object)categoryOptional.get()))).change(command.getCode(), command.getName(), command.getNote());
            this.categoryRepository.save((EntityAbstract)categoryOptional.get());
        });
    }

    @Override
    public void dispatch(DeleteCategoryCommand command) {
        Optional categoryOptional = this.categoryRepository.findById(command.getId());
        if (!categoryOptional.isPresent()) {
            throw new NotFoundTenantException("\u627e\u4e0d\u5230\u5206\u7c7b\u4fe1\u606f");
        }
        this.unitWork.executeTran(() -> this.categoryRepository.delete((EntityAbstract)categoryOptional.get()));
    }

    @Override
    public void dispatch(BatchCategoryResourceCommand command) {
        command.validate();
        Collection categoryIds = command.getCategories().stream().map(ix -> ix.getId()).collect(Collectors.toList());
        Collection<CategoryEntity> categories = this.categoryRepository.getByIds(categoryIds);
        Collection notExistsCategories = command.getCategories().stream().filter(ix -> !categories.stream().anyMatch(ii -> ii.getId().equals(ix.getId()))).collect(Collectors.toList());
        for (BatchCategoryResourceCommand.CategoryCommand item : notExistsCategories) {
            CategoryEntity newCategory = CategoryEntity.create(item.getId(), String.format("RC_%s", item.getId()), item.getName(), "");
            categories.add(newCategory);
        }
        command.getCategories().forEach(ci -> {
            Optional<CategoryEntity> selectedCategoryOptional = categories.stream().filter(ix -> ix.getId().equals(ci.getId())).findFirst();
            if (!selectedCategoryOptional.isPresent()) {
                throw new NotFoundTenantException("\u7cfb\u7edf\u65e0\u6548, \u7adf\u7136\u627e\u4e0d\u5230category");
            }
            ci.getResources().forEach(cir -> ((CategoryEntity)((Object)((Object)((Object)selectedCategoryOptional.get())))).assignResource(cir.getId(), String.format("RCR_%s", cir.getId()), cir.getName(), cir.getName(), "ROLE"));
        });
        this.unitWork.executeTran(() -> categories.forEach(ci -> this.categoryRepository.save((EntityAbstract)ci)));
    }
}

