/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.rbac.domain.entities;

import com.bcxin.Infrastructures.entities.EntityAbstract;
import com.bcxin.Infrastructures.entities.IAggregate;
import com.bcxin.rbac.domain.entities.RoleEntity;
import com.bcxin.rbac.domain.entities.UserEntity;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.Collection;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Table;

@Table(name="rbac_subjects")
@Entity
public class SubjectEntity
extends EntityAbstract
implements IAggregate {
    @Id
    private String id;
    @Column(name="name", length=100, nullable=false)
    private String name;
    @Column(name="referenced_id", nullable=false, length=200)
    private String referencedId;
    @Column(name="created_time", nullable=false)
    private Timestamp createdTime;
    @OneToMany(mappedBy="subject")
    private Collection<RoleEntity> roles;
    @OneToMany(mappedBy="subject")
    private Collection<UserEntity> users;

    protected SubjectEntity() {
        this.setCreatedTime(Timestamp.from(Instant.now()));
    }

    public static SubjectEntity create(String name, String referencedId) {
        SubjectEntity subject = new SubjectEntity();
        subject.setId(referencedId);
        subject.setName(name);
        subject.setReferencedId(referencedId);
        return subject;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getReferencedId() {
        return this.referencedId;
    }

    public Timestamp getCreatedTime() {
        return this.createdTime;
    }

    public Collection<RoleEntity> getRoles() {
        return this.roles;
    }

    public Collection<UserEntity> getUsers() {
        return this.users;
    }

    protected void setId(String id) {
        this.id = id;
    }

    protected void setName(String name) {
        this.name = name;
    }

    protected void setReferencedId(String referencedId) {
        this.referencedId = referencedId;
    }

    protected void setCreatedTime(Timestamp createdTime) {
        this.createdTime = createdTime;
    }

    protected void setRoles(Collection<RoleEntity> roles) {
        this.roles = roles;
    }

    protected void setUsers(Collection<UserEntity> users) {
        this.users = users;
    }
}

