package com.bcxin.infrastructure.offices.utils;

import cn.hutool.core.collection.ListUtil;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.annotation.ExcelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/**
 * @Auther linqinglin
 * @date 2022/4/16 10:20
 */
public class EmployeeTempExcelUtil {

    /**
     * 根据模板写入
     * <p>1. 创建excel对应的实体对象
     * <p>2. 使用{@link ExcelProperty}注解指定写入的列
     * <p>3. 使用withTemplate 写取模板
     * <p>4. 直接写即可
     */
    public void templateWrite() {
        HashMap<Integer, List<String>> dropDownMap = new HashMap<>();
        // 指定下拉框
        List<String> school = new ArrayList<>();
        school.add("一中");
        school.add("二中");
        dropDownMap.put(2,school);
        String templateFileName = "F:\\git_project\\v5\\master\\tenant-platform\\tenant-rest-web-api\\src\\main\\resources\\templates\\V5员工导入模板2022.xlsx";
        String fileName = "d:\\" + System.currentTimeMillis() + ".xlsx";
        // 这里 需要指定写用哪个class去写，然后写到第一个sheet，名字为模板 然后文件流会自动关闭
        EasyExcel.write(fileName).withTemplate(templateFileName).registerWriteHandler(new TitleHandler(dropDownMap)).sheet().doWrite(ListUtil.empty());
    }

    /**
     * 组装excel头部
     * @return
     */
    public static List<List<String>> getTempHead() {
        List<List<String>> headList = new ArrayList();

        String title = "【必读】导入员工信息填写说明：\n" +
                "1.请勿删除表格的第1行、第2行，导入信息从第3行开始填写，请勿删除任何列，表格中带*号的内容必填。\n" +
                "2.姓名、手机号码：请正常填写，内容中不要带有空格或换行符。\n" +
                "3.所属部门：只能关联一个部门，为空时，则自动归属到顶级部门下；归属非顶级部门时，请完整填写部门层级信息，并以“/”来进行分层；如“顶级部门/一级部门/二级部门”；若没有相应部门，则导入失败，因此请先维护好部门列表。\n" +
                "4.入职日期：仅支持“2021/01/01”、“2021-01-01”、“2021.01.01”三种格式，其他格式导入会失败。 \n" +
                "4.职业类型：保安员请选择“保安员”，并填写证件类型（保安员固定选择“居民身份证（户口簿）”）及证件号码（身份证号码）；非保安员请选择“一般职员”，证件类型及号码选填。\n" +
                "5.单次导入建议最多导入2000条，超出可能会影响导入效率甚至导入失败。";

        // 下面写法，可以实现复杂的头
        headList.add(new ArrayList() {{
            add(title);
            add("*姓名");
        }});
        headList.add(new ArrayList() {{
            add(title);
            add("*手机号码");
        }});
        headList.add(new ArrayList() {{
            add(title);
            add("*所属部门");
        }});
        headList.add(new ArrayList() {{
            add(title);
            add("*职业类型");
        }});
        headList.add(new ArrayList() {{
            add(title);
            add("*入职日期");
        }});
        headList.add(new ArrayList() {{
            add(title);
            add("证件类型");
        }});
        headList.add(new ArrayList() {{
            add(title);
            add("证件号码");
        }});
        return headList;
    }

}
