/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.domain.entities;

import com.bcxin.Infrastructures.entities.EntityAbstract;
import com.bcxin.Infrastructures.entities.IAggregate;
import com.bcxin.Infrastructures.enums.ResourceReferenceType;
import com.bcxin.tenant.domain.entities.ExternalMemberEntity;
import java.sql.Timestamp;
import java.time.Instant;
import javax.persistence.Column;
import javax.persistence.ConstraintMode;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

@Table(name="external_groups")
@Entity
public class ExternalGroupEntity
extends EntityAbstract
implements IAggregate {
    @Id
    @Column(length=50)
    private String id;
    @Column(nullable=false, length=200)
    private String name;
    @Column(name="display_order", nullable=false)
    private int displayOrder;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="principal_id", referencedColumnName="id", foreignKey=@ForeignKey(name="fk_groups_principal_id", value=ConstraintMode.CONSTRAINT))
    private ExternalMemberEntity principal;
    @Column(name="principal_name", nullable=true)
    private String principalName;
    @Column(name="index_tree", nullable=false, length=500)
    private String indexTree;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="parent_id", referencedColumnName="id", foreignKey=@ForeignKey(name="fk_groups_parent_id", value=ConstraintMode.CONSTRAINT))
    private ExternalGroupEntity parent;
    @Column(nullable=false, name="created_time")
    private Timestamp createdTime;
    @Column(nullable=true, name="last_updated_time")
    private Timestamp lastUpdatedTime;
    @Column(nullable=false, name="reference_type")
    private ResourceReferenceType referenceType;
    @Column(nullable=false, name="reference_number", length=200)
    private String referenceNumber;

    public void change(String name, int displayOrder) {
        this.setName(name);
        this.setDisplayOrder(displayOrder);
        this.setLastUpdatedTime(Timestamp.from(Instant.now()));
    }

    public void assignPrincipal(ExternalMemberEntity externalMember) {
        if (externalMember == null) {
            this.setPrincipal(null);
            this.setPrincipalName(null);
        } else {
            this.setPrincipal(externalMember);
            this.setPrincipalName(externalMember.getTenantUser().getName());
        }
    }

    public ExternalGroupEntity() {
        this.setCreatedTime(Timestamp.from(Instant.now()));
    }

    public static ExternalGroupEntity create(ResourceReferenceType referenceType, String referenceNumber, String id, String name, int displayOrder) {
        ExternalGroupEntity group = new ExternalGroupEntity();
        group.setId(id);
        group.change(name, displayOrder);
        group.setReferenceType(referenceType);
        group.setReferenceNumber(referenceNumber);
        return group;
    }

    public void assign(ExternalGroupEntity parent) {
        this.setParent(parent);
        if (parent != null) {
            this.setIndexTree(String.format("%s-%s", parent.getIndexTree(), this.getId()));
        } else {
            this.setIndexTree(this.getId());
        }
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public int getDisplayOrder() {
        return this.displayOrder;
    }

    public ExternalMemberEntity getPrincipal() {
        return this.principal;
    }

    public String getPrincipalName() {
        return this.principalName;
    }

    public String getIndexTree() {
        return this.indexTree;
    }

    public ExternalGroupEntity getParent() {
        return this.parent;
    }

    public Timestamp getCreatedTime() {
        return this.createdTime;
    }

    public Timestamp getLastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public ResourceReferenceType getReferenceType() {
        return this.referenceType;
    }

    public String getReferenceNumber() {
        return this.referenceNumber;
    }

    protected void setId(String id) {
        this.id = id;
    }

    protected void setName(String name) {
        this.name = name;
    }

    protected void setDisplayOrder(int displayOrder) {
        this.displayOrder = displayOrder;
    }

    protected void setPrincipal(ExternalMemberEntity principal) {
        this.principal = principal;
    }

    protected void setPrincipalName(String principalName) {
        this.principalName = principalName;
    }

    protected void setIndexTree(String indexTree) {
        this.indexTree = indexTree;
    }

    protected void setParent(ExternalGroupEntity parent) {
        this.parent = parent;
    }

    protected void setCreatedTime(Timestamp createdTime) {
        this.createdTime = createdTime;
    }

    protected void setLastUpdatedTime(Timestamp lastUpdatedTime) {
        this.lastUpdatedTime = lastUpdatedTime;
    }

    protected void setReferenceType(ResourceReferenceType referenceType) {
        this.referenceType = referenceType;
    }

    protected void setReferenceNumber(String referenceNumber) {
        this.referenceNumber = referenceNumber;
    }
}

