package com.bcxin.Infrastructures.utils;

import cn.hutool.json.JSONUtil;
import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.JWTVerificationException;
import com.auth0.jwt.interfaces.DecodedJWT;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.UnsupportedEncodingException;
import java.util.Date;

public class JwtUtil {
    private static final Logger logger = LoggerFactory.getLogger(JwtUtil.class);

    public static final String JWT_USER_ID = "username";
    public static final String JWT_USER_INFO = "userInfo";
    public static final String SECRET_KEY = "teemlink_obpm";
    private static JWTVerifier verifier;
    public static final long EXPIRE_TIME = 10 * 24 * 60 * 60 * 1000;

    public static final long MOBILE_EXPIRE_TIME = 17 * 24 * 60 * 60 * 1000;

    static {
        try {
            verifier = JWT.require(Algorithm.HMAC256(SECRET_KEY)).withIssuer("auth0").build();
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    public static String getContentFromToken(String token) throws JWTVerificationException {
        DecodedJWT jwt = verifier.verify(token);
        String userId = jwt.getClaim(JwtUtil.JWT_USER_ID).asString();
        return userId;
    }

    public static String getToken(String userId) {

        String token = null;
        try {
            Date expiresAt = new Date(System.currentTimeMillis() + EXPIRE_TIME);
            token = JWT.create()
                    .withIssuer("auth0")
                    .withClaim(JwtUtil.JWT_USER_ID, userId)
                    .withExpiresAt(expiresAt)
                    // 使用了HMAC256加密算法。
                    .sign(Algorithm.HMAC256(SECRET_KEY));
        } catch (Exception e) {
            logger.error("getToken发生异常:{}", userId, e);
        }

        return token;

    }

    public static String getMobileToken(String userId) {
        String token = null;
        try {
            Date expiresAt = new Date(System.currentTimeMillis() + MOBILE_EXPIRE_TIME);
            token = JWT.create()
                    .withIssuer("auth0")
                    .withClaim(JwtUtil.JWT_USER_ID, userId)
                    .withExpiresAt(expiresAt)
                    // 使用了HMAC256加密算法。
                    .sign(Algorithm.HMAC256(SECRET_KEY));
        } catch (Exception e) {
            logger.error("getMobileToken发生异常:{}", userId, e);
        }

        return token;

    }

    public static String getToken(Object object) {

        String token = null;
        try {
            Date expiresAt = new Date(System.currentTimeMillis() + EXPIRE_TIME);
            token = JWT.create()
                    .withIssuer("auth0")
                    .withClaim(JwtUtil.JWT_USER_INFO, JSONUtil.toJsonStr(object))
                    .withExpiresAt(expiresAt)
                    // 使用了HMAC256加密算法。
                    .sign(Algorithm.HMAC256(SECRET_KEY));
        } catch (Exception e) {
            logger.error("getToken发生异常:{}", object, e);
        }

        return token;

    }
}
