package com.bcxin.ferry.controller;


import com.alibaba.fastjson.JSONObject;
import com.bcxin.ferry.dtos.request.BoundaryCallbackRequest;
import com.bcxin.ferry.dtos.response.boundary.BoundaryCallbackResult;
import com.bcxin.ferry.service.FerryRequestLogService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * description：边界服务回调接口
 * author：linchunpeng
 * date：2024/4/10
 */
@Slf4j
@RestController
@RequestMapping("/api/boundary/callback")
public class BoundaryServerCallbackController {

    @Autowired
    private FerryRequestLogService ferryRequestLogService;

    @RequestMapping("/notify")
    public BoundaryCallbackResult notify(@RequestBody BoundaryCallbackRequest request) {
        log.info("边界服务回调接口，参数：{}", request == null ? "" : JSONObject.toJSONString(request));
        if (request != null && StringUtils.isNotBlank(request.getTask_id()) && "0".equals(request.getStatus_code())) {
//            ferryRequestLogService.boundaryServerCallback(request.getTask_id());
        }
        return new BoundaryCallbackResult("0", "回调成功");
    }

}
