package com.bcxin.file;

import cn.hutool.core.util.StrUtil;
import com.bcxin.file.model.FtpConfig;

public class ConsoleApp {

    public static void main(String[] args) {
        System.out.println(args.length);
        String txtFile = args[1];
        String profiles = args[0];
        System.out.println(txtFile);
        System.out.println(profiles);
        FtpConfig ftpConfig;
        if("bj内网ftp".equals(profiles)){
            ftpConfig = FtpConfig.getBjConfig();
        }else if("测试内网ftp".equals(profiles)){
            ftpConfig = FtpConfig.getTestConfig();
        }else{
            ftpConfig = FtpConfig.getLocalConfig();
        }
        inFtp(ftpConfig,txtFile);
    }

    private static void inFtp(FtpConfig ftpConfig,String txtFile){
        if(StrUtil.isEmpty(txtFile)){
            System.err.println("请选择文件目录");
            return;
        }
        FtpSwingWorker1 ftpSwingWorker = new FtpSwingWorker1(ftpConfig,txtFile);
        try {
            ftpSwingWorker.doInBackground();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
