/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.backend.domain.configs;

import com.bcxin.backend.domain.models.DomainSuperviseDTO;
import com.bcxin.runtime.domain.syncs.entities.DataSyncQueueEntity;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.domain.EntityScan;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.orm.jpa.EntityManagerFactoryBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.transaction.PlatformTransactionManager;

@Configuration
@EnableJpaRepositories(basePackages={"com.bcxin.backend.domain.repositories"}, entityManagerFactoryRef="entityManagerFactory", transactionManagerRef="transactionManager")
@EntityScan(basePackages={"com.bcxin.backend.domain.models"})
public class DomainConfig {
    @Primary
    @Bean(value={"dataSourceProperties"})
    @ConfigurationProperties(value="spring.datasource")
    public DataSourceProperties dataSourceProperties() {
        return new DataSourceProperties();
    }

    @Primary
    @Bean(value={"dataSource"})
    public DataSource dataSource() {
        return this.dataSourceProperties().initializeDataSourceBuilder().build();
    }

    @Bean(name={"jdbcTemplate"})
    public JdbcTemplate jdbcTemplate(@Qualifier(value="dataSource") DataSource dataSource) {
        return new JdbcTemplate(dataSource);
    }

    @Primary
    @Bean(value={"entityManagerFactory"})
    public LocalContainerEntityManagerFactoryBean entityManagerFactoryBean(EntityManagerFactoryBuilder builder) {
        return builder.dataSource(this.dataSource()).packages(new Class[]{DomainSuperviseDTO.class, DataSyncQueueEntity.class}).build();
    }

    @Bean(value={"transactionManager"})
    public PlatformTransactionManager transactionManager(@Qualifier(value="entityManagerFactory") LocalContainerEntityManagerFactoryBean entityManagerFactoryBean) {
        return new JpaTransactionManager(entityManagerFactoryBean.getObject());
    }
}

