/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.backend.domain.signature.service.impls;

import cn.hutool.core.date.DateUtil;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.backend.core.utils.ExceptionUtils;
import com.bcxin.backend.domain.models.SignatureQueuesDTO;
import com.bcxin.backend.domain.repositories.SignatureQueuesRepository;
import com.bcxin.backend.domain.services.impls.ConvertServiceImpl;
import com.bcxin.backend.domain.signature.service.QzSignatureStrategy;
import com.bcxin.backend.domain.syncs.dtos.SharedConvertDto;
import com.google.common.collect.Maps;
import io.jsonwebtoken.lang.Collections;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Service;

@Service
public class CommonSignatureToPDFCompare
implements QzSignatureStrategy {
    private static final Logger log = LoggerFactory.getLogger(CommonSignatureToPDFCompare.class);
    private final SignatureQueuesRepository signatureQueuesRepository;
    @Value(value="${myapps.domain.url}")
    String urlHead;
    @Value(value="${myapps.signature.unSignaturePDF}")
    String unSignatureSignatureToPDFServiceImplPDF;
    @Value(value="${myapps.signature.signaturePDF}")
    String signaturePDF;
    @Value(value="${myapps.signature.tempPDF}")
    String tempPDF;
    @Value(value="${myapps.signature.mobanPDF}")
    String mobanPDF;
    @Value(value="${myapps.signature.cgiApi}")
    String cgiApi;
    @Autowired
    private ConvertServiceImpl convertService;
    @Autowired
    @Qualifier(value="primaryJdbcTemplate")
    protected JdbcTemplate jdbcTemplate;

    public CommonSignatureToPDFCompare(SignatureQueuesRepository signatureQueuesRepository) {
        this.signatureQueuesRepository = signatureQueuesRepository;
    }

    @Override
    public void cerSignatureQueues() {
        String sqlQId = " select a.id from tlk_Certificate a where a.ITEM_signatured_processed_status IN (0) and a.ITEM_CERTIFICATETYPE='1' and a.ITEM_isCertified != '0' order by item_certificateDate desc, ITEM_signatured_time desc limit 300";
        List strList = Lists.newArrayList();
        try {
            strList = this.jdbcTemplate.query(sqlQId, (RowMapper)new RowMapper<String>(){

                public String mapRow(ResultSet rs, int rowNum) throws SQLException {
                    return rs.getString("id");
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (strList.size() == 0) {
            return;
        }
        String dupsql = "";
        String dupsql2 = "";
        String dupsql3 = "";
        String dupsql4 = "";
        String dupsql5 = "";
        String upsql = "";
        String insql = "";
        String insql2 = "";
        String insql3 = "";
        String insql4 = "";
        String insql5 = "";
        String operator = "";
        String now = DateUtil.today();
        String array = "(";
        for (String str : strList) {
            array = array + "'";
            array = array + str;
            array = array + "',";
        }
        array = array.substring(0, array.length() - 1);
        array = array + ")";
        String sql = "select id,item_securityname,item_documentid,item_idaddress,item_certificateno,item_certificatefrom,item_certificatedate,item_headphoto,created,item_signatured_processed_status from tlk_certificate where id in " + array + "";
        System.out.println(sql);
        List list = Lists.newArrayList();
        try {
            list = this.jdbcTemplate.query(sql, (RowMapper)new RowMapper<Map<String, String>>(){

                public Map<String, String> mapRow(ResultSet rs, int rowNum) throws SQLException {
                    HashMap map = Maps.newHashMap();
                    map.put("id", rs.getString("id"));
                    map.put("item_securityname", rs.getString("item_securityname"));
                    map.put("item_documentid", rs.getString("item_documentid"));
                    map.put("item_idaddress", rs.getString("item_idaddress"));
                    map.put("item_certificateno", rs.getString("item_certificateno"));
                    map.put("item_certificatefrom", rs.getString("item_certificatefrom"));
                    map.put("item_certificatedate", rs.getString("item_certificatedate"));
                    map.put("item_headphoto", rs.getString("item_headphoto"));
                    map.put("created", rs.getString("created"));
                    map.put("item_signatured_processed_status", rs.getString("item_signatured_processed_status"));
                    return map;
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (list.size() > 0) {
            dupsql = "UPDATE tlk_certificate SET ITEM_signatured_processed_status = 3,ITEM_last_signatured_processed_result = '\u8bc1\u4e66\u4fe1\u606f\u4e0d\u5168' WHERE id in(";
            dupsql2 = "UPDATE tlk_certificate SET ITEM_signatured_processed_status = 3,ITEM_last_signatured_processed_result = '\u8eab\u4efd\u8bc1\u4fe1\u606f\u65e0\u6548' WHERE id in(";
            dupsql3 = "UPDATE tlk_certificate SET ITEM_signatured_processed_status = 3,ITEM_last_signatured_processed_result = '\u8bc1\u4e66\u4fe1\u606f\u4e0d\u5168\uff08\u8eab\u4efd\u8bc1\u4f4f\u5740\uff09' WHERE id in(";
            dupsql4 = "UPDATE tlk_certificate SET ITEM_signatured_processed_status = 3,ITEM_last_signatured_processed_result = '\u8bc1\u4e66\u4fe1\u606f\u4e0d\u5168\uff08\u8eab\u4efd\u8bc1\u5934\u50cf\uff09' WHERE id in(";
            dupsql5 = "UPDATE tlk_certificate SET ITEM_signatured_processed_status = 3,ITEM_last_signatured_processed_result = '\u8bc1\u4e66\u4fe1\u606f\u4e0d\u5168\uff08\u8eab\u4efd\u8bc1\u5934\u50cf\u3001\u8eab\u4efd\u8bc1\u4f4f\u5740\uff09' WHERE id in(";
            upsql = "UPDATE tlk_certificate SET ITEM_last_signatured_processed_result = '',ITEM_signatured_processed_status = 1,ITEM_signatured_operator = '" + operator + "',ITEM_signatured_time = now(),ITEM_CERTIFICATEDATE = IFNULL(ITEM_CERTIFICATEDATE, NOW()) WHERE id in(";
            insql = "INSERT INTO obpm2_security.signature_queues (template_url,DATA,STATUS,business_id,createdTime,creator,certificatedate)VALUES";
            insql2 = "INSERT INTO obpm2_security.signature_queues (template_url,DATA,STATUS,business_id,createdTime,creator,certificatedate)VALUES";
            insql3 = "INSERT INTO obpm2_security.signature_queues (template_url,DATA,STATUS,business_id,createdTime,creator,certificatedate)VALUES";
            insql4 = "INSERT INTO obpm2_security.signature_queues (template_url,DATA,STATUS,business_id,createdTime,creator,certificatedate)VALUES";
            insql5 = "INSERT INTO obpm2_security.signature_queues (template_url,DATA,STATUS,business_id,createdTime,creator,certificatedate)VALUES";
            int i = 0;
            for (Map map1 : list) {
                ++i;
                String created = (String)map1.get("created");
                String securityname = (String)map1.get("item_securityname");
                String documentid = (String)map1.get("item_documentid");
                String IdAddress = (String)map1.get("item_idaddress");
                String certificateno = (String)map1.get("item_certificateno");
                String certificatefrom = (String)map1.get("item_certificatefrom");
                String certificatedate = (String)map1.get("item_certificatedate");
                String headphoto = (String)map1.get("item_headphoto");
                String signaturestatus = (String)map1.get("item_signatured_processed_status");
                String id = (String)map1.get("id");
                if (StringUtils.isEmpty((CharSequence)signaturestatus)) continue;
                String string = signaturestatus = signaturestatus.contains(".") ? signaturestatus.split(".")[0] : signaturestatus;
                if (StringUtils.isEmpty((CharSequence)created)) {
                    created = DateUtil.today();
                }
                boolean boolean1 = true;
                if (StringUtils.isNotEmpty((CharSequence)documentid) && documentid.length() != 18) {
                    boolean1 = false;
                }
                boolean boolean2 = true;
                boolean boolean3 = true;
                boolean boolean4 = true;
                if (StringUtils.isEmpty((CharSequence)IdAddress) && StringUtils.isEmpty((CharSequence)headphoto)) {
                    boolean2 = false;
                } else if (StringUtils.isEmpty((CharSequence)IdAddress) || IdAddress.contains(" ")) {
                    boolean3 = false;
                } else if (StringUtils.isEmpty((CharSequence)headphoto) || headphoto.contains("null")) {
                    boolean4 = false;
                }
                if (StringUtils.isNotEmpty((CharSequence)securityname) && StringUtils.isNotEmpty((CharSequence)documentid) && StringUtils.isNotEmpty((CharSequence)IdAddress) && StringUtils.isNotEmpty((CharSequence)certificateno) && StringUtils.isNotEmpty((CharSequence)certificatefrom) && StringUtils.isNotEmpty((CharSequence)headphoto) && boolean1) {
                    if (!"0".equals(signaturestatus) && !"3".equals(signaturestatus)) continue;
                    String[] arrphoto = headphoto.split("originalPath");
                    if (arrphoto.length == 2) {
                        headphoto = headphoto.replace("[", "");
                        headphoto = headphoto.replace("]", "");
                        JSONObject rtJsonStrData = JSONObject.parseObject((String)headphoto);
                        headphoto = rtJsonStrData.get((Object)"path") + "";
                    }
                    String year = documentid.substring(6, 10);
                    String month = documentid.substring(10, 12);
                    String day = documentid.substring(12, 14);
                    String moban = this.mobanPDF;
                    certificatedate = StringUtils.isEmpty((CharSequence)certificatedate) ? DateUtil.today() : DateUtil.format((Date)DateUtil.parseDate((CharSequence)certificatedate), (String)"yyyy-MM-dd");
                    String json = "{\"name\":\"" + securityname + "\",\"address\":\"" + IdAddress + "\",\"headphoto\":\"" + headphoto + "\",\"idcardno\":\"" + documentid + "\",\"year\":\"" + year + "\",\"month\":\"" + month + "\",\"day\":\"" + day + "\",\"certificateno\":\"" + certificateno + "\",\"certificatefrom\":\"" + certificatefrom + "\",\"isSignature\":\"1\",\"fzDate\":\"" + certificatedate + "\"}";
                    if (i <= 200) {
                        insql = insql + "('" + moban + "','" + json + "',0,'" + id + "',NOW(),'" + operator + "','" + certificatedate + "'),";
                    } else if (i > 200 && i <= 400) {
                        insql2 = insql2 + "('" + moban + "','" + json + "',0,'" + id + "',NOW(),'" + operator + "','" + certificatedate + "'),";
                    } else if (i > 400 && i <= 600) {
                        insql3 = insql3 + "('" + moban + "','" + json + "',0,'" + id + "',NOW(),'" + operator + "','" + certificatedate + "'),";
                    } else if (i > 600 && i <= 800) {
                        insql4 = insql4 + "('" + moban + "','" + json + "',0,'" + id + "',NOW(),'" + operator + "','" + certificatedate + "'),";
                    } else {
                        insql5 = insql5 + "('" + moban + "','" + json + "',0,'" + id + "',NOW(),'" + operator + "','" + certificatedate + "'),";
                    }
                    upsql = upsql + "'" + id + "'";
                    upsql = upsql + ",";
                    continue;
                }
                if (!boolean1) {
                    dupsql2 = dupsql2 + "'" + id + "'";
                    dupsql2 = dupsql2 + ",";
                    continue;
                }
                if (!boolean2) {
                    dupsql5 = dupsql5 + "'" + id + "'";
                    dupsql5 = dupsql5 + ",";
                    continue;
                }
                if (!boolean3) {
                    dupsql3 = dupsql3 + "'" + id + "'";
                    dupsql3 = dupsql3 + ",";
                    continue;
                }
                if (!boolean4) {
                    dupsql4 = dupsql4 + "'" + id + "'";
                    dupsql4 = dupsql4 + ",";
                    continue;
                }
                dupsql = dupsql + "'" + id + "'";
                dupsql = dupsql + ",";
            }
        }
        if (!"INSERT INTO obpm2_security.signature_queues (template_url,DATA,STATUS,business_id,createdTime,creator,certificatedate)VALUES".equals(insql)) {
            insql = insql.substring(0, insql.length() - 1);
            this.jdbcTemplate.update(insql);
        }
        if (!"INSERT INTO obpm2_security.signature_queues (template_url,DATA,STATUS,business_id,createdTime,creator,certificatedate)VALUES".equals(insql2)) {
            insql2 = insql2.substring(0, insql2.length() - 1);
            this.jdbcTemplate.update(insql2);
        }
        if (!"INSERT INTO obpm2_security.signature_queues (template_url,DATA,STATUS,business_id,createdTime,creator,certificatedate)VALUES".equals(insql3)) {
            insql3 = insql3.substring(0, insql3.length() - 1);
            this.jdbcTemplate.update(insql3);
        }
        if (!"INSERT INTO obpm2_security.signature_queues (template_url,DATA,STATUS,business_id,createdTime,creator,certificatedate)VALUES".equals(insql4)) {
            insql4 = insql4.substring(0, insql4.length() - 1);
            this.jdbcTemplate.update(insql4);
        }
        if (!"INSERT INTO obpm2_security.signature_queues (template_url,DATA,STATUS,business_id,createdTime,creator,certificatedate)VALUES".equals(insql5)) {
            insql5 = insql5.substring(0, insql5.length() - 1);
            this.jdbcTemplate.update(insql5);
        }
        if (!("UPDATE tlk_certificate SET ITEM_last_signatured_processed_result = '',ITEM_signatured_processed_status = 1,ITEM_signatured_operator = '" + operator + "',ITEM_signatured_time = now(),ITEM_CERTIFICATEDATE = IFNULL(ITEM_CERTIFICATEDATE, NOW()) WHERE id in(").equals(upsql)) {
            upsql = upsql.substring(0, upsql.length() - 1);
            upsql = upsql + ");";
            this.jdbcTemplate.update(upsql);
        }
        if (!"UPDATE tlk_certificate SET ITEM_signatured_processed_status = 3,ITEM_last_signatured_processed_result = '\u8bc1\u4e66\u4fe1\u606f\u4e0d\u5168' WHERE id in(".equals(dupsql)) {
            dupsql = dupsql.substring(0, dupsql.length() - 1);
            dupsql = dupsql + ");";
            this.jdbcTemplate.update(dupsql);
        }
        if (!"UPDATE tlk_certificate SET ITEM_signatured_processed_status = 3,ITEM_last_signatured_processed_result = '\u8eab\u4efd\u8bc1\u4fe1\u606f\u65e0\u6548' WHERE id in(".equals(dupsql2)) {
            dupsql2 = dupsql2.substring(0, dupsql2.length() - 1);
            dupsql2 = dupsql2 + ");";
            this.jdbcTemplate.update(dupsql2);
        }
        if (!"UPDATE tlk_certificate SET ITEM_signatured_processed_status = 3,ITEM_last_signatured_processed_result = '\u8bc1\u4e66\u4fe1\u606f\u4e0d\u5168\uff08\u8eab\u4efd\u8bc1\u5934\u50cf\u3001\u8eab\u4efd\u8bc1\u4f4f\u5740\uff09' WHERE id in(".equals(dupsql5)) {
            dupsql5 = dupsql5.substring(0, dupsql5.length() - 1);
            dupsql5 = dupsql5 + ");";
            this.jdbcTemplate.update(dupsql5);
        }
        if (!"UPDATE tlk_certificate SET ITEM_signatured_processed_status = 3,ITEM_last_signatured_processed_result = '\u8bc1\u4e66\u4fe1\u606f\u4e0d\u5168\uff08\u8eab\u4efd\u8bc1\u4f4f\u5740\uff09' WHERE id in(".equals(dupsql3)) {
            dupsql3 = dupsql3.substring(0, dupsql3.length() - 1);
            dupsql3 = dupsql3 + ");";
            this.jdbcTemplate.update(dupsql3);
        }
        if (!"UPDATE tlk_certificate SET ITEM_signatured_processed_status = 3,ITEM_last_signatured_processed_result = '\u8bc1\u4e66\u4fe1\u606f\u4e0d\u5168\uff08\u8eab\u4efd\u8bc1\u5934\u50cf\uff09' WHERE id in(".equals(dupsql4)) {
            dupsql4 = dupsql4.substring(0, dupsql4.length() - 1);
            dupsql4 = dupsql4 + ");";
            this.jdbcTemplate.update(dupsql4);
        }
    }

    @Override
    public void cerPDF() {
        this.createPDF();
    }

    private boolean activateXMPSignQuicklyExCGI() {
        StringBuilder sb = new StringBuilder();
        try {
            JSONObject json = new JSONObject();
            json.put("service", (Object)"wss://127.0.0.1:8800");
            json.put("sn", (Object)"2171101001009256");
            json.put("pin", (Object)"88888888");
            json.put("in", (Object)"/data/share/in");
            json.put("out", (Object)"/data/share/out");
            JSONArray arr = new JSONArray();
            JSONObject pos = new JSONObject();
            pos.put("centerX", (Object)405);
            pos.put("centerY", (Object)312);
            pos.put("page", (Object)1);
            arr.add((Object)pos);
            json.put("signOnPos", (Object)arr);
            String ret = HttpUtil.post((String)this.cgiApi, (String)json.toJSONString());
            log.info("====> \u7535\u5b50\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb.activateXMPSignQuicklyExCGI.ret\uff1a" + ret);
            if (StringUtils.isEmpty((CharSequence)ret)) {
                return false;
            }
            JSONObject result = JSON.parseObject((String)ret.replace("#", ""));
            return "1".equals(String.valueOf(result.get((Object)"code")));
        }
        catch (Exception e) {
            log.info("====> \u7535\u5b50\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb.activateXMPSignQuicklyExCGI message:" + e.getMessage());
            return false;
        }
    }

    private void createPDF() {
        Page<SignatureQueuesDTO> pageQueues = this.signatureQueuesRepository.pageQueues(0, PageRequest.of((int)0, (int)300));
        List queues = pageQueues.getContent();
        if (Collections.isEmpty((Collection)queues)) {
            return;
        }
        for (SignatureQueuesDTO queuesDTO : queues) {
            this.accept(queuesDTO);
        }
    }

    public static void main(String[] args) {
    }

    private void accept(SignatureQueuesDTO queue) {
        Long a = System.currentTimeMillis();
        SignatureData data = (SignatureData)JSONObject.parseObject((String)queue.getData(), SignatureData.class);
        data.setUnSignaturePDF(this.tempPDF + "/" + System.currentTimeMillis() + "queueId_" + queue.getId() + ".temp");
        String toDay = data.getFzDate();
        if (StringUtils.isEmpty((CharSequence)toDay)) {
            toDay = DateUtil.today();
        }
        data.setZYear(toDay.split("-")[0]);
        data.setZMonth(toDay.split("-")[1]);
        data.setZDay(toDay.split("-")[2]);
        data.setHeadphoto(data.getHeadphoto().startsWith("http") ? data.getHeadphoto() : this.urlHead + data.getHeadphoto());
        String result = "";
        SharedConvertDto sharedConvertDto = new SharedConvertDto();
        sharedConvertDto.setTempUrl(queue.getTemplate_url());
        sharedConvertDto.setFormData(data);
        if (!CommonSignatureToPDFCompare.doesFileExist(data.getHeadphoto())) {
            this.signatureQueuesRepository.updateSignature(2, new Date(), "PDF\u751f\u6210\u5931\u8d25\uff1a\u65e0\u5934\u50cf\u4fe1\u606f", queue.getId());
            log.info("====> \u7535\u5b50\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb.createPDF.accept.\u5355\u6b21\u4e1a\u52a1\uff1a002\uff1afail\uff1a\u65e0\u5934\u50cf\u4fe1\u606f");
        }
        try {
            result = this.convertService.execConvertHtmltopdfForTemp(sharedConvertDto);
        }
        catch (IOException e) {
            result = "";
            log.error("====> \u7535\u5b50\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb.createPDF.accept.pdf\u751f\u6210\u5f02\u5e38\uff1a" + e.getMessage());
        }
        if (StringUtils.isNotEmpty((CharSequence)result)) {
            this.signatureQueuesRepository.updateSignature(3, new Date(), "PDF\u5df2\u751f\u6210\u5f85\u7b7e\u7ae0", queue.getId());
        } else {
            this.signatureQueuesRepository.updateSignature(2, new Date(), "PDF\u751f\u6210\u5931\u8d25", queue.getId());
        }
        log.info("====> \u7535\u5b50\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb.createPDF.accept.\u5355\u6b21\u751f\u6210\u6587\u4ef6\u8017\u65f6\uff1a" + (System.currentTimeMillis() - a));
    }

    /*
     * Exception decompiling
     */
    public static boolean doesFileExist(String urlString) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void delInPDF() {
        SharedConvertDto sharedConvertDto = new SharedConvertDto();
        sharedConvertDto.setTempUrl(this.tempPDF);
        this.convertService.delInPDF(sharedConvertDto);
    }

    @Override
    public void signQuicklyExCGI() {
        Long a = System.currentTimeMillis();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("tempUrl", (Object)this.tempPDF);
        jsonObject.put("formData", (Object)230);
        try {
            SharedConvertDto sharedConvertDto = new SharedConvertDto();
            String tempUrl = jsonObject.getString("tempUrl");
            String formData = jsonObject.getString("formData");
            sharedConvertDto.setTempUrl(tempUrl);
            sharedConvertDto.setFormData(formData);
            new Thread(() -> {
                try {
                    this.convertService.delInPDF(sharedConvertDto);
                }
                catch (Exception e) {
                    log.error("====> \u7535\u5b50\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb.signQuicklyExCGI\u7b7e\u7ae0\u524d\u6bd4\u5bf9in\u6587\u4ef6\u5220\u9664\uff1a" + e.getMessage());
                }
            }).start();
            this.convertService.existsPdfCopy(sharedConvertDto);
            this.convertService.delInPDF(this.tempPDF);
            this.activateXMPSignQuicklyExCGI();
            new Thread(() -> {
                try {
                    this.convertService.delInPDF(sharedConvertDto);
                }
                catch (Exception e) {
                    log.error("====> \u7535\u5b50\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb.signQuicklyExCGI\u7b7e\u7ae0\u540e\u6bd4\u5bf9in\u6587\u4ef6\u5220\u9664\uff1a" + e.getMessage());
                }
            }).start();
            log.info("====> \u7535\u5b50\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb.signQuicklyExCGI.\u7b7e\u7ae0\u63a5\u53e3\u8017\u65f6\uff1a" + (System.currentTimeMillis() - a));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void changeStatus() {
        String updateSql = "update obpm2_security.signature_queues set status = '0' where status = '3' and TIMESTAMPDIFF(HOUR, last_processed_time, NOW()) > 3";
        this.jdbcTemplate.update(updateSql);
    }

    @Override
    public void scan() {
        StringBuilder sb = new StringBuilder();
        try {
            String[] failS;
            Long a = System.currentTimeMillis();
            JSONObject jsonObject = new JSONObject();
            String pdfFile = "/uploads/pdf/dianziqianzhang/out";
            jsonObject.put("tempUrl", (Object)pdfFile);
            jsonObject.put("formData", null);
            SharedConvertDto sharedConvertDto = new SharedConvertDto();
            sharedConvertDto.setTempUrl(pdfFile);
            sharedConvertDto.setFormData(null);
            String result = this.convertService.existsScanSignature(sharedConvertDto);
            if (StringUtils.isEmpty((CharSequence)result)) {
                log.info("====> \u7535\u5b50\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb.scan.result\uff1a\u7a7a");
                return;
            }
            log.info("====> \u7535\u5b50\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb.scan.\u6279\u91cf\u4e0a\u4f20ftp\u7ed3\u675f\u8017\u65f6\uff1a" + (System.currentTimeMillis() - a));
            JSONObject json = JSONObject.parseObject((String)result);
            Object success = json.get((Object)"success");
            Object fail = json.get((Object)"fail");
            List<String> failList = null;
            String successFile = "";
            String failFile = "";
            if (success != null) {
                successFile = (String)success;
            }
            if (fail != null && StringUtils.isNotEmpty((CharSequence)(failFile = (String)fail)) && (failS = failFile.replace(".pdf", "").split("queueId_")[1].split(",")).length > 0) {
                failList = Arrays.asList(failS);
            }
            String fileNames = successFile + failFile;
            new Thread(() -> {
                try {
                    this.convertService.delSetFtpFile(this.tempPDF, fileNames);
                }
                catch (Exception e) {
                    log.error("====> \u7535\u5b50\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb.scan.ftp\u64cd\u4f5c\u8fc7\u7684\u6587\u4ef6\u5220\u9664\uff1a" + e.getMessage());
                }
            }).start();
            if (StringUtils.isNotEmpty((CharSequence)successFile)) {
                String[] successSplit;
                for (String string : successSplit = successFile.split(",")) {
                    String successFilePath = pdfFile + "/" + string;
                    String id = string.split("queueId_")[1].replace(".pdf", "");
                    String business_id = this.signatureQueuesRepository.getBuId(id);
                    String updateSql = "UPDATE tlk_certificate SET ITEM_SIGNATURED_PROCESSED_STATUS=\"2\",ITEM_LAST_SIGNATURED_PROCESSED_TIME=NOW(),ITEM_CERTIFICATEDATE=IFNULL(ITEM_CERTIFICATEDATE,NOW()),ITEM_LAST_SIGNATURED_PROCESSED_RESULT=\"\u5b8c\u6210\",ITEM_ATTACHMENT=\"" + successFilePath + "\" WHERE ID=\"" + business_id + "\";";
                    this.jdbcTemplate.update(updateSql);
                    this.signatureQueuesRepository.updateSignature(1, new Date(), "\u6210\u529f", id);
                }
            }
            if (failList != null) {
                this.signatureQueuesRepository.updateSignatures(2, new Date(), "\u672a\u6210\u529f\u7b7e\u7ae0", failList);
            }
            log.info("====> \u7535\u5b50\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb.scan.50\u4e2aPDF\u5df2\u7b7e\u7ae0\u6587\u4ef6\u5b58FTP\u8017\u65f6\uff1a" + (System.currentTimeMillis() - a));
        }
        catch (Exception e) {
            log.error("====> \u7535\u5b50\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb.scan.updateSql error\uff1a" + ExceptionUtils.getStackMessage((Throwable)e));
        }
    }

    public static class Resource {
        private int errcode;
        private String errmsg;
        private Object data;

        public int getErrcode() {
            return this.errcode;
        }

        public String getErrmsg() {
            return this.errmsg;
        }

        public Object getData() {
            return this.data;
        }

        public void setErrcode(int errcode) {
            this.errcode = errcode;
        }

        public void setErrmsg(String errmsg) {
            this.errmsg = errmsg;
        }

        public void setData(Object data) {
            this.data = data;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Resource)) {
                return false;
            }
            Resource other = (Resource)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getErrcode() != other.getErrcode()) {
                return false;
            }
            String this$errmsg = this.getErrmsg();
            String other$errmsg = other.getErrmsg();
            if (this$errmsg == null ? other$errmsg != null : !this$errmsg.equals(other$errmsg)) {
                return false;
            }
            Object this$data = this.getData();
            Object other$data = other.getData();
            return !(this$data == null ? other$data != null : !this$data.equals(other$data));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Resource;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getErrcode();
            String $errmsg = this.getErrmsg();
            result = result * 59 + ($errmsg == null ? 43 : $errmsg.hashCode());
            Object $data = this.getData();
            result = result * 59 + ($data == null ? 43 : $data.hashCode());
            return result;
        }

        public String toString() {
            return "CommonSignatureToPDFCompare.Resource(errcode=" + this.getErrcode() + ", errmsg=" + this.getErrmsg() + ", data=" + this.getData() + ")";
        }
    }

    public static class SignatureData {
        private String name;
        private String address;
        private String headphoto;
        private String idcardno;
        private String year;
        private String month;
        private String day;
        private String certificateno;
        private String isSignature;
        private String fzDate;
        private String zYear;
        private String zMonth;
        private String zDay;
        private String signatureImg;
        private String unSignaturePDF;
        private String signaturePDF;

        public String getName() {
            return this.name;
        }

        public String getAddress() {
            return this.address;
        }

        public String getHeadphoto() {
            return this.headphoto;
        }

        public String getIdcardno() {
            return this.idcardno;
        }

        public String getYear() {
            return this.year;
        }

        public String getMonth() {
            return this.month;
        }

        public String getDay() {
            return this.day;
        }

        public String getCertificateno() {
            return this.certificateno;
        }

        public String getIsSignature() {
            return this.isSignature;
        }

        public String getFzDate() {
            return this.fzDate;
        }

        public String getZYear() {
            return this.zYear;
        }

        public String getZMonth() {
            return this.zMonth;
        }

        public String getZDay() {
            return this.zDay;
        }

        public String getSignatureImg() {
            return this.signatureImg;
        }

        public String getUnSignaturePDF() {
            return this.unSignaturePDF;
        }

        public String getSignaturePDF() {
            return this.signaturePDF;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setAddress(String address) {
            this.address = address;
        }

        public void setHeadphoto(String headphoto) {
            this.headphoto = headphoto;
        }

        public void setIdcardno(String idcardno) {
            this.idcardno = idcardno;
        }

        public void setYear(String year) {
            this.year = year;
        }

        public void setMonth(String month) {
            this.month = month;
        }

        public void setDay(String day) {
            this.day = day;
        }

        public void setCertificateno(String certificateno) {
            this.certificateno = certificateno;
        }

        public void setIsSignature(String isSignature) {
            this.isSignature = isSignature;
        }

        public void setFzDate(String fzDate) {
            this.fzDate = fzDate;
        }

        public void setZYear(String zYear) {
            this.zYear = zYear;
        }

        public void setZMonth(String zMonth) {
            this.zMonth = zMonth;
        }

        public void setZDay(String zDay) {
            this.zDay = zDay;
        }

        public void setSignatureImg(String signatureImg) {
            this.signatureImg = signatureImg;
        }

        public void setUnSignaturePDF(String unSignaturePDF) {
            this.unSignaturePDF = unSignaturePDF;
        }

        public void setSignaturePDF(String signaturePDF) {
            this.signaturePDF = signaturePDF;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SignatureData)) {
                return false;
            }
            SignatureData other = (SignatureData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$address = this.getAddress();
            String other$address = other.getAddress();
            if (this$address == null ? other$address != null : !this$address.equals(other$address)) {
                return false;
            }
            String this$headphoto = this.getHeadphoto();
            String other$headphoto = other.getHeadphoto();
            if (this$headphoto == null ? other$headphoto != null : !this$headphoto.equals(other$headphoto)) {
                return false;
            }
            String this$idcardno = this.getIdcardno();
            String other$idcardno = other.getIdcardno();
            if (this$idcardno == null ? other$idcardno != null : !this$idcardno.equals(other$idcardno)) {
                return false;
            }
            String this$year = this.getYear();
            String other$year = other.getYear();
            if (this$year == null ? other$year != null : !this$year.equals(other$year)) {
                return false;
            }
            String this$month = this.getMonth();
            String other$month = other.getMonth();
            if (this$month == null ? other$month != null : !this$month.equals(other$month)) {
                return false;
            }
            String this$day = this.getDay();
            String other$day = other.getDay();
            if (this$day == null ? other$day != null : !this$day.equals(other$day)) {
                return false;
            }
            String this$certificateno = this.getCertificateno();
            String other$certificateno = other.getCertificateno();
            if (this$certificateno == null ? other$certificateno != null : !this$certificateno.equals(other$certificateno)) {
                return false;
            }
            String this$isSignature = this.getIsSignature();
            String other$isSignature = other.getIsSignature();
            if (this$isSignature == null ? other$isSignature != null : !this$isSignature.equals(other$isSignature)) {
                return false;
            }
            String this$fzDate = this.getFzDate();
            String other$fzDate = other.getFzDate();
            if (this$fzDate == null ? other$fzDate != null : !this$fzDate.equals(other$fzDate)) {
                return false;
            }
            String this$zYear = this.getZYear();
            String other$zYear = other.getZYear();
            if (this$zYear == null ? other$zYear != null : !this$zYear.equals(other$zYear)) {
                return false;
            }
            String this$zMonth = this.getZMonth();
            String other$zMonth = other.getZMonth();
            if (this$zMonth == null ? other$zMonth != null : !this$zMonth.equals(other$zMonth)) {
                return false;
            }
            String this$zDay = this.getZDay();
            String other$zDay = other.getZDay();
            if (this$zDay == null ? other$zDay != null : !this$zDay.equals(other$zDay)) {
                return false;
            }
            String this$signatureImg = this.getSignatureImg();
            String other$signatureImg = other.getSignatureImg();
            if (this$signatureImg == null ? other$signatureImg != null : !this$signatureImg.equals(other$signatureImg)) {
                return false;
            }
            String this$unSignaturePDF = this.getUnSignaturePDF();
            String other$unSignaturePDF = other.getUnSignaturePDF();
            if (this$unSignaturePDF == null ? other$unSignaturePDF != null : !this$unSignaturePDF.equals(other$unSignaturePDF)) {
                return false;
            }
            String this$signaturePDF = this.getSignaturePDF();
            String other$signaturePDF = other.getSignaturePDF();
            return !(this$signaturePDF == null ? other$signaturePDF != null : !this$signaturePDF.equals(other$signaturePDF));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SignatureData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $address = this.getAddress();
            result = result * 59 + ($address == null ? 43 : $address.hashCode());
            String $headphoto = this.getHeadphoto();
            result = result * 59 + ($headphoto == null ? 43 : $headphoto.hashCode());
            String $idcardno = this.getIdcardno();
            result = result * 59 + ($idcardno == null ? 43 : $idcardno.hashCode());
            String $year = this.getYear();
            result = result * 59 + ($year == null ? 43 : $year.hashCode());
            String $month = this.getMonth();
            result = result * 59 + ($month == null ? 43 : $month.hashCode());
            String $day = this.getDay();
            result = result * 59 + ($day == null ? 43 : $day.hashCode());
            String $certificateno = this.getCertificateno();
            result = result * 59 + ($certificateno == null ? 43 : $certificateno.hashCode());
            String $isSignature = this.getIsSignature();
            result = result * 59 + ($isSignature == null ? 43 : $isSignature.hashCode());
            String $fzDate = this.getFzDate();
            result = result * 59 + ($fzDate == null ? 43 : $fzDate.hashCode());
            String $zYear = this.getZYear();
            result = result * 59 + ($zYear == null ? 43 : $zYear.hashCode());
            String $zMonth = this.getZMonth();
            result = result * 59 + ($zMonth == null ? 43 : $zMonth.hashCode());
            String $zDay = this.getZDay();
            result = result * 59 + ($zDay == null ? 43 : $zDay.hashCode());
            String $signatureImg = this.getSignatureImg();
            result = result * 59 + ($signatureImg == null ? 43 : $signatureImg.hashCode());
            String $unSignaturePDF = this.getUnSignaturePDF();
            result = result * 59 + ($unSignaturePDF == null ? 43 : $unSignaturePDF.hashCode());
            String $signaturePDF = this.getSignaturePDF();
            result = result * 59 + ($signaturePDF == null ? 43 : $signaturePDF.hashCode());
            return result;
        }

        public String toString() {
            return "CommonSignatureToPDFCompare.SignatureData(name=" + this.getName() + ", address=" + this.getAddress() + ", headphoto=" + this.getHeadphoto() + ", idcardno=" + this.getIdcardno() + ", year=" + this.getYear() + ", month=" + this.getMonth() + ", day=" + this.getDay() + ", certificateno=" + this.getCertificateno() + ", isSignature=" + this.getIsSignature() + ", fzDate=" + this.getFzDate() + ", zYear=" + this.getZYear() + ", zMonth=" + this.getZMonth() + ", zDay=" + this.getZDay() + ", signatureImg=" + this.getSignatureImg() + ", unSignaturePDF=" + this.getUnSignaturePDF() + ", signaturePDF=" + this.getSignaturePDF() + ")";
        }
    }
}

