/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.open.jdks.responses;

import com.bcxin.tenant.open.infrastructures.ResponseAbstract;
import com.bcxin.tenant.open.infrastructures.enums.RailRuleType;
import com.bcxin.tenant.open.infrastructures.enums.RailShapeType;
import com.bcxin.tenant.open.infrastructures.valueTypes.RdSecurityStationRailSnapshootValueType;
import com.bcxin.tenant.open.jdks.requests.RdSecurityStationRailSearchRequest;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.v3.oas.annotations.media.Schema;
import java.text.SimpleDateFormat;
import java.util.Date;

@Schema(name="RdSecurityStationRailSearchResponse", title="RdSecurityStationRailSearchResponse \u7535\u5b50\u56f4\u680f\u641c\u7d22\u7ed3\u679c")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class RdSecurityStationRailSearchResponse
extends ResponseAbstract {
    @Schema(name="id", title="\u7535\u5b50\u56f4\u680fid")
    private final String id;
    @Schema(name="name", title="\u540d\u79f0")
    private final String name;
    @Schema(name="shapeType", title="\u5f62\u72b6: Circle=\u5706\u5f62; Crib=\u6846\u5f62\u72b6; Polygon=\u591a\u8fb9\u5f62")
    private final RailShapeType shapeType;
    @Schema(name="shapedLocation", title="\u5750\u6807\u53ca\u7c7b\u578b")
    private final RdSecurityStationRailSnapshootValueType.ShapedLocationValueType shapedLocation;
    @Schema(name="stationId", title="\u9a7b\u52e4\u70b9id")
    private final String stationId;
    @Schema(name="stationName", title="\u9a7b\u52e4\u70b9\u540d\u79f0")
    private final String stationName;
    @Schema(name="beginTime", title="\u5f00\u59cb\u65f6\u95f4")
    private final String beginTime;
    @Schema(name="endTime", title="\u7ed3\u675f\u65f6\u95f4")
    private final String endTime;
    @Schema(name="ruleType", title="\u56f4\u680f\u7c7b\u578b")
    private final RailRuleType ruleType;
    @Schema(name="note", title="\u5907\u6ce8")
    private final String note;
    @Schema(name="shapeTypeText", title="\u5f62\u72b6-\u6587\u672c: Circle=\u5706\u5f62; Crib=\u6846\u5f62\u72b6; Polygon=\u591a\u8fb9\u5f62")
    private final String shapeTypeText;

    @Schema(name="ruleTypeText", title="\u56f4\u680f\u7c7b\u578b-\u6587\u672c")
    public String getRuleTypeText() {
        return this.ruleType == null ? "" : this.ruleType.getTypeName();
    }

    public RdSecurityStationRailSearchResponse(RdSecurityStationRailSearchRequest.SearchModel model, long id, String name, RailShapeType shapeType, RdSecurityStationRailSnapshootValueType.ShapedLocationValueType shapedLocation, String stationId, String stationName, Date beginTime, Date endTime, RailRuleType ruleType, String note) {
        this.id = String.valueOf(id);
        this.shapeType = shapeType;
        this.shapedLocation = shapedLocation;
        if (model != RdSecurityStationRailSearchRequest.SearchModel.SecurityResource) {
            this.stationId = stationId;
            this.ruleType = ruleType;
            this.name = name;
            this.stationName = stationName;
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            this.beginTime = dateFormat.format(beginTime);
            this.endTime = dateFormat.format(endTime);
            this.note = note;
            switch (this.getShapeType()) {
                case Crib: {
                    this.shapeTypeText = "\u6846\u5f62\u72b6";
                    break;
                }
                case Polygon: {
                    this.shapeTypeText = "\u591a\u8fb9\u5f62";
                    break;
                }
                case Circle: {
                    this.shapeTypeText = "\u5706\u5f62";
                    break;
                }
                default: {
                    this.shapeTypeText = "";
                    break;
                }
            }
        } else {
            this.name = null;
            this.stationId = null;
            this.ruleType = null;
            this.stationName = null;
            this.beginTime = null;
            this.endTime = null;
            this.note = null;
            this.shapeTypeText = null;
        }
    }

    public static RdSecurityStationRailSearchResponse create(RdSecurityStationRailSearchRequest.SearchModel model, long id, String name, RailShapeType shapeType, RdSecurityStationRailSnapshootValueType.ShapedLocationValueType shapedLocation, String stationId, String stationName, Date beginTime, Date endTime, RailRuleType ruleType, String note) {
        return new RdSecurityStationRailSearchResponse(model, id, name, shapeType, shapedLocation, stationId, stationName, beginTime, endTime, ruleType, note);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public RailShapeType getShapeType() {
        return this.shapeType;
    }

    public RdSecurityStationRailSnapshootValueType.ShapedLocationValueType getShapedLocation() {
        return this.shapedLocation;
    }

    public String getStationId() {
        return this.stationId;
    }

    public String getStationName() {
        return this.stationName;
    }

    public String getBeginTime() {
        return this.beginTime;
    }

    public String getEndTime() {
        return this.endTime;
    }

    public RailRuleType getRuleType() {
        return this.ruleType;
    }

    public String getNote() {
        return this.note;
    }

    public String getShapeTypeText() {
        return this.shapeTypeText;
    }
}

