/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.open.document.domains.documents;

import com.bcxin.tenant.open.infrastructures.entities.EntityAbstract;
import com.bcxin.tenant.open.infrastructures.utils.SetUtil;
import com.redis.om.spring.annotations.Document;
import com.redis.om.spring.annotations.GeoIndexed;
import com.redis.om.spring.annotations.Indexed;
import com.redis.om.spring.annotations.Searchable;
import com.redis.om.spring.repository.query.SearchLanguage;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.data.annotation.Id;
import org.springframework.data.geo.Point;
import org.springframework.util.StringUtils;

@Document(language=SearchLanguage.CHINESE)
public class RdProjectDocument
extends EntityAbstract {
    @Id
    @Indexed
    private String id;
    private String name;
    private String companyName;
    @Searchable(sortable=false, nostem=true, weight=20.0)
    private String keyword;
    private String state;
    @Indexed
    @GeoIndexed
    private Point lonLat;
    private String organizationId;
    @Indexed
    private Set<String> scopePermissions;
    private String beginDate;
    private String endDate;
    private String principalId;
    private String principalName;
    private String principalTelephone;
    private int countOfMembers;
    private int countOfTeams;
    private int countOfStations;

    public void updateWord(String ... text) {
        if (text == null || text.length == 0) {
            this.setKeyword("");
        }
        String content = Arrays.stream(text).filter(ii -> StringUtils.hasLength((String)ii)).collect(Collectors.joining(" "));
        this.setKeyword(content);
    }

    public void rest() {
        this.setScopePermissions(new HashSet<String>());
    }

    public void addScopePermissions(String ... scopeIds) {
        this.setScopePermissions(SetUtil.merge(this.getScopePermissions(), (Object[])scopeIds));
    }

    public static RdProjectDocument create(String id, String name) {
        RdProjectDocument document = new RdProjectDocument();
        document.setId(id);
        document.setName(name);
        return document;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getCompanyName() {
        return this.companyName;
    }

    public String getKeyword() {
        return this.keyword;
    }

    public String getState() {
        return this.state;
    }

    public Point getLonLat() {
        return this.lonLat;
    }

    public String getOrganizationId() {
        return this.organizationId;
    }

    public Set<String> getScopePermissions() {
        return this.scopePermissions;
    }

    public String getBeginDate() {
        return this.beginDate;
    }

    public String getEndDate() {
        return this.endDate;
    }

    public String getPrincipalId() {
        return this.principalId;
    }

    public String getPrincipalName() {
        return this.principalName;
    }

    public String getPrincipalTelephone() {
        return this.principalTelephone;
    }

    public int getCountOfMembers() {
        return this.countOfMembers;
    }

    public int getCountOfTeams() {
        return this.countOfTeams;
    }

    public int getCountOfStations() {
        return this.countOfStations;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public void setKeyword(String keyword) {
        this.keyword = keyword;
    }

    public void setState(String state) {
        this.state = state;
    }

    public void setLonLat(Point lonLat) {
        this.lonLat = lonLat;
    }

    public void setOrganizationId(String organizationId) {
        this.organizationId = organizationId;
    }

    public void setScopePermissions(Set<String> scopePermissions) {
        this.scopePermissions = scopePermissions;
    }

    public void setBeginDate(String beginDate) {
        this.beginDate = beginDate;
    }

    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }

    public void setPrincipalId(String principalId) {
        this.principalId = principalId;
    }

    public void setPrincipalName(String principalName) {
        this.principalName = principalName;
    }

    public void setPrincipalTelephone(String principalTelephone) {
        this.principalTelephone = principalTelephone;
    }

    public void setCountOfMembers(int countOfMembers) {
        this.countOfMembers = countOfMembers;
    }

    public void setCountOfTeams(int countOfTeams) {
        this.countOfTeams = countOfTeams;
    }

    public void setCountOfStations(int countOfStations) {
        this.countOfStations = countOfStations;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RdProjectDocument)) {
            return false;
        }
        RdProjectDocument other = (RdProjectDocument)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getCountOfMembers() != other.getCountOfMembers()) {
            return false;
        }
        if (this.getCountOfTeams() != other.getCountOfTeams()) {
            return false;
        }
        if (this.getCountOfStations() != other.getCountOfStations()) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$companyName = this.getCompanyName();
        String other$companyName = other.getCompanyName();
        if (this$companyName == null ? other$companyName != null : !this$companyName.equals(other$companyName)) {
            return false;
        }
        String this$keyword = this.getKeyword();
        String other$keyword = other.getKeyword();
        if (this$keyword == null ? other$keyword != null : !this$keyword.equals(other$keyword)) {
            return false;
        }
        String this$state = this.getState();
        String other$state = other.getState();
        if (this$state == null ? other$state != null : !this$state.equals(other$state)) {
            return false;
        }
        Point this$lonLat = this.getLonLat();
        Point other$lonLat = other.getLonLat();
        if (this$lonLat == null ? other$lonLat != null : !this$lonLat.equals(other$lonLat)) {
            return false;
        }
        String this$organizationId = this.getOrganizationId();
        String other$organizationId = other.getOrganizationId();
        if (this$organizationId == null ? other$organizationId != null : !this$organizationId.equals(other$organizationId)) {
            return false;
        }
        Set<String> this$scopePermissions = this.getScopePermissions();
        Set<String> other$scopePermissions = other.getScopePermissions();
        if (this$scopePermissions == null ? other$scopePermissions != null : !((Object)this$scopePermissions).equals(other$scopePermissions)) {
            return false;
        }
        String this$beginDate = this.getBeginDate();
        String other$beginDate = other.getBeginDate();
        if (this$beginDate == null ? other$beginDate != null : !this$beginDate.equals(other$beginDate)) {
            return false;
        }
        String this$endDate = this.getEndDate();
        String other$endDate = other.getEndDate();
        if (this$endDate == null ? other$endDate != null : !this$endDate.equals(other$endDate)) {
            return false;
        }
        String this$principalId = this.getPrincipalId();
        String other$principalId = other.getPrincipalId();
        if (this$principalId == null ? other$principalId != null : !this$principalId.equals(other$principalId)) {
            return false;
        }
        String this$principalName = this.getPrincipalName();
        String other$principalName = other.getPrincipalName();
        if (this$principalName == null ? other$principalName != null : !this$principalName.equals(other$principalName)) {
            return false;
        }
        String this$principalTelephone = this.getPrincipalTelephone();
        String other$principalTelephone = other.getPrincipalTelephone();
        return !(this$principalTelephone == null ? other$principalTelephone != null : !this$principalTelephone.equals(other$principalTelephone));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RdProjectDocument;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCountOfMembers();
        result = result * 59 + this.getCountOfTeams();
        result = result * 59 + this.getCountOfStations();
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $companyName = this.getCompanyName();
        result = result * 59 + ($companyName == null ? 43 : $companyName.hashCode());
        String $keyword = this.getKeyword();
        result = result * 59 + ($keyword == null ? 43 : $keyword.hashCode());
        String $state = this.getState();
        result = result * 59 + ($state == null ? 43 : $state.hashCode());
        Point $lonLat = this.getLonLat();
        result = result * 59 + ($lonLat == null ? 43 : $lonLat.hashCode());
        String $organizationId = this.getOrganizationId();
        result = result * 59 + ($organizationId == null ? 43 : $organizationId.hashCode());
        Set<String> $scopePermissions = this.getScopePermissions();
        result = result * 59 + ($scopePermissions == null ? 43 : ((Object)$scopePermissions).hashCode());
        String $beginDate = this.getBeginDate();
        result = result * 59 + ($beginDate == null ? 43 : $beginDate.hashCode());
        String $endDate = this.getEndDate();
        result = result * 59 + ($endDate == null ? 43 : $endDate.hashCode());
        String $principalId = this.getPrincipalId();
        result = result * 59 + ($principalId == null ? 43 : $principalId.hashCode());
        String $principalName = this.getPrincipalName();
        result = result * 59 + ($principalName == null ? 43 : $principalName.hashCode());
        String $principalTelephone = this.getPrincipalTelephone();
        result = result * 59 + ($principalTelephone == null ? 43 : $principalTelephone.hashCode());
        return result;
    }

    public String toString() {
        return "RdProjectDocument(id=" + this.getId() + ", name=" + this.getName() + ", companyName=" + this.getCompanyName() + ", keyword=" + this.getKeyword() + ", state=" + this.getState() + ", lonLat=" + this.getLonLat() + ", organizationId=" + this.getOrganizationId() + ", scopePermissions=" + this.getScopePermissions() + ", beginDate=" + this.getBeginDate() + ", endDate=" + this.getEndDate() + ", principalId=" + this.getPrincipalId() + ", principalName=" + this.getPrincipalName() + ", principalTelephone=" + this.getPrincipalTelephone() + ", countOfMembers=" + this.getCountOfMembers() + ", countOfTeams=" + this.getCountOfTeams() + ", countOfStations=" + this.getCountOfStations() + ")";
    }
}

