/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.open.document.domains.documents;

import com.bcxin.tenant.open.infrastructures.entities.Aggregate;
import com.bcxin.tenant.open.infrastructures.entities.EntityAbstract;
import com.bcxin.tenant.open.infrastructures.enums.CommunicatedType;
import com.bcxin.tenant.open.infrastructures.enums.DutySignInType;
import com.bcxin.tenant.open.infrastructures.enums.EmploymentStatus;
import com.bcxin.tenant.open.infrastructures.enums.OccupationType;
import com.bcxin.tenant.open.infrastructures.enums.RealNameAuthenticatedStatus;
import com.bcxin.tenant.open.infrastructures.enums.RecordStatus;
import com.bcxin.tenant.open.infrastructures.enums.Sex;
import com.bcxin.tenant.open.infrastructures.enums.UserCheckedStatus;
import com.bcxin.tenant.open.infrastructures.utils.SetUtil;
import com.bcxin.tenant.open.infrastructures.valueTypes.LocationAddressValueType;
import com.redis.om.spring.annotations.Document;
import com.redis.om.spring.annotations.GeoIndexed;
import com.redis.om.spring.annotations.Indexed;
import com.redis.om.spring.annotations.TagIndexed;
import com.redis.om.spring.repository.query.SearchLanguage;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.springframework.data.annotation.Id;
import org.springframework.data.geo.Point;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Document(language=SearchLanguage.CHINESE)
public class RdEmployeeDocument
extends EntityAbstract
implements Aggregate {
    @Id
    @Indexed
    private String id;
    @Indexed
    private String name;
    @Indexed
    private String idCardNo;
    private CommunicatedType communicatedType;
    private int yardmanType;
    private String headPhoto;
    private String contact;
    @Indexed
    private String companyName;
    private EmploymentStatus status;
    private UserCheckedStatus checkedStatus;
    private RealNameAuthenticatedStatus authenticatedStatus;
    @Indexed
    private String dutyStatus;
    private String militaryStatus;
    private String securityCertificateNo;
    @Indexed
    @TagIndexed
    private Set<String> followedDeviceNos;
    @Indexed
    @GeoIndexed
    private Point lonLat;
    public LocationAddressValueType geoAddress;
    @Indexed
    private OccupationType occupationType;
    private Date hiredDate;
    private boolean insure;
    @Indexed
    private String organizationId;
    @Indexed
    private String tenantUserId;
    private String tenantEmployeeId;
    @Indexed
    private String superviseDepartId;
    private String superviseDepartName;
    private String deviceNumber;
    private String tenantImUserId;
    @Indexed
    private String securityStationId;
    @Indexed
    private String securityStationName;
    @Indexed
    private Set<String> stationTypes;
    @Indexed
    private Set<String> scopePermissions;
    @Indexed
    private Boolean dispatchable;
    private String superviseRegionCode;
    private String cId;
    private Set<String> securityStationRailIds;
    private Sex sex;
    private Set<String> responsibleOfStationIds;
    private boolean domainAdmin;
    @Indexed
    private Set<String> resourceTypes;
    private String industry;
    private String institutional;
    private String proprietorCompanyName;
    private String proprietorCompanyId;
    private Timestamp lastUpdatedTime;
    private Timestamp lastDutyStatusChangedTime;
    private int cLevel;
    private Set<String> examSiteId;
    private String thirdParty;
    private String paymentOrgId;
    private static final String INCORRECT_NOTE = "\u6f0f\u6d1e:";

    public void addScopePermissions(String ... scopeIds) {
        this.setScopePermissions(SetUtil.merge(this.getScopePermissions(), (Object[])scopeIds));
    }

    public void assignProprietor(String companyId, String companyName) {
        this.setProprietorCompanyId(companyId);
        this.setProprietorCompanyName(companyName);
    }

    public void removeBusinessScopePermissions(String ... scopeIds) {
        this.setScopePermissions(SetUtil.remove(this.getScopePermissions(), (Object[])scopeIds));
        this.setScopePermissions(SetUtil.merge(this.getScopePermissions(), (Object[])new String[]{this.getOrganizationId(), this.getSuperviseDepartId()}));
    }

    public boolean hasMatchedStationRailMessage(String railId) {
        if (!StringUtils.hasLength((String)railId)) {
            return true;
        }
        if (this.getSecurityStationRailIds() == null || this.getSecurityStationRailIds().size() == 0) {
            return false;
        }
        return this.getSecurityStationRailIds().contains(railId);
    }

    public void addStationRailMessage(String railId) {
        if (!StringUtils.hasLength((String)railId)) {
            return;
        }
        Set<String> railIds = this.getSecurityStationRailIds();
        if (this.getSecurityStationRailIds() == null) {
            railIds = new HashSet<String>();
        }
        railIds.add(railId);
        this.setSecurityStationRailIds(railIds);
        this.setLastUpdatedTime(Timestamp.from(Instant.now()));
    }

    public void removeFromStationRailMessage(String railId) {
        if (!StringUtils.hasLength((String)railId)) {
            return;
        }
        Set<String> railIds = this.getSecurityStationRailIds();
        if (this.getSecurityStationRailIds() == null) {
            return;
        }
        railIds.remove(railId);
        this.setSecurityStationRailIds(railIds);
    }

    public void changeDutyStatus(RecordStatus status, Point lonLat) {
        switch (status) {
            case SignIn: {
                this.setDutyStatus(DutySignInType.SignIn.name());
                this.makeDispatchable(true, null);
                this.setLastDutyStatusChangedTime(Timestamp.from(Instant.now()));
                break;
            }
            case SignOut: {
                this.setDutyStatus(DutySignInType.SignOut.name());
                this.makeDispatchable(false, null);
                this.setLastDutyStatusChangedTime(Timestamp.from(Instant.now()));
            }
        }
        this.changeLonLat(lonLat);
    }

    public void changeLonLat(Point lonLat) {
        if (lonLat != null) {
            this.setLonLat(lonLat);
            this.setLastDutyStatusChangedTime(Timestamp.from(Instant.now()));
        }
    }

    public void makeDispatchable(boolean dispatchable, String message) {
        this.setDispatchable(dispatchable);
    }

    public void changeDeviceNumber(String deviceNumber) {
        this.setDeviceNumber(deviceNumber);
    }

    public boolean addFollowedDeviceNo(String deviceNo) {
        this.setFollowedDeviceNos(SetUtil.merge(this.getFollowedDeviceNos(), (Object[])new String[]{deviceNo}));
        return true;
    }

    public boolean removeFollowedDeviceNo(String deviceNo) {
        this.setFollowedDeviceNos(SetUtil.remove(this.getFollowedDeviceNos(), (Object[])new String[]{deviceNo}));
        return true;
    }

    public DutySignInType getDutySignInEnumType() {
        if (!StringUtils.hasLength((String)this.getDutyStatus())) {
            return null;
        }
        switch (this.getDutyStatus()) {
            case "SignIn": {
                return DutySignInType.SignIn;
            }
            case "SignOut": {
                return DutySignInType.SignOut;
            }
            case "None": {
                return DutySignInType.None;
            }
        }
        return null;
    }

    public void addResourceTypes(String ... resourceTypes) {
        this.setResourceTypes(SetUtil.merge(this.getResourceTypes(), (Object[])resourceTypes));
    }

    public void addResponsibleOfStationIds(String stationId) {
        if (StringUtils.hasLength((String)stationId)) {
            Object[] stationIds = stationId.split(";|,");
            this.setResponsibleOfStationIds(SetUtil.merge(this.getResponsibleOfStationIds(), (Object[])stationIds));
        }
    }

    public void rest() {
        this.setResponsibleOfStationIds(new HashSet<String>());
        this.setSuperviseDepartId("#1");
        this.setScopePermissions(new HashSet<String>());
        this.setResourceTypes(new HashSet<String>());
        this.setProprietorCompanyName(null);
        this.setProprietorCompanyId(null);
    }

    public String getSelectedResponsibleOfStationId(String stationId) {
        if (!StringUtils.hasLength((String)stationId) || CollectionUtils.isEmpty(this.getResponsibleOfStationIds())) {
            return "#1";
        }
        return this.getResponsibleOfStationIds().contains(stationId) ? stationId : "#1";
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getIdCardNo() {
        return this.idCardNo;
    }

    public CommunicatedType getCommunicatedType() {
        return this.communicatedType;
    }

    public int getYardmanType() {
        return this.yardmanType;
    }

    public String getHeadPhoto() {
        return this.headPhoto;
    }

    public String getContact() {
        return this.contact;
    }

    public String getCompanyName() {
        return this.companyName;
    }

    public EmploymentStatus getStatus() {
        return this.status;
    }

    public UserCheckedStatus getCheckedStatus() {
        return this.checkedStatus;
    }

    public RealNameAuthenticatedStatus getAuthenticatedStatus() {
        return this.authenticatedStatus;
    }

    public String getDutyStatus() {
        return this.dutyStatus;
    }

    public String getMilitaryStatus() {
        return this.militaryStatus;
    }

    public String getSecurityCertificateNo() {
        return this.securityCertificateNo;
    }

    public Set<String> getFollowedDeviceNos() {
        return this.followedDeviceNos;
    }

    public Point getLonLat() {
        return this.lonLat;
    }

    public LocationAddressValueType getGeoAddress() {
        return this.geoAddress;
    }

    public OccupationType getOccupationType() {
        return this.occupationType;
    }

    public Date getHiredDate() {
        return this.hiredDate;
    }

    public boolean isInsure() {
        return this.insure;
    }

    public String getOrganizationId() {
        return this.organizationId;
    }

    public String getTenantUserId() {
        return this.tenantUserId;
    }

    public String getTenantEmployeeId() {
        return this.tenantEmployeeId;
    }

    public String getSuperviseDepartId() {
        return this.superviseDepartId;
    }

    public String getSuperviseDepartName() {
        return this.superviseDepartName;
    }

    public String getDeviceNumber() {
        return this.deviceNumber;
    }

    public String getTenantImUserId() {
        return this.tenantImUserId;
    }

    public String getSecurityStationId() {
        return this.securityStationId;
    }

    public String getSecurityStationName() {
        return this.securityStationName;
    }

    public Set<String> getStationTypes() {
        return this.stationTypes;
    }

    public Set<String> getScopePermissions() {
        return this.scopePermissions;
    }

    public Boolean getDispatchable() {
        return this.dispatchable;
    }

    public String getSuperviseRegionCode() {
        return this.superviseRegionCode;
    }

    public String getCId() {
        return this.cId;
    }

    public Set<String> getSecurityStationRailIds() {
        return this.securityStationRailIds;
    }

    public Sex getSex() {
        return this.sex;
    }

    public Set<String> getResponsibleOfStationIds() {
        return this.responsibleOfStationIds;
    }

    public boolean isDomainAdmin() {
        return this.domainAdmin;
    }

    public Set<String> getResourceTypes() {
        return this.resourceTypes;
    }

    public String getIndustry() {
        return this.industry;
    }

    public String getInstitutional() {
        return this.institutional;
    }

    public String getProprietorCompanyName() {
        return this.proprietorCompanyName;
    }

    public String getProprietorCompanyId() {
        return this.proprietorCompanyId;
    }

    public Timestamp getLastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public Timestamp getLastDutyStatusChangedTime() {
        return this.lastDutyStatusChangedTime;
    }

    public int getCLevel() {
        return this.cLevel;
    }

    public Set<String> getExamSiteId() {
        return this.examSiteId;
    }

    public String getThirdParty() {
        return this.thirdParty;
    }

    public String getPaymentOrgId() {
        return this.paymentOrgId;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setIdCardNo(String idCardNo) {
        this.idCardNo = idCardNo;
    }

    public void setCommunicatedType(CommunicatedType communicatedType) {
        this.communicatedType = communicatedType;
    }

    public void setYardmanType(int yardmanType) {
        this.yardmanType = yardmanType;
    }

    public void setHeadPhoto(String headPhoto) {
        this.headPhoto = headPhoto;
    }

    public void setContact(String contact) {
        this.contact = contact;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public void setStatus(EmploymentStatus status) {
        this.status = status;
    }

    public void setCheckedStatus(UserCheckedStatus checkedStatus) {
        this.checkedStatus = checkedStatus;
    }

    public void setAuthenticatedStatus(RealNameAuthenticatedStatus authenticatedStatus) {
        this.authenticatedStatus = authenticatedStatus;
    }

    public void setDutyStatus(String dutyStatus) {
        this.dutyStatus = dutyStatus;
    }

    public void setMilitaryStatus(String militaryStatus) {
        this.militaryStatus = militaryStatus;
    }

    public void setSecurityCertificateNo(String securityCertificateNo) {
        this.securityCertificateNo = securityCertificateNo;
    }

    public void setFollowedDeviceNos(Set<String> followedDeviceNos) {
        this.followedDeviceNos = followedDeviceNos;
    }

    public void setLonLat(Point lonLat) {
        this.lonLat = lonLat;
    }

    public void setGeoAddress(LocationAddressValueType geoAddress) {
        this.geoAddress = geoAddress;
    }

    public void setOccupationType(OccupationType occupationType) {
        this.occupationType = occupationType;
    }

    public void setHiredDate(Date hiredDate) {
        this.hiredDate = hiredDate;
    }

    public void setInsure(boolean insure) {
        this.insure = insure;
    }

    public void setOrganizationId(String organizationId) {
        this.organizationId = organizationId;
    }

    public void setTenantUserId(String tenantUserId) {
        this.tenantUserId = tenantUserId;
    }

    public void setTenantEmployeeId(String tenantEmployeeId) {
        this.tenantEmployeeId = tenantEmployeeId;
    }

    public void setSuperviseDepartId(String superviseDepartId) {
        this.superviseDepartId = superviseDepartId;
    }

    public void setSuperviseDepartName(String superviseDepartName) {
        this.superviseDepartName = superviseDepartName;
    }

    public void setDeviceNumber(String deviceNumber) {
        this.deviceNumber = deviceNumber;
    }

    public void setTenantImUserId(String tenantImUserId) {
        this.tenantImUserId = tenantImUserId;
    }

    public void setSecurityStationId(String securityStationId) {
        this.securityStationId = securityStationId;
    }

    public void setSecurityStationName(String securityStationName) {
        this.securityStationName = securityStationName;
    }

    public void setStationTypes(Set<String> stationTypes) {
        this.stationTypes = stationTypes;
    }

    public void setScopePermissions(Set<String> scopePermissions) {
        this.scopePermissions = scopePermissions;
    }

    public void setDispatchable(Boolean dispatchable) {
        this.dispatchable = dispatchable;
    }

    public void setSuperviseRegionCode(String superviseRegionCode) {
        this.superviseRegionCode = superviseRegionCode;
    }

    public void setCId(String cId) {
        this.cId = cId;
    }

    public void setSecurityStationRailIds(Set<String> securityStationRailIds) {
        this.securityStationRailIds = securityStationRailIds;
    }

    public void setSex(Sex sex) {
        this.sex = sex;
    }

    public void setResponsibleOfStationIds(Set<String> responsibleOfStationIds) {
        this.responsibleOfStationIds = responsibleOfStationIds;
    }

    public void setDomainAdmin(boolean domainAdmin) {
        this.domainAdmin = domainAdmin;
    }

    public void setResourceTypes(Set<String> resourceTypes) {
        this.resourceTypes = resourceTypes;
    }

    public void setIndustry(String industry) {
        this.industry = industry;
    }

    public void setInstitutional(String institutional) {
        this.institutional = institutional;
    }

    public void setProprietorCompanyName(String proprietorCompanyName) {
        this.proprietorCompanyName = proprietorCompanyName;
    }

    public void setProprietorCompanyId(String proprietorCompanyId) {
        this.proprietorCompanyId = proprietorCompanyId;
    }

    public void setLastUpdatedTime(Timestamp lastUpdatedTime) {
        this.lastUpdatedTime = lastUpdatedTime;
    }

    public void setLastDutyStatusChangedTime(Timestamp lastDutyStatusChangedTime) {
        this.lastDutyStatusChangedTime = lastDutyStatusChangedTime;
    }

    public void setCLevel(int cLevel) {
        this.cLevel = cLevel;
    }

    public void setExamSiteId(Set<String> examSiteId) {
        this.examSiteId = examSiteId;
    }

    public void setThirdParty(String thirdParty) {
        this.thirdParty = thirdParty;
    }

    public void setPaymentOrgId(String paymentOrgId) {
        this.paymentOrgId = paymentOrgId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RdEmployeeDocument)) {
            return false;
        }
        RdEmployeeDocument other = (RdEmployeeDocument)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getYardmanType() != other.getYardmanType()) {
            return false;
        }
        if (this.isInsure() != other.isInsure()) {
            return false;
        }
        if (this.isDomainAdmin() != other.isDomainAdmin()) {
            return false;
        }
        if (this.getCLevel() != other.getCLevel()) {
            return false;
        }
        Boolean this$dispatchable = this.getDispatchable();
        Boolean other$dispatchable = other.getDispatchable();
        if (this$dispatchable == null ? other$dispatchable != null : !((Object)this$dispatchable).equals(other$dispatchable)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$idCardNo = this.getIdCardNo();
        String other$idCardNo = other.getIdCardNo();
        if (this$idCardNo == null ? other$idCardNo != null : !this$idCardNo.equals(other$idCardNo)) {
            return false;
        }
        CommunicatedType this$communicatedType = this.getCommunicatedType();
        CommunicatedType other$communicatedType = other.getCommunicatedType();
        if (this$communicatedType == null ? other$communicatedType != null : !this$communicatedType.equals(other$communicatedType)) {
            return false;
        }
        String this$headPhoto = this.getHeadPhoto();
        String other$headPhoto = other.getHeadPhoto();
        if (this$headPhoto == null ? other$headPhoto != null : !this$headPhoto.equals(other$headPhoto)) {
            return false;
        }
        String this$contact = this.getContact();
        String other$contact = other.getContact();
        if (this$contact == null ? other$contact != null : !this$contact.equals(other$contact)) {
            return false;
        }
        String this$companyName = this.getCompanyName();
        String other$companyName = other.getCompanyName();
        if (this$companyName == null ? other$companyName != null : !this$companyName.equals(other$companyName)) {
            return false;
        }
        EmploymentStatus this$status = this.getStatus();
        EmploymentStatus other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        UserCheckedStatus this$checkedStatus = this.getCheckedStatus();
        UserCheckedStatus other$checkedStatus = other.getCheckedStatus();
        if (this$checkedStatus == null ? other$checkedStatus != null : !this$checkedStatus.equals(other$checkedStatus)) {
            return false;
        }
        RealNameAuthenticatedStatus this$authenticatedStatus = this.getAuthenticatedStatus();
        RealNameAuthenticatedStatus other$authenticatedStatus = other.getAuthenticatedStatus();
        if (this$authenticatedStatus == null ? other$authenticatedStatus != null : !this$authenticatedStatus.equals(other$authenticatedStatus)) {
            return false;
        }
        String this$dutyStatus = this.getDutyStatus();
        String other$dutyStatus = other.getDutyStatus();
        if (this$dutyStatus == null ? other$dutyStatus != null : !this$dutyStatus.equals(other$dutyStatus)) {
            return false;
        }
        String this$militaryStatus = this.getMilitaryStatus();
        String other$militaryStatus = other.getMilitaryStatus();
        if (this$militaryStatus == null ? other$militaryStatus != null : !this$militaryStatus.equals(other$militaryStatus)) {
            return false;
        }
        String this$securityCertificateNo = this.getSecurityCertificateNo();
        String other$securityCertificateNo = other.getSecurityCertificateNo();
        if (this$securityCertificateNo == null ? other$securityCertificateNo != null : !this$securityCertificateNo.equals(other$securityCertificateNo)) {
            return false;
        }
        Set<String> this$followedDeviceNos = this.getFollowedDeviceNos();
        Set<String> other$followedDeviceNos = other.getFollowedDeviceNos();
        if (this$followedDeviceNos == null ? other$followedDeviceNos != null : !((Object)this$followedDeviceNos).equals(other$followedDeviceNos)) {
            return false;
        }
        Point this$lonLat = this.getLonLat();
        Point other$lonLat = other.getLonLat();
        if (this$lonLat == null ? other$lonLat != null : !this$lonLat.equals(other$lonLat)) {
            return false;
        }
        LocationAddressValueType this$geoAddress = this.getGeoAddress();
        LocationAddressValueType other$geoAddress = other.getGeoAddress();
        if (this$geoAddress == null ? other$geoAddress != null : !this$geoAddress.equals(other$geoAddress)) {
            return false;
        }
        OccupationType this$occupationType = this.getOccupationType();
        OccupationType other$occupationType = other.getOccupationType();
        if (this$occupationType == null ? other$occupationType != null : !this$occupationType.equals(other$occupationType)) {
            return false;
        }
        Date this$hiredDate = this.getHiredDate();
        Date other$hiredDate = other.getHiredDate();
        if (this$hiredDate == null ? other$hiredDate != null : !((Object)this$hiredDate).equals(other$hiredDate)) {
            return false;
        }
        String this$organizationId = this.getOrganizationId();
        String other$organizationId = other.getOrganizationId();
        if (this$organizationId == null ? other$organizationId != null : !this$organizationId.equals(other$organizationId)) {
            return false;
        }
        String this$tenantUserId = this.getTenantUserId();
        String other$tenantUserId = other.getTenantUserId();
        if (this$tenantUserId == null ? other$tenantUserId != null : !this$tenantUserId.equals(other$tenantUserId)) {
            return false;
        }
        String this$tenantEmployeeId = this.getTenantEmployeeId();
        String other$tenantEmployeeId = other.getTenantEmployeeId();
        if (this$tenantEmployeeId == null ? other$tenantEmployeeId != null : !this$tenantEmployeeId.equals(other$tenantEmployeeId)) {
            return false;
        }
        String this$superviseDepartId = this.getSuperviseDepartId();
        String other$superviseDepartId = other.getSuperviseDepartId();
        if (this$superviseDepartId == null ? other$superviseDepartId != null : !this$superviseDepartId.equals(other$superviseDepartId)) {
            return false;
        }
        String this$superviseDepartName = this.getSuperviseDepartName();
        String other$superviseDepartName = other.getSuperviseDepartName();
        if (this$superviseDepartName == null ? other$superviseDepartName != null : !this$superviseDepartName.equals(other$superviseDepartName)) {
            return false;
        }
        String this$deviceNumber = this.getDeviceNumber();
        String other$deviceNumber = other.getDeviceNumber();
        if (this$deviceNumber == null ? other$deviceNumber != null : !this$deviceNumber.equals(other$deviceNumber)) {
            return false;
        }
        String this$tenantImUserId = this.getTenantImUserId();
        String other$tenantImUserId = other.getTenantImUserId();
        if (this$tenantImUserId == null ? other$tenantImUserId != null : !this$tenantImUserId.equals(other$tenantImUserId)) {
            return false;
        }
        String this$securityStationId = this.getSecurityStationId();
        String other$securityStationId = other.getSecurityStationId();
        if (this$securityStationId == null ? other$securityStationId != null : !this$securityStationId.equals(other$securityStationId)) {
            return false;
        }
        String this$securityStationName = this.getSecurityStationName();
        String other$securityStationName = other.getSecurityStationName();
        if (this$securityStationName == null ? other$securityStationName != null : !this$securityStationName.equals(other$securityStationName)) {
            return false;
        }
        Set<String> this$stationTypes = this.getStationTypes();
        Set<String> other$stationTypes = other.getStationTypes();
        if (this$stationTypes == null ? other$stationTypes != null : !((Object)this$stationTypes).equals(other$stationTypes)) {
            return false;
        }
        Set<String> this$scopePermissions = this.getScopePermissions();
        Set<String> other$scopePermissions = other.getScopePermissions();
        if (this$scopePermissions == null ? other$scopePermissions != null : !((Object)this$scopePermissions).equals(other$scopePermissions)) {
            return false;
        }
        String this$superviseRegionCode = this.getSuperviseRegionCode();
        String other$superviseRegionCode = other.getSuperviseRegionCode();
        if (this$superviseRegionCode == null ? other$superviseRegionCode != null : !this$superviseRegionCode.equals(other$superviseRegionCode)) {
            return false;
        }
        String this$cId = this.getCId();
        String other$cId = other.getCId();
        if (this$cId == null ? other$cId != null : !this$cId.equals(other$cId)) {
            return false;
        }
        Set<String> this$securityStationRailIds = this.getSecurityStationRailIds();
        Set<String> other$securityStationRailIds = other.getSecurityStationRailIds();
        if (this$securityStationRailIds == null ? other$securityStationRailIds != null : !((Object)this$securityStationRailIds).equals(other$securityStationRailIds)) {
            return false;
        }
        Sex this$sex = this.getSex();
        Sex other$sex = other.getSex();
        if (this$sex == null ? other$sex != null : !this$sex.equals(other$sex)) {
            return false;
        }
        Set<String> this$responsibleOfStationIds = this.getResponsibleOfStationIds();
        Set<String> other$responsibleOfStationIds = other.getResponsibleOfStationIds();
        if (this$responsibleOfStationIds == null ? other$responsibleOfStationIds != null : !((Object)this$responsibleOfStationIds).equals(other$responsibleOfStationIds)) {
            return false;
        }
        Set<String> this$resourceTypes = this.getResourceTypes();
        Set<String> other$resourceTypes = other.getResourceTypes();
        if (this$resourceTypes == null ? other$resourceTypes != null : !((Object)this$resourceTypes).equals(other$resourceTypes)) {
            return false;
        }
        String this$industry = this.getIndustry();
        String other$industry = other.getIndustry();
        if (this$industry == null ? other$industry != null : !this$industry.equals(other$industry)) {
            return false;
        }
        String this$institutional = this.getInstitutional();
        String other$institutional = other.getInstitutional();
        if (this$institutional == null ? other$institutional != null : !this$institutional.equals(other$institutional)) {
            return false;
        }
        String this$proprietorCompanyName = this.getProprietorCompanyName();
        String other$proprietorCompanyName = other.getProprietorCompanyName();
        if (this$proprietorCompanyName == null ? other$proprietorCompanyName != null : !this$proprietorCompanyName.equals(other$proprietorCompanyName)) {
            return false;
        }
        String this$proprietorCompanyId = this.getProprietorCompanyId();
        String other$proprietorCompanyId = other.getProprietorCompanyId();
        if (this$proprietorCompanyId == null ? other$proprietorCompanyId != null : !this$proprietorCompanyId.equals(other$proprietorCompanyId)) {
            return false;
        }
        Timestamp this$lastUpdatedTime = this.getLastUpdatedTime();
        Timestamp other$lastUpdatedTime = other.getLastUpdatedTime();
        if (this$lastUpdatedTime == null ? other$lastUpdatedTime != null : !((Object)this$lastUpdatedTime).equals(other$lastUpdatedTime)) {
            return false;
        }
        Timestamp this$lastDutyStatusChangedTime = this.getLastDutyStatusChangedTime();
        Timestamp other$lastDutyStatusChangedTime = other.getLastDutyStatusChangedTime();
        if (this$lastDutyStatusChangedTime == null ? other$lastDutyStatusChangedTime != null : !((Object)this$lastDutyStatusChangedTime).equals(other$lastDutyStatusChangedTime)) {
            return false;
        }
        Set<String> this$examSiteId = this.getExamSiteId();
        Set<String> other$examSiteId = other.getExamSiteId();
        if (this$examSiteId == null ? other$examSiteId != null : !((Object)this$examSiteId).equals(other$examSiteId)) {
            return false;
        }
        String this$thirdParty = this.getThirdParty();
        String other$thirdParty = other.getThirdParty();
        if (this$thirdParty == null ? other$thirdParty != null : !this$thirdParty.equals(other$thirdParty)) {
            return false;
        }
        String this$paymentOrgId = this.getPaymentOrgId();
        String other$paymentOrgId = other.getPaymentOrgId();
        return !(this$paymentOrgId == null ? other$paymentOrgId != null : !this$paymentOrgId.equals(other$paymentOrgId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RdEmployeeDocument;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getYardmanType();
        result = result * 59 + (this.isInsure() ? 79 : 97);
        result = result * 59 + (this.isDomainAdmin() ? 79 : 97);
        result = result * 59 + this.getCLevel();
        Boolean $dispatchable = this.getDispatchable();
        result = result * 59 + ($dispatchable == null ? 43 : ((Object)$dispatchable).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $idCardNo = this.getIdCardNo();
        result = result * 59 + ($idCardNo == null ? 43 : $idCardNo.hashCode());
        CommunicatedType $communicatedType = this.getCommunicatedType();
        result = result * 59 + ($communicatedType == null ? 43 : $communicatedType.hashCode());
        String $headPhoto = this.getHeadPhoto();
        result = result * 59 + ($headPhoto == null ? 43 : $headPhoto.hashCode());
        String $contact = this.getContact();
        result = result * 59 + ($contact == null ? 43 : $contact.hashCode());
        String $companyName = this.getCompanyName();
        result = result * 59 + ($companyName == null ? 43 : $companyName.hashCode());
        EmploymentStatus $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        UserCheckedStatus $checkedStatus = this.getCheckedStatus();
        result = result * 59 + ($checkedStatus == null ? 43 : $checkedStatus.hashCode());
        RealNameAuthenticatedStatus $authenticatedStatus = this.getAuthenticatedStatus();
        result = result * 59 + ($authenticatedStatus == null ? 43 : $authenticatedStatus.hashCode());
        String $dutyStatus = this.getDutyStatus();
        result = result * 59 + ($dutyStatus == null ? 43 : $dutyStatus.hashCode());
        String $militaryStatus = this.getMilitaryStatus();
        result = result * 59 + ($militaryStatus == null ? 43 : $militaryStatus.hashCode());
        String $securityCertificateNo = this.getSecurityCertificateNo();
        result = result * 59 + ($securityCertificateNo == null ? 43 : $securityCertificateNo.hashCode());
        Set<String> $followedDeviceNos = this.getFollowedDeviceNos();
        result = result * 59 + ($followedDeviceNos == null ? 43 : ((Object)$followedDeviceNos).hashCode());
        Point $lonLat = this.getLonLat();
        result = result * 59 + ($lonLat == null ? 43 : $lonLat.hashCode());
        LocationAddressValueType $geoAddress = this.getGeoAddress();
        result = result * 59 + ($geoAddress == null ? 43 : $geoAddress.hashCode());
        OccupationType $occupationType = this.getOccupationType();
        result = result * 59 + ($occupationType == null ? 43 : $occupationType.hashCode());
        Date $hiredDate = this.getHiredDate();
        result = result * 59 + ($hiredDate == null ? 43 : ((Object)$hiredDate).hashCode());
        String $organizationId = this.getOrganizationId();
        result = result * 59 + ($organizationId == null ? 43 : $organizationId.hashCode());
        String $tenantUserId = this.getTenantUserId();
        result = result * 59 + ($tenantUserId == null ? 43 : $tenantUserId.hashCode());
        String $tenantEmployeeId = this.getTenantEmployeeId();
        result = result * 59 + ($tenantEmployeeId == null ? 43 : $tenantEmployeeId.hashCode());
        String $superviseDepartId = this.getSuperviseDepartId();
        result = result * 59 + ($superviseDepartId == null ? 43 : $superviseDepartId.hashCode());
        String $superviseDepartName = this.getSuperviseDepartName();
        result = result * 59 + ($superviseDepartName == null ? 43 : $superviseDepartName.hashCode());
        String $deviceNumber = this.getDeviceNumber();
        result = result * 59 + ($deviceNumber == null ? 43 : $deviceNumber.hashCode());
        String $tenantImUserId = this.getTenantImUserId();
        result = result * 59 + ($tenantImUserId == null ? 43 : $tenantImUserId.hashCode());
        String $securityStationId = this.getSecurityStationId();
        result = result * 59 + ($securityStationId == null ? 43 : $securityStationId.hashCode());
        String $securityStationName = this.getSecurityStationName();
        result = result * 59 + ($securityStationName == null ? 43 : $securityStationName.hashCode());
        Set<String> $stationTypes = this.getStationTypes();
        result = result * 59 + ($stationTypes == null ? 43 : ((Object)$stationTypes).hashCode());
        Set<String> $scopePermissions = this.getScopePermissions();
        result = result * 59 + ($scopePermissions == null ? 43 : ((Object)$scopePermissions).hashCode());
        String $superviseRegionCode = this.getSuperviseRegionCode();
        result = result * 59 + ($superviseRegionCode == null ? 43 : $superviseRegionCode.hashCode());
        String $cId = this.getCId();
        result = result * 59 + ($cId == null ? 43 : $cId.hashCode());
        Set<String> $securityStationRailIds = this.getSecurityStationRailIds();
        result = result * 59 + ($securityStationRailIds == null ? 43 : ((Object)$securityStationRailIds).hashCode());
        Sex $sex = this.getSex();
        result = result * 59 + ($sex == null ? 43 : $sex.hashCode());
        Set<String> $responsibleOfStationIds = this.getResponsibleOfStationIds();
        result = result * 59 + ($responsibleOfStationIds == null ? 43 : ((Object)$responsibleOfStationIds).hashCode());
        Set<String> $resourceTypes = this.getResourceTypes();
        result = result * 59 + ($resourceTypes == null ? 43 : ((Object)$resourceTypes).hashCode());
        String $industry = this.getIndustry();
        result = result * 59 + ($industry == null ? 43 : $industry.hashCode());
        String $institutional = this.getInstitutional();
        result = result * 59 + ($institutional == null ? 43 : $institutional.hashCode());
        String $proprietorCompanyName = this.getProprietorCompanyName();
        result = result * 59 + ($proprietorCompanyName == null ? 43 : $proprietorCompanyName.hashCode());
        String $proprietorCompanyId = this.getProprietorCompanyId();
        result = result * 59 + ($proprietorCompanyId == null ? 43 : $proprietorCompanyId.hashCode());
        Timestamp $lastUpdatedTime = this.getLastUpdatedTime();
        result = result * 59 + ($lastUpdatedTime == null ? 43 : ((Object)$lastUpdatedTime).hashCode());
        Timestamp $lastDutyStatusChangedTime = this.getLastDutyStatusChangedTime();
        result = result * 59 + ($lastDutyStatusChangedTime == null ? 43 : ((Object)$lastDutyStatusChangedTime).hashCode());
        Set<String> $examSiteId = this.getExamSiteId();
        result = result * 59 + ($examSiteId == null ? 43 : ((Object)$examSiteId).hashCode());
        String $thirdParty = this.getThirdParty();
        result = result * 59 + ($thirdParty == null ? 43 : $thirdParty.hashCode());
        String $paymentOrgId = this.getPaymentOrgId();
        result = result * 59 + ($paymentOrgId == null ? 43 : $paymentOrgId.hashCode());
        return result;
    }

    public String toString() {
        return "RdEmployeeDocument(id=" + this.getId() + ", name=" + this.getName() + ", idCardNo=" + this.getIdCardNo() + ", communicatedType=" + this.getCommunicatedType() + ", yardmanType=" + this.getYardmanType() + ", headPhoto=" + this.getHeadPhoto() + ", contact=" + this.getContact() + ", companyName=" + this.getCompanyName() + ", status=" + this.getStatus() + ", checkedStatus=" + this.getCheckedStatus() + ", authenticatedStatus=" + this.getAuthenticatedStatus() + ", dutyStatus=" + this.getDutyStatus() + ", militaryStatus=" + this.getMilitaryStatus() + ", securityCertificateNo=" + this.getSecurityCertificateNo() + ", followedDeviceNos=" + this.getFollowedDeviceNos() + ", lonLat=" + this.getLonLat() + ", geoAddress=" + this.getGeoAddress() + ", occupationType=" + this.getOccupationType() + ", hiredDate=" + this.getHiredDate() + ", insure=" + this.isInsure() + ", organizationId=" + this.getOrganizationId() + ", tenantUserId=" + this.getTenantUserId() + ", tenantEmployeeId=" + this.getTenantEmployeeId() + ", superviseDepartId=" + this.getSuperviseDepartId() + ", superviseDepartName=" + this.getSuperviseDepartName() + ", deviceNumber=" + this.getDeviceNumber() + ", tenantImUserId=" + this.getTenantImUserId() + ", securityStationId=" + this.getSecurityStationId() + ", securityStationName=" + this.getSecurityStationName() + ", stationTypes=" + this.getStationTypes() + ", scopePermissions=" + this.getScopePermissions() + ", dispatchable=" + this.getDispatchable() + ", superviseRegionCode=" + this.getSuperviseRegionCode() + ", cId=" + this.getCId() + ", securityStationRailIds=" + this.getSecurityStationRailIds() + ", sex=" + this.getSex() + ", responsibleOfStationIds=" + this.getResponsibleOfStationIds() + ", domainAdmin=" + this.isDomainAdmin() + ", resourceTypes=" + this.getResourceTypes() + ", industry=" + this.getIndustry() + ", institutional=" + this.getInstitutional() + ", proprietorCompanyName=" + this.getProprietorCompanyName() + ", proprietorCompanyId=" + this.getProprietorCompanyId() + ", lastUpdatedTime=" + this.getLastUpdatedTime() + ", lastDutyStatusChangedTime=" + this.getLastDutyStatusChangedTime() + ", cLevel=" + this.getCLevel() + ", examSiteId=" + this.getExamSiteId() + ", thirdParty=" + this.getThirdParty() + ", paymentOrgId=" + this.getPaymentOrgId() + ")";
    }
}

