package com.bcxin.tenant.flink.job.jobs;

import com.bcxin.flink.core.StreamingCoreEnvironments;
import com.bcxin.tenant.flink.job.StreamingJobContext;
import com.bcxin.tenant.flink.job.definitions.JobDataDefinition;
import com.bcxin.tenant.flink.job.definitions.KafkaMetaDefinition;
import com.bcxin.tenant.flink.job.functions.Convert2PointFunction;
import com.bcxin.tenant.open.infrastructures.flinks.FlinkJobAbstract;
import org.apache.commons.collections.CollectionUtils;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.api.TableResult;
import org.apache.flink.table.api.bridge.java.StreamStatementSet;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;

public class ScriptDispatchJob extends FlinkJobAbstract {

    private final JobDataDefinition definition;

    public ScriptDispatchJob(JobDataDefinition definition) {
        this.definition = definition;
    }

    @Override
    protected void coreExecute() throws Exception {
        StreamingJobContext jobContext = StreamingJobContext.getInstance();
        StreamExecutionEnvironment env = StreamingCoreEnvironments.getStreamExecutionEnvironment(jobContext);
        env.setParallelism(5);
        StreamTableEnvironment tableEnvironment = StreamTableEnvironment.create(env);

        tableEnvironment.createTemporaryFunction("convert2Point", new Convert2PointFunction());

        KafkaMetaDefinition kafkaMetaDefinition = definition.getKafkaMeta();
        if (kafkaMetaDefinition != null && !CollectionUtils.isEmpty(kafkaMetaDefinition.getTopicDefinitions())) {
            kafkaMetaDefinition.getTopicDefinitions()
                    .forEach(td -> {
                        tableEnvironment.executeSql(td.getFullDefinitionSql(kafkaMetaDefinition));
                    });
        }

        if (definition.getJdbcMeta() != null && !CollectionUtils.isEmpty(definition.getJdbcMeta().getSqlMetaDefinitions())) {
            definition.getJdbcMeta().getSqlMetaDefinitions().forEach(sl -> {
                String fullSql = sl.getFullSql(definition.getJdbcMeta());
                tableEnvironment.executeSql(fullSql);
            });
        }

        StreamStatementSet statementSet = tableEnvironment.createStatementSet();
        definition.getExecuteSql().forEach(ix -> {
            statementSet.addInsertSql(ix);
        });

        TableResult result = statementSet.execute();
        result.print();
    }
}
