package com.bcxin.tenant.open.infrastructures.snapshoots;

import com.bcxin.tenant.open.infrastructures.enums.DispatchReasonType;
import lombok.Data;

import java.io.Serializable;
import java.util.Collection;

@Data
public class RoomDispatchSnapshoot implements Serializable {
    private Long roomId;
    private DispatchReasonType reasonType;
    private String referenceNumber;
    private Collection<String> employeeIds;

    public static RoomDispatchSnapshoot create(Long roomId, DispatchReasonType reasonType, String referenceNumber, Collection<String> employeeIds) {
        RoomDispatchSnapshoot poJo = new RoomDispatchSnapshoot();
        poJo.setReasonType(reasonType);
        poJo.setReferenceNumber(referenceNumber);
        poJo.setRoomId(roomId);
        poJo.setEmployeeIds(employeeIds);

        return poJo;
    }
}
