package com.bcxin.tenant.open.infrastructures.enums;

import lombok.Getter;

import java.util.Collection;
import java.util.HashSet;

@Getter
public enum RollCallType {
    RollCall(1 << 0, "点名"),
    Dispatch(1 << 1, "督导点名");

    String name;
    int value;
    private RollCallType(int value, String name) {
        this.name = name;
        this.value = value;
    }

    public static int calculate(Collection<RollCallType> callTypes) {
        int result = 0;
        if (callTypes != null && !callTypes.isEmpty()) {
            for (RollCallType rule : callTypes) {
                result = result | rule.value;
            }
        }

        return result;
    }

    public static Collection<RollCallType> getSelectedRollCallTypes(int rollCallType) {
        Collection<RollCallType> result = new HashSet<>();
        for (RollCallType callType : RollCallType.values()) {
            if ((callType.value & rollCallType) > 0) {
                result.add(callType);
            }
        }

        return result;
    }
}
