/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.open.domains.criterias;

import com.bcxin.tenant.open.infrastructures.criterias.CriteriaAbstract;
import com.bcxin.tenant.open.infrastructures.enums.RollCallType;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.stream.Collectors;
import org.springframework.util.CollectionUtils;

public class RollCallEmployeeGroupCriteria
extends CriteriaAbstract {
    private final Long rollCallPlanId;
    private final String stationName;
    private final Collection<String> superviseDepartIds;
    private final Collection<String> stationTypes;
    private final String actionEmployeeName;
    private final Date beginDate;
    private final Date endDate;
    private final Collection<String> organizationIds;
    private final int calculatedCallTypeValue;
    private final String actionOrganizationId;

    public RollCallEmployeeGroupCriteria(int pageIndex, int pageSize, Long rollCallPlanId, Collection<String> organizationIds, String stationName, Collection<String> superviseDepartIds, Collection<String> stationTypes, String actionEmployeeName, Date beginDate, Date endDate, Collection<RollCallType> callTypes, String actionOrganizationId) {
        super(pageIndex, pageSize);
        this.organizationIds = organizationIds;
        this.stationName = stationName;
        this.superviseDepartIds = superviseDepartIds;
        this.stationTypes = CollectionUtils.isEmpty(stationTypes) ? stationTypes : (Collection)stationTypes.stream().map(ii -> String.format("\"%s\"", ii)).collect(Collectors.toList());
        this.actionEmployeeName = actionEmployeeName;
        this.beginDate = beginDate;
        this.endDate = endDate;
        this.rollCallPlanId = rollCallPlanId;
        this.calculatedCallTypeValue = RollCallType.calculate(callTypes);
        this.actionOrganizationId = actionOrganizationId;
    }

    public static RollCallEmployeeGroupCriteria create(int pageIndex, int pageSize, Long rollCallPlanId, String[] organizationIds, String stationName, Collection<String> superviseDepartIds, Collection<String> stationTypes, String actionEmployeeName, Date beginDate, Date endDate, Collection<RollCallType> callTypes, String actionOrganizationId) {
        return new RollCallEmployeeGroupCriteria(pageIndex, pageSize, rollCallPlanId, organizationIds == null ? null : Arrays.stream(organizationIds).toList(), stationName, superviseDepartIds, stationTypes, actionEmployeeName, beginDate, endDate, callTypes, actionOrganizationId);
    }

    public Long getRollCallPlanId() {
        return this.rollCallPlanId;
    }

    public String getStationName() {
        return this.stationName;
    }

    public Collection<String> getSuperviseDepartIds() {
        return this.superviseDepartIds;
    }

    public Collection<String> getStationTypes() {
        return this.stationTypes;
    }

    public String getActionEmployeeName() {
        return this.actionEmployeeName;
    }

    public Date getBeginDate() {
        return this.beginDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public Collection<String> getOrganizationIds() {
        return this.organizationIds;
    }

    public int getCalculatedCallTypeValue() {
        return this.calculatedCallTypeValue;
    }

    public String getActionOrganizationId() {
        return this.actionOrganizationId;
    }
}

