/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.open.domains.services.impls;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.tenant.open.document.domains.documents.RdEmployeeDocument;
import com.bcxin.tenant.open.document.domains.documents.RdSecurityStationDocument;
import com.bcxin.tenant.open.document.domains.repositories.RdEmployeeDocumentRepository;
import com.bcxin.tenant.open.document.domains.repositories.RdSecurityStationDocumentRepository;
import com.bcxin.tenant.open.domains.entities.RdSecurityStationRailEntity;
import com.bcxin.tenant.open.domains.entities.RdSecurityStationRailMessageEntity;
import com.bcxin.tenant.open.domains.repositories.RdSecurityStationRailMessageRepository;
import com.bcxin.tenant.open.domains.repositories.RdSecurityStationRailRepository;
import com.bcxin.tenant.open.domains.services.RdSecurityStationRailService;
import com.bcxin.tenant.open.domains.services.commands.CheckStationRailWarningCommand;
import com.bcxin.tenant.open.domains.services.commands.CreateRdSecurityStationRailCommand;
import com.bcxin.tenant.open.domains.services.commands.DeleteRdSecurityStationRailCommand;
import com.bcxin.tenant.open.domains.services.commands.UpdateRdSecurityStationRailCommand;
import com.bcxin.tenant.open.infrastructures.TenantContext;
import com.bcxin.tenant.open.infrastructures.TenantEmployeeContext;
import com.bcxin.tenant.open.infrastructures.UnitWork;
import com.bcxin.tenant.open.infrastructures.components.IdWorker;
import com.bcxin.tenant.open.infrastructures.components.JsonProvider;
import com.bcxin.tenant.open.infrastructures.enums.DutySignInType;
import com.bcxin.tenant.open.infrastructures.enums.RailBusinessType;
import com.bcxin.tenant.open.infrastructures.enums.RailRuleType;
import com.bcxin.tenant.open.infrastructures.enums.RailShapeType;
import com.bcxin.tenant.open.infrastructures.enums.ResourceType;
import com.bcxin.tenant.open.infrastructures.exceptions.BadTenantException;
import com.bcxin.tenant.open.infrastructures.exceptions.NoAllowedTenantException;
import com.bcxin.tenant.open.infrastructures.exceptions.NoFoundTenantException;
import com.bcxin.tenant.open.infrastructures.utils.GisPointUtil;
import com.bcxin.tenant.open.infrastructures.utils.StringUtil;
import com.bcxin.tenant.open.infrastructures.valueTypes.GeoLocationValueType;
import com.bcxin.tenant.open.infrastructures.valueTypes.LonLatValueType;
import com.bcxin.tenant.open.infrastructures.valueTypes.RdSecurityStationRailSnapshootValueType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.geo.Point;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class RdSecurityStationRailServiceImpl
implements RdSecurityStationRailService {
    private static final Logger logger = LoggerFactory.getLogger(RdSecurityStationRailServiceImpl.class);
    private final UnitWork unitWork;
    private final IdWorker idWorker;
    private final JsonProvider jsonProvider;
    private final RdSecurityStationDocumentRepository securityStationDocumentRepository;
    private final RdSecurityStationRailRepository rdSecurityStationRailRepository;
    private final RdSecurityStationRailMessageRepository rdSecurityStationRailMessageRepository;
    private final RdEmployeeDocumentRepository employeeDocumentRepository;

    public RdSecurityStationRailServiceImpl(UnitWork unitWork, IdWorker idWorker, JsonProvider jsonProvider, RdSecurityStationDocumentRepository securityStationDocumentRepository, RdSecurityStationRailRepository rdSecurityStationRailRepository, RdSecurityStationRailMessageRepository rdSecurityStationRailMessageRepository, RdEmployeeDocumentRepository employeeDocumentRepository) {
        this.unitWork = unitWork;
        this.idWorker = idWorker;
        this.jsonProvider = jsonProvider;
        this.securityStationDocumentRepository = securityStationDocumentRepository;
        this.rdSecurityStationRailRepository = rdSecurityStationRailRepository;
        this.rdSecurityStationRailMessageRepository = rdSecurityStationRailMessageRepository;
        this.employeeDocumentRepository = employeeDocumentRepository;
    }

    @Override
    public long dispatch(CreateRdSecurityStationRailCommand command) {
        command.validate();
        if (StringUtil.isEmpty((String)command.getOwnerOrganizationId())) {
            throw new BadTenantException("\u7535\u5b50\u56f4\u680f\u6240\u5c5e\u9a7b\u52e4\u70b9\u7684\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String stationName = command.getStationName();
        String superviseDepartId = command.getSuperviseDepartId();
        String superviseDepartName = command.getSuperviseDepartName();
        if (!command.isFromStationManagement()) {
            RdSecurityStationDocument document = this.securityStationDocumentRepository.findById((Object)command.getStationId()).orElse(null);
            if (document == null) {
                throw new NoFoundTenantException(String.format("\u627e\u4e0d\u5230\u8be5\u9a7b\u52e4\u70b9(%s)\u4fe1\u606f", command.getStationId()));
            }
            stationName = document.getName();
            superviseDepartId = document.getSuperviseDepartId();
            superviseDepartName = document.getSuperviseDepartName();
        }
        long id = this.idWorker.getNextId();
        String tranId = this.unitWork.beginTransaction();
        try {
            TenantEmployeeContext userContext = TenantContext.getInstance().getUserContext();
            String userId = userContext.get().getEmployeeId();
            String userName = userContext.get().getName();
            String areaJson = this.getAreaJson(command.getShapeType(), command.getShapedLocation());
            RdSecurityStationRailEntity securityStationRail = RdSecurityStationRailEntity.create(id, userContext.get().getOrganizationId(), command.getName(), command.getShapeType(), areaJson, RailBusinessType.Station, command.getStationId(), stationName, command.getBeginTime(), command.getEndTime(), command.getRuleType(), userId, command.getNote(), superviseDepartId, superviseDepartName, userName, command.getOwnerOrganizationId());
            this.rdSecurityStationRailRepository.insert(securityStationRail);
            this.unitWork.commit(tranId);
        }
        catch (Exception ex) {
            this.unitWork.rollback(tranId);
            logger.error("CreateRdSecurityStationRailCommand \u53d1\u751f\u5f02\u5e38", (Throwable)ex);
            throw ex;
        }
        return id;
    }

    @Override
    public void dispatch(UpdateRdSecurityStationRailCommand command) {
        command.validate();
        RdSecurityStationRailEntity securityStationRail = (RdSecurityStationRailEntity)this.rdSecurityStationRailRepository.getById(command.getId());
        if (securityStationRail == null || securityStationRail.isDeleted()) {
            throw new NoFoundTenantException("\u627e\u4e0d\u5230\u8be5\u7535\u5b50\u56f4\u680f");
        }
        String tranId = this.unitWork.beginTransaction();
        try {
            String areaJson = this.getAreaJson(command.getShapeType(), command.getShapedLocation());
            TenantEmployeeContext userContext = TenantContext.getInstance().getUserContext();
            String userId = userContext.get().getEmployeeId();
            String userName = userContext.get().getName();
            String stationName = securityStationRail.getReferenceName();
            String superviseDepartId = securityStationRail.getSuperviseDepartId();
            String superviseDepartName = securityStationRail.getSuperviseDepartName();
            if (command.isFromStationManagement()) {
                stationName = command.getStationName();
                superviseDepartId = command.getSuperviseDepartId();
                superviseDepartName = command.getSuperviseDepartName();
            } else if (!StringUtil.isEqual((String)command.getStationId(), (String)securityStationRail.getReferenceNumber())) {
                Optional documentOptional = this.securityStationDocumentRepository.findById((Object)command.getStationId());
                if (!documentOptional.isPresent()) {
                    throw new NoFoundTenantException(String.format("\u627e\u4e0d\u5230\u8be5\u9a7b\u52e4\u70b9(%s)\u4fe1\u606f", command.getStationId()));
                }
                stationName = ((RdSecurityStationDocument)documentOptional.get()).getName();
                superviseDepartId = ((RdSecurityStationDocument)documentOptional.get()).getSuperviseDepartId();
                superviseDepartName = ((RdSecurityStationDocument)documentOptional.get()).getSuperviseDepartName();
            }
            securityStationRail.change(command.getName(), command.getShapeType(), areaJson, securityStationRail.getBusinessType(), command.getStationId(), stationName, command.getBeginTime(), command.getEndTime(), command.getRuleType(), userId, command.getNote(), superviseDepartId, superviseDepartName, userName);
            this.rdSecurityStationRailRepository.update(securityStationRail);
            this.unitWork.commit(tranId);
        }
        catch (Exception ex) {
            this.unitWork.rollback(tranId);
            throw ex;
        }
    }

    @Override
    public void dispatch(DeleteRdSecurityStationRailCommand command) {
        RdSecurityStationRailEntity securityStationRail = (RdSecurityStationRailEntity)this.rdSecurityStationRailRepository.getById(command.getId());
        if (securityStationRail == null || securityStationRail.isDeleted()) {
            throw new NoFoundTenantException("\u627e\u4e0d\u5230\u8be5\u7535\u5b50\u56f4\u680f");
        }
        TenantEmployeeContext userContext = TenantContext.getInstance().getUserContext();
        String userId = userContext.get().getEmployeeId();
        String userName = userContext.get().getName();
        if (!StringUtil.isEqual((String)securityStationRail.getOrganizationId(), (String)userContext.get().getOrganizationId())) {
            throw new NoAllowedTenantException("\u8be5\u9a7b\u52e4\u70b9\u975e\u8be5\u7ec4\u7ec7\u521b\u5efa, \u56e0\u6b64, \u65e0\u6cd5\u5220\u9664");
        }
        String tranId = this.unitWork.beginTransaction();
        try {
            securityStationRail.markAsDeleted(userId, userName);
            this.rdSecurityStationRailRepository.update(securityStationRail);
            this.unitWork.commit(tranId);
        }
        catch (Exception ex) {
            this.unitWork.rollback(tranId);
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispatch(CheckStationRailWarningCommand command) {
        block9: {
            Collection employeeIds = command.getEmployeeLocations().stream().filter(ii -> !CollectionUtils.isEmpty(ii.getEmployeeIds())).flatMap(ix -> ix.getEmployeeIds().stream()).filter(ix -> StringUtils.hasLength((String)ix)).distinct().collect(Collectors.toList());
            if (CollectionUtils.isEmpty((Collection)employeeIds)) {
                return;
            }
            List employeeDocuments = this.employeeDocumentRepository.findAllById((Iterable)employeeIds);
            if (CollectionUtils.isEmpty((Collection)employeeDocuments)) {
                return;
            }
            try {
                Collection stationIds = employeeDocuments.stream().map(ix -> ix.getSecurityStationId()).distinct().collect(Collectors.toList());
                Collection<RdSecurityStationRailEntity> stationRails = this.rdSecurityStationRailRepository.getValidRails(stationIds);
                if (CollectionUtils.isEmpty(stationRails)) {
                    logger.warn("\u672a\u627e\u5230\u5bf9\u5e94\u9a7b\u52e4({})\u7684\u7535\u5b50\u56f4\u680f\u4fe1\u606f", (Object)stationIds.stream().collect(Collectors.joining(";")));
                    return;
                }
                ArrayList<RdSecurityStationRailMessageEntity> railMessages = new ArrayList<RdSecurityStationRailMessageEntity>();
                ArrayList securityStationDocuments = new ArrayList();
                stationRails.forEach(str -> {
                    Collection validLocations;
                    RdSecurityStationRailSnapshootValueType.ShapedLocationValueType shapedLocationValueType;
                    if (!StringUtils.hasLength((String)str.getReferenceNumber()) || str.getBusinessType() != RailBusinessType.Station) {
                        return;
                    }
                    if (!StringUtil.isEmpty((String)str.getAreaJson()) && (shapedLocationValueType = (RdSecurityStationRailSnapshootValueType.ShapedLocationValueType)this.jsonProvider.toObject(RdSecurityStationRailSnapshootValueType.ShapedLocationValueType.class, str.getAreaJson())) != null && shapedLocationValueType.getGeos() != null && !CollectionUtils.isEmpty((Collection)(validLocations = (Collection)shapedLocationValueType.getGeos().stream().filter(ix -> ix != null).collect(Collectors.toList())))) {
                        command.getEmployeeLocations().forEach(eln -> {
                            Optional<RdEmployeeDocument> employeeDocumentOptional = employeeDocuments.stream().filter(ix -> eln.getEmployeeIds().stream().anyMatch(ik -> ik.equalsIgnoreCase(ix.getTenantEmployeeId()))).findFirst();
                            if (!employeeDocumentOptional.isPresent()) {
                                return;
                            }
                            RdEmployeeDocument employeeDocument = employeeDocumentOptional.get();
                            if (!StringUtils.hasLength((String)employeeDocument.getSecurityStationId()) || !employeeDocument.getSecurityStationId().equalsIgnoreCase(str.getReferenceNumber())) {
                                return;
                            }
                            boolean isMatchedWarning = false;
                            boolean addNewMessage = false;
                            switch (str.getShapeType()) {
                                case Circle: {
                                    LonLatValueType selectedLocation = (LonLatValueType)validLocations.stream().findFirst().get();
                                    boolean isInCircle = GisPointUtil.isInCircle((double)eln.getLongitude(), (double)eln.getLatitude(), (double)selectedLocation.getLon(), (double)selectedLocation.getLat(), (Double)shapedLocationValueType.getRadius());
                                    if (str.getRuleType() == RailRuleType.Exit) {
                                        if (isInCircle) break;
                                        isMatchedWarning = true;
                                        break;
                                    }
                                    if (!isInCircle) break;
                                    isMatchedWarning = true;
                                    break;
                                }
                                default: {
                                    JSONArray array = new JSONArray();
                                    for (LonLatValueType ix2 : validLocations) {
                                        JSONObject jo = new JSONObject();
                                        jo.put("x", (Object)ix2.getLon());
                                        jo.put("y", (Object)ix2.getLat());
                                        array.add((Object)jo);
                                    }
                                    boolean isInPolygon = GisPointUtil.isInPolygon((double)eln.getLongitude(), (double)eln.getLatitude(), (JSONArray)array);
                                    if (str.getRuleType() == RailRuleType.Exit) {
                                        if (isInPolygon) break;
                                        isMatchedWarning = true;
                                        break;
                                    }
                                    if (!isInPolygon) break;
                                    isMatchedWarning = true;
                                }
                            }
                            if (isMatchedWarning) {
                                if (employeeDocument.hasMatchedStationRailMessage(String.valueOf(str.getPkId()))) {
                                    logger.error("\u8be5\u7535\u5b50\u56f4\u680f\u7684\u4fe1\u606f\u5df2\u7ecf\u8bb0\u5f55\u5230\u8be5\u4eba\u5458; \u56e0\u6b64\uff1b\u6211\u4eec\u5c06\u4e0d\u8fdb\u884c\u91cd\u590d\u8bb0\u5f55");
                                    return;
                                }
                                addNewMessage = true;
                                Optional stationDocumentOptional = securityStationDocuments.stream().filter(ix -> ix.getId().equalsIgnoreCase(str.getReferenceNumber()) && str.getBusinessType() == RailBusinessType.Station).findFirst();
                                if (!stationDocumentOptional.isPresent()) {
                                    stationDocumentOptional = this.securityStationDocumentRepository.findById((Object)str.getReferenceNumber());
                                    if (stationDocumentOptional.isPresent()) {
                                        securityStationDocuments.add((RdSecurityStationDocument)stationDocumentOptional.get());
                                    } else {
                                        logger.error("\u627e\u4e0d\u5230\u8be5\u7535\u5b50\u56f4\u680f({})\u7684\u9a7b\u52e4\u70b9({})\u4fe1\u606f;", (Object)str.getPkId(), (Object)str.getReferenceNumber());
                                        return;
                                    }
                                }
                                employeeDocument.addStationRailMessage(String.valueOf(str.getPkId()));
                                this.employeeDocumentRepository.save((Object)employeeDocument);
                                RdSecurityStationDocument stationDocument = (RdSecurityStationDocument)stationDocumentOptional.get();
                                GeoLocationValueType geoLocation = GeoLocationValueType.create((double)eln.getLatitude(), (double)eln.getLongitude(), (GeoLocationValueType.AddressRequest)GeoLocationValueType.AddressRequest.create((String)eln.getCountry(), (String)eln.getProvince(), (String)eln.getCity(), (String)eln.getDistrict(), (String)eln.getStreet(), (String)eln.getStreetNum(), (String)eln.getPoiName(), (String)eln.getCityCode()));
                                RdSecurityStationRailMessageEntity messageEntity = RdSecurityStationRailMessageEntity.create(this.idWorker.getNextId(), eln.getEventTime(), employeeDocument.getId(), employeeDocument.getName(), employeeDocument.getOrganizationId(), employeeDocument.getCompanyName(), this.jsonProvider.getJson((Object)geoLocation), str.getPkId(), str.getName(), str.getRuleType(), str.getShapeType(), str.getBusinessType(), str.getAreaJson(), str.getReferenceNumber(), str.getReferenceName(), stationDocument.getAddress(), stationDocument.getSuperviseDepartId(), stationDocument.getSuperviseDepartName(), employeeDocument.getIdCardNo(), ResourceType.toResourceTypes((Set)employeeDocument.getResourceTypes()));
                                railMessages.add(messageEntity);
                            } else {
                                employeeDocument.removeFromStationRailMessage(String.valueOf(str.getPkId()));
                            }
                        });
                    }
                });
                if (CollectionUtils.isEmpty(railMessages)) break block9;
                String tranId = this.unitWork.beginTransaction();
                try {
                    this.rdSecurityStationRailMessageRepository.insertAll(railMessages);
                    this.unitWork.commit(tranId);
                }
                catch (Exception ex) {
                    this.unitWork.rollback(tranId);
                    throw ex;
                }
            }
            finally {
                this.doUpdateEmployeeLocation(command, employeeDocuments);
            }
        }
    }

    private String getAreaJson(RailShapeType railShapeType, RdSecurityStationRailSnapshootValueType.ShapedLocationValueType shapedLocationValueType) {
        if (shapedLocationValueType == null || CollectionUtils.isEmpty((Collection)shapedLocationValueType.getGeos())) {
            throw new BadTenantException("\u7535\u5b50\u56f4\u680f\u7684\u5750\u6807\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (railShapeType == RailShapeType.Circle && shapedLocationValueType.getRadius() == null) {
            throw new BadTenantException("\u56ed\u578b\u7684\u7535\u5b50\u56f4\u680f\u5fc5\u987b\u8bbe\u7f6eRadius\u534a\u5f84\u5927\u5c0f");
        }
        return this.jsonProvider.getJson((Object)shapedLocationValueType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUpdateEmployeeLocation(CheckStationRailWarningCommand command, Collection<RdEmployeeDocument> employeeDocuments) {
        if (CollectionUtils.isEmpty(employeeDocuments) || CollectionUtils.isEmpty(command.getEmployeeLocations())) {
            return;
        }
        Collection selectedStationIds = employeeDocuments.stream().filter(ii -> ii.getDutySignInEnumType() == DutySignInType.SignIn && !"#1".equalsIgnoreCase(ii.getSecurityStationId())).map(ii -> ii.getSecurityStationId()).distinct().collect(Collectors.toList());
        List securityStationDocuments = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)selectedStationIds)) {
            securityStationDocuments = this.securityStationDocumentRepository.findAllById((Iterable)selectedStationIds);
        }
        try {
            for (RdEmployeeDocument document : employeeDocuments) {
                Collection locations = command.getEmployeeLocations().stream().filter(ii -> ii.getEmployeeIds().stream().anyMatch(ik -> ik.equalsIgnoreCase(document.getId()))).collect(Collectors.toList());
                for (CheckStationRailWarningCommand.StationEmployeeLocation el : locations) {
                    Point point = new Point(el.getLongitude(), el.getLatitude());
                    try {
                        RdSecurityStationDocument matchedStationDoc;
                        if (document.getDutySignInEnumType() != DutySignInType.SignIn || document.getLastDutyStatusChangedTime() != null && el.getEventTime() != null && !document.getLastDutyStatusChangedTime().before(el.getEventTime()) || (matchedStationDoc = (RdSecurityStationDocument)securityStationDocuments.stream().filter(ii -> StringUtil.isEqual((String)ii.getId(), (String)document.getSecurityStationId())).findFirst().orElse(null)) == null) continue;
                        Point stationLonLat = matchedStationDoc.getLonLat();
                        double longitude = stationLonLat.getX();
                        double latitude = stationLonLat.getY();
                        if (stationLonLat == null) continue;
                        double distance = GisPointUtil.getDistance((double)el.getLatitude(), (double)el.getLongitude(), (double)latitude, (double)longitude);
                        if (distance >= matchedStationDoc.getPerformRange() + 500.0) {
                            document.makeDispatchable(false, String.format("\u7531\u4e8e\u8de8\u51fa\u9a7b\u52e4\u8303\u56f4(\u8ddd\u79bb=%s), \u6240\u4ee5\u8bbe\u7f6e\u4e3a\u79bb\u5c97\u72b6\u6001(\u975e\u7b7e\u9000\u64cd\u4f5c)", distance));
                            continue;
                        }
                        document.makeDispatchable(true, String.format("\u56de\u5230\u9a7b\u52e4\u7684\u8303\u56f4(\u8ddd\u79bb=%s)\u5185", distance));
                    }
                    finally {
                        document.changeLonLat(point);
                    }
                }
            }
        }
        finally {
            this.employeeDocumentRepository.saveAll(employeeDocuments);
        }
    }
}

