/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.open.jdks.responses;

import com.bcxin.tenant.open.infrastructures.ResponseAbstract;
import com.bcxin.tenant.open.infrastructures.enums.DeviceStatus;
import com.bcxin.tenant.open.infrastructures.enums.DeviceType;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.v3.oas.annotations.media.Schema;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;

@Schema(name="DeviceResponse", title="DeviceDetailResponse \u667a\u80fd\u7ec8\u7aef\u8be6\u7ec6\u4fe1\u606f")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class DeviceResponse
extends ResponseAbstract {
    private final String id;
    @Schema(name="deviceType", title="\u8bbe\u5907\u7c7b\u578b;\u6b64\u503c\u4ec5\u5728\u8be6\u60c5\u53ca\u6846\u9009\u4e2d\u8fd4\u56de")
    private final String deviceType;
    @Schema(name="dispatchUid", title="IMEI\u53f7\u5bf9\u5e94\u7684uid")
    private final String dispatchUid;
    @Schema(name="dispatchNo", title="IMEI\u53f7; \u5bf9\u8bb2\u8d26\u53f7;\u6b64\u503c\u4ec5\u5728\u8be6\u60c5\u53ca\u6846\u9009\u4e2d\u8fd4\u56de")
    private final String dispatchNo;
    @Schema(name="deviceModel", title="\u8bbe\u5907\u578b\u53f7;\u6b64\u503c\u4ec5\u5728\u8be6\u60c5\u53ca\u6846\u9009\u4e2d\u8fd4\u56de")
    private final String deviceModel;
    @Schema(name="organizationId", title="\u7ec4\u7ec7Id;\u6b64\u503c\u4ec5\u5728\u8be6\u60c5\u53ca\u6846\u9009\u4e2d\u8fd4\u56de")
    private final String organizationId;
    @Schema(name="organizationName", title="\u7ec4\u7ec7\u540d;\u6b64\u503c\u4ec5\u5728\u8be6\u60c5\u53ca\u6846\u9009\u4e2d\u8fd4\u56de")
    private final String organizationName;
    @Schema(name="securityStationId", title="\u9a7b\u52e4\u70b9Id;\u6b64\u503c\u4ec5\u5728\u8be6\u60c5\u53ca\u6846\u9009\u4e2d\u8fd4\u56de")
    private final String securityStationId;
    @Schema(name="securityStationName", title="\u9a7b\u52e4\u70b9\u540d\u79f0;\u6b64\u503c\u4ec5\u5728\u8be6\u60c5\u53ca\u6846\u9009\u4e2d\u8fd4\u56de")
    private final String securityStationName;
    @Schema(name="status", title="\u8bbe\u5907\u72b6\u6001:Online\uff1d\u5728\u7ebf\uff1bOffline\uff1d\u79bb\u7ebf")
    private final DeviceStatus status;
    @Schema(name="latitude", title="\u4fdd\u5b89\u5458\u6240\u5728y\u8f74\u5750\u6807")
    private final Double latitude;
    @Schema(name="longitude", title="\u4fdd\u5b89\u5458\u6240\u5728x\u8f74\u5750\u6807")
    private final Double longitude;
    @Schema(name="lastSyncTime", title="\u6700\u540e\u540c\u6b65\u65f6\u95f4")
    private final String lastSyncTime;

    @Schema(name="statusText", title="\u8bbe\u5907\u72b6\u6001:Online\uff1d\u5728\u7ebf\uff1bOffline\uff1d\u79bb\u7ebf")
    public String getStatusText() {
        if (this.getStatus() == null) {
            return "\u79bb\u7ebf";
        }
        return this.getStatus() == DeviceStatus.Online ? "\u5728\u7ebf" : "\u79bb\u7ebf";
    }

    public DeviceResponse(String id, String dispatchUid, String dispatchNo, String deviceModel, String organizationId, String organizationName, String securityStationId, String securityStationName, DeviceType deviceType, Double latitude, Double longitude, DeviceStatus status, Timestamp lastSyncTime) {
        this.id = id;
        this.dispatchUid = dispatchUid;
        this.dispatchNo = dispatchNo;
        this.deviceModel = deviceModel;
        this.organizationId = organizationId;
        this.organizationName = organizationName;
        this.securityStationId = securityStationId;
        this.securityStationName = securityStationName;
        this.deviceType = deviceType == null ? null : deviceType.getName();
        this.latitude = latitude;
        this.longitude = longitude;
        this.status = status;
        if (lastSyncTime != null) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
            this.lastSyncTime = dateFormat.format(lastSyncTime);
        } else {
            this.lastSyncTime = null;
        }
    }

    public static DeviceResponse create(String id, String dispatchUid, String dispatchNo, String deviceModel, String organizationId, String organizationName, String securityStationId, String securityStationName, DeviceType deviceType, Double latitude, Double longitude, DeviceStatus status, Timestamp lastSyncTime) {
        return new DeviceResponse(id, dispatchUid, dispatchNo, deviceModel, organizationId, organizationName, securityStationId, securityStationName, deviceType, latitude, longitude, status, lastSyncTime);
    }

    public static DeviceResponse createForSecurityResource(String id, Double latitude, Double longitude, DeviceStatus status) {
        return new DeviceResponse(id, null, null, null, null, null, null, null, null, latitude, longitude, status, null);
    }

    public String getId() {
        return this.id;
    }

    public String getDeviceType() {
        return this.deviceType;
    }

    public String getDispatchUid() {
        return this.dispatchUid;
    }

    public String getDispatchNo() {
        return this.dispatchNo;
    }

    public String getDeviceModel() {
        return this.deviceModel;
    }

    public String getOrganizationId() {
        return this.organizationId;
    }

    public String getOrganizationName() {
        return this.organizationName;
    }

    public String getSecurityStationId() {
        return this.securityStationId;
    }

    public String getSecurityStationName() {
        return this.securityStationName;
    }

    public DeviceStatus getStatus() {
        return this.status;
    }

    public Double getLatitude() {
        return this.latitude;
    }

    public Double getLongitude() {
        return this.longitude;
    }

    public String getLastSyncTime() {
        return this.lastSyncTime;
    }
}

