/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.backend.domain.signature.service.impls;

import cn.hutool.core.codec.Base64;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.lang.UUID;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.backend.core.exceptions.SaasNofoundException;
import com.bcxin.backend.domain.configs.FileModeOutConfig;
import com.bcxin.backend.domain.enums.ComparisonDocumentType;
import com.bcxin.backend.domain.enums.DocumentType;
import com.bcxin.backend.domain.enums.ResetDocumentType;
import com.bcxin.backend.domain.models.SignatureQueuesDocument;
import com.bcxin.backend.domain.repositories.SignatureQueuesDocumentRepository;
import com.bcxin.backend.domain.signature.service.BeiJingInDocumentSignature;
import com.bcxin.backend.domain.utils.ftp.FtpUtil;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.rendering.ImageType;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.PageRequest;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Service;

@Service
@Deprecated
public class BeiJingInDocumentSignatureServiceImpl
implements BeiJingInDocumentSignature {
    private static final Logger log = LoggerFactory.getLogger(BeiJingInDocumentSignatureServiceImpl.class);
    private final SignatureQueuesDocumentRepository signatureQueuesDocumentRepository;
    @Value(value="${myapps.domain.url}")
    String urlHead;
    @Value(value="${myapps.signature.unSignaturePDF}")
    String unSignatureSignatureToPDFServiceImplPDF;
    @Value(value="${myapps.signature.signaturePDF}")
    String signaturePDF;
    @Value(value="${myapps.signature.tempPDF}")
    String tempPDF;
    @Value(value="${myapps.signature.cgiApi}")
    String cgiApi;
    @Value(value="${myapps.storage.root}")
    String rootPath;
    @Autowired
    @Qualifier(value="primaryJdbcTemplate")
    protected JdbcTemplate jdbcTemplate;
    private static final String DOCUMENTPATH = "/document";
    private static final int MIN_SEAL_PIXELS = 2500;

    public BeiJingInDocumentSignatureServiceImpl(SignatureQueuesDocumentRepository signatureQueuesDocumentRepository) {
        this.signatureQueuesDocumentRepository = signatureQueuesDocumentRepository;
    }

    @Override
    public void initDocumentSignature() {
        try {
            this.createDocumentSignature_old();
        }
        catch (Exception e) {
            log.error("========> initDocumentSignature.error", (Throwable)e);
        }
    }

    @Override
    public void useDocumentSignature() {
        this.updateDocumentSignature_old();
    }

    private void createDocumentSignature_old() {
        DocumentType[] list;
        for (DocumentType documentType : list = DocumentType.values()) {
            if (StringUtils.isEmpty((CharSequence)documentType.getSelectSql())) continue;
            List paranms = this.jdbcTemplate.query(documentType.getSelectSql(), (RowMapper)new RowMapper<DocumentFile>(){

                public DocumentFile mapRow(ResultSet rs, int rowNum) throws SQLException {
                    DocumentFile row = new DocumentFile();
                    row.setBusiness_id(rs.getString("business_id"));
                    row.setPath(rs.getString("path"));
                    return row;
                }
            });
            log.error("========> createDocumentSignature_old.paranms:", (Object)paranms);
            for (DocumentFile documentFile : paranms) {
                try {
                    String businessId = documentFile.getBusiness_id();
                    String path = BeiJingInDocumentSignatureServiceImpl.getPath(documentFile.getPath());
                    if (StringUtils.isEmpty((CharSequence)path)) continue;
                    log.info("========> createDocumentSignature.path: {}; businessId={}; type={}", new Object[]{path, businessId, documentType.getValue()});
                    SignatureQueuesDocument document = this.signatureQueuesDocumentRepository.getSignatureQueuesDocument(businessId, documentType.getValue() + "");
                    if (document == null) {
                        document = new SignatureQueuesDocument();
                        document.setCreated(new Date());
                        document.setLastmodified(new Date());
                        document.setStatus(0);
                        document.setStamp_xy(documentType.getStampXy());
                        document.setBusiness_name(documentType.getName());
                        document.setBusiness_id(businessId);
                        document.setBusiness_type(documentType.getValue() + "");
                        document.setFile_url(path);
                        this.signatureQueuesDocumentRepository.save(document);
                        log.error("========> createDocumentSignature.save:{}", (Object)JSONObject.toJSONString((Object)document));
                        continue;
                    }
                    if (document.getFile_url().contains(path)) continue;
                    this.signatureQueuesDocumentRepository.resetDocumentPath(0, new Date(), path, "\u5e9f\u6b62", document.getId());
                }
                catch (Exception ex) {
                    log.error("createDocumentSignature_old \u5904\u7406\u7b7e\u7ae0\u4e8b\u9879; businessId={};path={}", new Object[]{documentFile.getBusiness_id(), documentFile.getPath(), ex});
                }
            }
        }
    }

    @Override
    public void comparisonDocumentSignature() {
        ComparisonDocumentType[] list = ComparisonDocumentType.values();
        log.error("====> \u5317\u4eac\u5185\u7f51\u68c0\u7d22\u6240\u6709\u9057\u6f0f\u7684\u6587\u4e66\u8bb0\u5f55\u91cd\u65b0\u8865\u5f55\u5230\u6587\u4e66\u7b7e\u7ae0\u8868\uff1a\u6bcf\u5c0f\u65f6\u4e00\u6b21,ComparisonDocumentTypeSize:" + list.length + "................");
        for (ComparisonDocumentType documentType : list) {
            if (StringUtils.isEmpty((CharSequence)documentType.getSelectSql())) continue;
            List paranms = this.jdbcTemplate.query(documentType.getSelectSql(), (RowMapper)new RowMapper<DocumentFile>(){

                public DocumentFile mapRow(ResultSet rs, int rowNum) throws SQLException {
                    DocumentFile row = new DocumentFile();
                    row.setBusiness_id(rs.getString("business_id"));
                    row.setPath(rs.getString("path"));
                    return row;
                }
            });
            if (paranms.size() > 0) {
                log.error("========> comparisonDocumentSignature.SelectSql:", (Object)documentType.getSelectSql());
                log.error("========> comparisonDocumentSignature.params:", (Object)JSONArray.toJSONString((Object)paranms));
            }
            for (DocumentFile documentFile : paranms) {
                try {
                    String businessId = documentFile.getBusiness_id();
                    String path = BeiJingInDocumentSignatureServiceImpl.getPath(documentFile.getPath());
                    if (StringUtils.isEmpty((CharSequence)path)) continue;
                    log.error("========> comparisonDocumentSignature.path: {}; businessId={}; type={}", new Object[]{path, businessId, documentType.getName()});
                    SignatureQueuesDocument document = this.signatureQueuesDocumentRepository.getSignatureQueuesDocument(businessId, documentType.getValue() + "");
                    if (document == null) {
                        document = new SignatureQueuesDocument();
                        document.setCreated(new Date());
                        document.setLastmodified(new Date());
                        document.setStatus(0);
                        document.setStamp_xy(documentType.getStampXy());
                        document.setBusiness_name(documentType.getName());
                        document.setBusiness_id(businessId);
                        document.setBusiness_type(documentType.getValue() + "");
                        document.setFile_url(path);
                        this.signatureQueuesDocumentRepository.save(document);
                        log.error("========> comparisonDocumentSignature.save:{}", (Object)JSONObject.toJSONString((Object)document));
                        continue;
                    }
                    if (document.getFile_url().contains(path)) continue;
                    this.signatureQueuesDocumentRepository.resetDocumentPath(0, new Date(), path, "\u5e9f\u6b62", document.getId());
                }
                catch (Exception ex) {
                    log.error("comparisonDocumentSignature \u5904\u7406\u7b7e\u7ae0\u4e8b\u9879; businessId={};path={}", new Object[]{documentFile.getBusiness_id(), documentFile.getPath(), ex});
                }
            }
        }
    }

    private static String getPath(String path) {
        if (StringUtils.isEmpty((CharSequence)path)) {
            return "";
        }
        try {
            JSONArray array = JSONArray.parseArray((String)path);
            return array.stream().map(ii -> ((JSONObject)ii).getString("path")).filter(ii -> !StringUtils.isEmpty((CharSequence)ii)).findFirst().orElse(null);
        }
        catch (Exception ex) {
            log.error("\u65e0\u6548\u7684\u6587\u4e66\u5730\u5740\u6570\u636e:path={}", (Object)path);
            return "";
        }
    }

    @Override
    public void resetDocumentSignature() {
        ResetDocumentType[] list;
        for (ResetDocumentType documentType : list = ResetDocumentType.values()) {
            if (StringUtils.isEmpty((CharSequence)documentType.getSelectSql())) continue;
            List paranms = this.jdbcTemplate.query(documentType.getSelectSql(), (RowMapper)new RowMapper<DocumentFile>(){

                public DocumentFile mapRow(ResultSet rs, int rowNum) throws SQLException {
                    DocumentFile row = new DocumentFile();
                    row.setBusiness_id(rs.getString("business_id"));
                    row.setPath(rs.getString("path"));
                    return row;
                }
            });
            log.error("========> resetDocumentSignature.paranms:{}", (Object)JSONObject.toJSONString((Object)paranms));
            for (DocumentFile documentFile : paranms) {
                try {
                    log.error("========> resetDocumentSignature.documentFile: {}", (Object)JSONObject.toJSONString((Object)documentFile));
                    String businessId = documentFile.getBusiness_id();
                    String path = BeiJingInDocumentSignatureServiceImpl.getPath(documentFile.getPath());
                    if (StringUtils.isEmpty((CharSequence)path)) continue;
                    log.error("resetDocumentSignature.path={};businessId={};type={}", new Object[]{path, businessId, documentType.getValue()});
                    SignatureQueuesDocument document = this.signatureQueuesDocumentRepository.getSignatureQueuesDocument(businessId, documentType.getValue() + "");
                    if (document == null || document.getFile_url().contains(path)) continue;
                    this.signatureQueuesDocumentRepository.resetDocumentPath(0, new Date(), path, "\u5e9f\u6b62", document.getId());
                }
                catch (Exception ex) {
                    log.error("\u5f02\u5e38\u5904\u7406-resetDocumentSignature\uff1abusinessId={}; path={}", new Object[]{documentFile.getBusiness_id(), documentFile.getPath(), ex});
                }
            }
        }
    }

    private void repairFileNull() {
        List<SignatureQueuesDocument> queues = this.signatureQueuesDocumentRepository.queuesFileNull();
        for (SignatureQueuesDocument queuesDocument : queues) {
            try {
                DocumentType type = DocumentType.getByValue(Integer.parseInt(queuesDocument.getBusiness_type()));
                String sql = "SELECT " + type.getFileField() + " AS 'fileUrl' FROM " + type.getTableName() + " WHERE ID='" + queuesDocument.getBusiness_id() + "';";
                List paranms = this.jdbcTemplate.query(sql, (RowMapper)new RowMapper<String>(){

                    public String mapRow(ResultSet rs, int rowNum) throws SQLException {
                        return rs.getString("fileUrl");
                    }
                });
                if (paranms.size() <= 0) continue;
                String fileUrl = (String)paranms.get(0);
                if (StringUtils.isEmpty((CharSequence)fileUrl) || "null".equals(fileUrl)) {
                    throw new Exception("\u539f\u6570\u636e\u6587\u4ef6\u5f02\u5e38");
                }
                this.signatureQueuesDocumentRepository.resetDocumentPath(0, new Date(), fileUrl, "", queuesDocument.getId());
            }
            catch (Exception e) {
                System.err.println("========> createDocumentSignature.repairFileNull.error: " + e.getMessage());
            }
        }
    }

    private boolean documentQuicklyServer(SignatureQueuesDocument document) {
        String stamp_xy = document.getStamp_xy();
        String filePath = document.getFile_url();
        String p = this.rootPath + filePath;
        Path path = Paths.get(p, new String[0]);
        String filename = String.format("%s_%s", document.getId(), path.getFileName().toString());
        String documentIn = this.tempPDF.replace("temp", "in") + DOCUMENTPATH;
        String inFile = this.rootPath + documentIn + "/" + filename;
        Path sourcePath = Paths.get(p, new String[0]);
        Path sourceInPath = Paths.get(inFile, new String[0]);
        try {
            Files.copy(sourcePath, sourceInPath, StandardCopyOption.REPLACE_EXISTING);
            log.error("\u590d\u5236\u6587\u4ef6sourcePath={}; sourceInPath={}", (Object)sourcePath, (Object)sourceInPath);
        }
        catch (IOException e) {
            log.error("\u5f02\u5e38-\u590d\u5236\u6587\u4ef6(SignatureQueuesDocument.Id={})sourcePath={}; sourceInPath={}", new Object[]{document.getId(), sourcePath, sourceInPath, e});
            throw new SaasNofoundException("\u627e\u4e0d\u5230\u539f\u6587\u4ef6");
        }
        String documentOut = this.tempPDF.replace("temp", "out") + DOCUMENTPATH;
        String outFile = this.rootPath + documentOut + "/" + filename;
        boolean boo = this.activateXMPDocumentQuicklyExCGI(stamp_xy);
        log.error("\u6267\u884cactivateXMPDocumentQuicklyExCGI\u7684\u7ed3\u679c: boo={}", (Object)boo);
        try {
            Files.delete(sourceInPath);
        }
        catch (IOException e) {
            log.error("\u5220\u9664(SignatureQueuesDocument.Id={})sourceInPath={} \u53d1\u751f\u5f02\u5e38", new Object[]{document.getId(), sourceInPath, e});
        }
        if (!boo) {
            return boo;
        }
        Path sourceOutPath = Paths.get(outFile, new String[0]);
        try {
            Files.copy(sourceOutPath, sourcePath, StandardCopyOption.REPLACE_EXISTING);
            log.error("\u590d\u5236\u7b7e\u7ae0\u6210\u529f\u540e\u7684\u6587\u4ef6: sourceOutPath = {}, sourceInPath={}; sourcePath={}", new Object[]{sourceOutPath, sourceInPath, sourcePath});
        }
        catch (IOException e) {
            log.error("\u5f02\u5e38: \u590d\u5236documentQuicklyServer(SignatureQueuesDocument.Id={})\u7b7e\u7ae0\u6210\u529f\u540e\u7684\u6587\u4ef6(exists={}): sourceOutPath = {}, sourceInPath={}; sourcePath={}", new Object[]{document.getId(), Files.exists(sourceOutPath, new LinkOption[0]), sourceOutPath, sourceInPath, sourcePath, e});
        }
        try {
            Files.delete(sourceOutPath);
        }
        catch (IOException e) {
            log.error("\u5f02\u5e38: \u5220\u9664 (SignatureQueuesDocument.Id={})sourceOutPath={} \u5f02\u5e38", new Object[]{document.getId(), sourceOutPath, e});
        }
        return boo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean activateXMPDocumentQuicklyExCGI(String stamp_xy) {
        StringBuilder sb = new StringBuilder();
        try {
            String[] arrXY = stamp_xy.split(",");
            JSONObject json = new JSONObject();
            json.put("service", (Object)"wss://127.0.0.1:8800");
            json.put("sn", (Object)"2171101001014060");
            json.put("pin", (Object)"88888888");
            json.put("in", (Object)"/data/share/in/document");
            json.put("out", (Object)"/data/share/out/document");
            JSONArray arr = new JSONArray();
            JSONObject pos = new JSONObject();
            pos.put("centerX", (Object)Integer.parseInt(arrXY[1]));
            pos.put("centerY", (Object)Integer.parseInt(arrXY[2]));
            pos.put("page", (Object)Integer.parseInt(arrXY[0]));
            arr.add((Object)pos);
            json.put("signOnPos", (Object)arr);
            String ret = HttpUtil.post((String)this.cgiApi, (String)json.toJSONString());
            sb.append(String.format("result=%s", ret));
            if (StringUtils.isEmpty((CharSequence)ret)) {
                boolean bl = false;
                return bl;
            }
            JSONObject result = JSON.parseObject((String)ret.replace("#", ""));
            if ("1".equals(String.valueOf(result.get((Object)"code")))) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            log.error("\u6267\u884c activateXMPDocumentQuicklyExCGI: {} \u53d1\u751f\u5f02\u5e38", (Object)stamp_xy, (Object)e);
        }
        finally {
            log.error("\u6267\u884c activateXMPDocumentQuicklyExCGI\u8ddf\u8e2a\u4fe1\u606f:{}", (Object)sb);
        }
        return false;
    }

    private void updateDocumentSignature_old() {
        List list = this.signatureQueuesDocumentRepository.pageQueues(0, PageRequest.of((int)0, (int)80)).getContent();
        for (SignatureQueuesDocument document : list) {
            try {
                boolean boo = this.documentQuicklyServer(document);
                if (boo) {
                    boolean hasRedSeal = this.checkPdfForRedSeal(document.getFile_url());
                    if (!hasRedSeal) {
                        log.warn("\u6587\u4ef6 {} \u4e2d\u672a\u68c0\u6d4b\u5230\u7ea2\u8272\u5370\u7ae0", (Object)document.getFile_url());
                        this.signatureQueuesDocumentRepository.updateSignatureQueuesDocument(0, new Date(), "\u6587\u4e66\u672a\u68c0\u6d4b\u5230\u5370\u7ae0\uff1a\u91cd\u7f6e\u72b6\u6001", document.getId());
                        continue;
                    }
                    this.signatureQueuesDocumentRepository.updateSignatureQueuesDocument(1, new Date(), "\u6587\u4e66\u7b7e\u7ae0\u6210\u529f", "\u5e9f\u6b62", document.getId());
                    continue;
                }
                this.signatureQueuesDocumentRepository.updateSignatureQueuesDocument(2, new Date(), "\u6587\u4e66\u7b7e\u7ae0\u5931\u8d25", document.getId());
            }
            catch (SaasNofoundException ex) {
                this.signatureQueuesDocumentRepository.updateSignatureQueuesDocument(2, new Date(), "404-" + ex.getMessage(), document.getId());
                log.error("updateDocumentSignature_old: 404 document.id={}; status={}, fileUrl={}", new Object[]{document.getId(), document.getStatus(), document.getFile_url(), ex});
            }
            catch (Exception ex) {
                this.signatureQueuesDocumentRepository.updateSignatureQueuesDocument(2, new Date(), "\u6587\u4e66\u7b7e\u7ae0\u5931\u8d25:" + ex.getMessage(), document.getId());
                log.error("updateDocumentSignature_old: document.id={}; status={}, fileUrl={}", new Object[]{document.getId(), document.getStatus(), document.getFile_url(), ex});
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean checkPdfForRedSeal(String filePath) {
        try {
            Path pdfPath = Paths.get(this.rootPath + filePath, new String[0]);
            File file = pdfPath.toFile();
            if (!file.exists()) {
                log.error("\u6587\u4ef6\u4e0d\u5b58\u5728: {}", (Object)filePath);
                return false;
            }
            try (PDDocument document = PDDocument.load((File)file);){
                PDFRenderer pdfRenderer = new PDFRenderer(document);
                BufferedImage image = pdfRenderer.renderImageWithDPI(0, 300.0f, ImageType.RGB);
                int width = image.getWidth();
                int height = image.getHeight();
                boolean[][] visited = new boolean[height][width];
                int minSealDetected = 0;
                int y = 0;
                while (true) {
                    if (y < height) {
                    } else {
                        boolean bl = minSealDetected > 0;
                        return bl;
                    }
                    for (int x = 0; x < width; ++x) {
                        int areaSize;
                        if (visited[y][x]) continue;
                        int rgb = image.getRGB(x, y);
                        int r = rgb >> 16 & 0xFF;
                        int g = rgb >> 8 & 0xFF;
                        int b = rgb & 0xFF;
                        if (r <= 150 || g >= 100 || b >= 100 || (areaSize = BeiJingInDocumentSignatureServiceImpl.floodFill(image, x, y, visited, width, height)) <= 2500) continue;
                        log.info("\u53d1\u73b0\u7591\u4f3c\u7ea2\u8272\u5370\u7ae0\uff0c\u9762\u79ef\uff1a{}", (Object)areaSize);
                        ++minSealDetected;
                    }
                    ++y;
                }
            }
            catch (IOException e) {
                log.error("\u8bfb\u53d6PDF\u6587\u4ef6\u5931\u8d25: {}", (Object)filePath, (Object)e);
                return false;
            }
        }
        catch (Exception ex) {
            log.error("checkPdfForRedSeal: \u6267\u884c\u5931\u8d25:filePath={}", (Object)filePath, (Object)ex);
        }
        return false;
    }

    private static int floodFill(BufferedImage image, int startX, int startY, boolean[][] visited, int width, int height) {
        int count = 0;
        LinkedList<int[]> queue = new LinkedList<int[]>();
        queue.add(new int[]{startX, startY});
        visited[startY][startX] = true;
        while (!queue.isEmpty()) {
            int[] point = (int[])queue.poll();
            int x = point[0];
            int y = point[1];
            ++count;
            for (int dx = -1; dx <= 1; ++dx) {
                for (int dy = -1; dy <= 1; ++dy) {
                    if (dx == 0 && dy == 0) continue;
                    int nx = x + dx;
                    int ny = y + dy;
                    if (nx < 0 || nx >= width || ny < 0 || ny >= height || visited[ny][nx]) continue;
                    int rgb = image.getRGB(nx, ny);
                    int r = rgb >> 16 & 0xFF;
                    int g = rgb >> 8 & 0xFF;
                    int b = rgb & 0xFF;
                    if (r <= 150 || g >= 100 || b >= 100) continue;
                    visited[ny][nx] = true;
                    queue.add(new int[]{nx, ny});
                }
            }
        }
        return count;
    }

    public static void main(String[] args) {
        System.out.println(BeiJingInDocumentSignatureServiceImpl.checkPdfForPortraitInTopLeft("\\Users\\Administrator\\Downloads\\C610700queueId_5150.pdf"));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean checkPdfForPortraitInTopLeft(String filePath) {
        try {
            Path pdfPath = Paths.get("C:" + filePath, new String[0]);
            File file = pdfPath.toFile();
            if (!file.exists()) {
                log.error("\u6587\u4ef6\u4e0d\u5b58\u5728: {}", (Object)filePath);
                return false;
            }
            try (PDDocument document = PDDocument.load((File)file);){
                boolean hasPortrait;
                PDFRenderer renderer = new PDFRenderer(document);
                BufferedImage image = renderer.renderImageWithDPI(0, 96.0f, ImageType.RGB);
                int width = image.getWidth();
                int height = image.getHeight();
                int roiX = 122;
                int roiY = 69;
                int roiWidth = 109;
                int roiHeight = 140;
                int skinPixelCount = 0;
                int totalPixelCount = roiWidth * roiHeight;
                for (int y = roiY; y < roiY + roiHeight; ++y) {
                    for (int x = roiX; x < roiX + roiWidth; ++x) {
                        if (!BeiJingInDocumentSignatureServiceImpl.isEnhancedSkinColor(image, x, y, width, height)) continue;
                        ++skinPixelCount;
                    }
                }
                double skinRatio = (double)skinPixelCount / (double)totalPixelCount;
                boolean bl = hasPortrait = skinRatio > 0.35;
                if (hasPortrait) {
                    log.info("\u5728\u5de6\u4e0a\u89d2\u53d1\u73b0\u7591\u4f3c\u5934\u50cf\uff0c\u80a4\u8272\u5360\u6bd4\uff1a{:.2f}%", (Object)(skinRatio * 100.0));
                }
                boolean bl2 = hasPortrait;
                return bl2;
            }
            catch (IOException e) {
                log.error("\u8bfb\u53d6PDF\u6587\u4ef6\u5931\u8d25: {}", (Object)filePath, (Object)e);
                return false;
            }
        }
        catch (Exception ex) {
            log.error("checkPdfForPortraitInTopRight \u6267\u884c\u5931\u8d25: filePath={}", (Object)filePath, (Object)ex);
        }
        return false;
    }

    private static boolean isEnhancedSkinColor(BufferedImage image, int x, int y, int width, int height) {
        int voteCount = 0;
        int total = 0;
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dy = -1; dy <= 1; ++dy) {
                int b;
                int g;
                int nx = x + dx;
                int ny = y + dy;
                if (nx < 0 || nx >= width || ny < 0 || ny >= height) continue;
                int rgb = image.getRGB(nx, ny);
                int r = rgb >> 16 & 0xFF;
                if (BeiJingInDocumentSignatureServiceImpl.isSkinColorInYCbCr(r, g = rgb >> 8 & 0xFF, b = rgb & 0xFF)) {
                    ++voteCount;
                }
                ++total;
            }
        }
        return voteCount * 2 >= total;
    }

    private static boolean isSkinColorInYCbCr(int r, int g, int b) {
        double Y = 0.299 * (double)r + 0.587 * (double)g + 0.114 * (double)b;
        double Cb = -0.1687 * (double)r - 0.3313 * (double)g + 0.5 * (double)b + 128.0;
        double Cr = 0.5 * (double)r - 0.4187 * (double)g - 0.0813 * (double)b + 128.0;
        return Cb >= 77.0 && Cb <= 127.0 && Cr >= 133.0 && Cr <= 173.0;
    }

    private void createDocumentSignature() {
        DocumentType[] list;
        String ftpIn = FileModeOutConfig.getFilePath();
        for (DocumentType documentType : list = DocumentType.values()) {
            if (StringUtils.isEmpty((CharSequence)documentType.getSelectSql())) continue;
            System.err.println("========> documentType.getSelectSql(): " + documentType.getSelectSql());
            List paranms = new ArrayList();
            try {
                paranms = this.jdbcTemplate.query(documentType.getSelectSql(), (RowMapper)BeanPropertyRowMapper.newInstance(Map.class));
            }
            catch (Exception e) {
                System.err.println("========> createDocumentSignature.jdbcTemplate.query: " + e.getMessage());
            }
            for (Map map : paranms) {
                SignatureQueuesDocument document;
                String fileName;
                boolean boo;
                System.err.println("========> createDocumentSignature: " + map.toString());
                String businessId = (String)map.get("business_id");
                if (map.get("path") == null) continue;
                String path = (String)map.get("path");
                if (path.startsWith("[")) {
                    path = path.replace("[", "").replace("]", "");
                    JSONObject json = JSONObject.parseObject((String)path);
                    path = json.getString("path");
                }
                if (StringUtils.isEmpty((CharSequence)path) || !(boo = FtpUtil.uploadBase64(ftpIn, fileName = BeiJingInDocumentSignatureServiceImpl.fileUUIDName(path), BeiJingInDocumentSignatureServiceImpl.fileToBase64(this.rootPath + path))) || (document = this.signatureQueuesDocumentRepository.getSignatureQueuesDocument(businessId, documentType.getValue() + "")) != null) continue;
                document = new SignatureQueuesDocument();
                document.setCreated(new Date());
                document.setLastmodified(new Date());
                document.setStatus(0);
                document.setStamp_xy(documentType.getStampXy());
                document.setBusiness_name(documentType.getName());
                document.setBusiness_id(businessId);
                document.setBusiness_type(documentType.getValue() + "");
                document.setFile_url(path + "|" + fileName);
                this.signatureQueuesDocumentRepository.save(document);
                String documentContent = JSONObject.toJSONString((Object)document);
                System.err.println("========> createDocumentSignature.document: " + documentContent);
                FtpUtil.uploadBase64(ftpIn, "IN|" + document.getBusiness_type() + "|" + businessId + ".bcx", documentContent);
                System.err.println("========> createDocumentSignature.businessId: " + businessId + "\uff0cend----");
            }
        }
    }

    public static String fileUUIDName(String filePath) {
        Path path = Paths.get(filePath, new String[0]);
        String fileName = path.getFileName().toString();
        int lastDotIndex = fileName.lastIndexOf(46);
        if (lastDotIndex > 0 && lastDotIndex < fileName.length() - 1) {
            String fileExtension = UUID.randomUUID().toString() + "." + fileName.substring(lastDotIndex + 1);
            System.out.println("File UUID name: " + fileExtension);
            return fileExtension;
        }
        return "";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String fileToBase64(String filePath) {
        File file = new File(filePath);
        try (FileInputStream fis = new FileInputStream(file);){
            byte[] bytes = IoUtil.readBytes((InputStream)fis);
            String string = Base64.encode((byte[])bytes);
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String copyFile(String originalFilePath, String rootPath) {
        try {
            Path sourcePath = Paths.get(rootPath + originalFilePath, new String[0]);
            String fileName = sourcePath.getFileName().toString();
            String fileExtension = BeiJingInDocumentSignatureServiceImpl.getFileExtension(fileName);
            String newFileName = UUID.randomUUID().toString() + "." + fileExtension;
            Path targetPath = sourcePath.getParent().resolve(newFileName);
            Files.copy(sourcePath, targetPath, StandardCopyOption.REPLACE_EXISTING);
            String newPath = targetPath.toString().replace(rootPath, "");
            System.out.println("\u6587\u4ef6\u590d\u5236\u6210\u529f\uff01\u65b0\u6587\u4ef6\u8def\u5f84: " + newPath);
            return newPath;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("\u6587\u4ef6\u590d\u5236\u5931\u8d25: " + e.getMessage());
            return "";
        }
    }

    private static String getFileExtension(String fileName) {
        int lastIndexOfDot = fileName.lastIndexOf(46);
        if (lastIndexOfDot == -1) {
            return "";
        }
        return fileName.substring(lastIndexOfDot + 1);
    }

    private void updateDocumentSignature() {
        String ftpOut = FileModeOutConfig.getFilePath();
        List<String> files = FtpUtil.filenames(ftpOut, "");
        for (String filename : files) {
            log.error("====> \u6587\u4e66\u7b7e\u7ae0\u7ed3\u679c\u786e\u8ba4\u5b9a\u65f6\u4efb\u52a1.updateDocumentSignature.filename\uff1a" + filename);
            String content = FtpUtil.getFileContent(ftpOut, filename);
            if (StringUtils.isEmpty((CharSequence)content)) continue;
            SignatureQueuesDocument document = (SignatureQueuesDocument)JSON.parseObject((String)content, SignatureQueuesDocument.class);
            log.error("====> \u6587\u4e66\u7b7e\u7ae0\u7ed3\u679c\u786e\u8ba4\u5b9a\u65f6\u4efb\u52a1.updateDocumentSignature.document\uff1a" + JSON.toJSONString((Object)document));
            if (document == null) continue;
            if ("2".equals(document.getStatus())) {
                this.signatureQueuesDocumentRepository.updateSignatureQueuesDocument(document.getStatus(), new Date(), document.getProcessed_result(), document.getId());
                log.error("====> \u6587\u4e66\u7b7e\u7ae0\u7ed3\u679c\u786e\u8ba4\u5b9a\u65f6\u4efb\u52a1.updateDocumentSignature.fail\uff1aend");
                continue;
            }
            String[] arr = document.getFile_url().split("-");
            String baseeContent = FtpUtil.downloadAsBase64(ftpOut, arr[1]);
            boolean boo = BeiJingInDocumentSignatureServiceImpl.base64ToFile(baseeContent, this.rootPath + arr[0]);
            log.error("====> \u6587\u4e66\u7b7e\u7ae0\u7ed3\u679c\u786e\u8ba4\u5b9a\u65f6\u4efb\u52a1.updateDocumentSignature.success\uff1aend");
        }
    }

    public static boolean base64ToFile(String base64String, String filePath) {
        try {
            byte[] bytes = Base64.decode((CharSequence)base64String);
            File file = FileUtil.file((String)filePath);
            try (FileOutputStream fos = new FileOutputStream(file);){
                IoUtil.write((OutputStream)fos, (boolean)true, (byte[])bytes);
            }
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static class DocumentFile {
        private String business_id;
        private String path;

        public String getBusiness_id() {
            return this.business_id;
        }

        public String getPath() {
            return this.path;
        }

        public void setBusiness_id(String business_id) {
            this.business_id = business_id;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DocumentFile)) {
                return false;
            }
            DocumentFile other = (DocumentFile)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$business_id = this.getBusiness_id();
            String other$business_id = other.getBusiness_id();
            if (this$business_id == null ? other$business_id != null : !this$business_id.equals(other$business_id)) {
                return false;
            }
            String this$path = this.getPath();
            String other$path = other.getPath();
            return !(this$path == null ? other$path != null : !this$path.equals(other$path));
        }

        protected boolean canEqual(Object other) {
            return other instanceof DocumentFile;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $business_id = this.getBusiness_id();
            result = result * 59 + ($business_id == null ? 43 : $business_id.hashCode());
            String $path = this.getPath();
            result = result * 59 + ($path == null ? 43 : $path.hashCode());
            return result;
        }

        public String toString() {
            return "BeiJingInDocumentSignatureServiceImpl.DocumentFile(business_id=" + this.getBusiness_id() + ", path=" + this.getPath() + ")";
        }
    }

    public static class Resource {
        private int errcode;
        private String errmsg;
        private Object data;

        public int getErrcode() {
            return this.errcode;
        }

        public String getErrmsg() {
            return this.errmsg;
        }

        public Object getData() {
            return this.data;
        }

        public void setErrcode(int errcode) {
            this.errcode = errcode;
        }

        public void setErrmsg(String errmsg) {
            this.errmsg = errmsg;
        }

        public void setData(Object data) {
            this.data = data;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Resource)) {
                return false;
            }
            Resource other = (Resource)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getErrcode() != other.getErrcode()) {
                return false;
            }
            String this$errmsg = this.getErrmsg();
            String other$errmsg = other.getErrmsg();
            if (this$errmsg == null ? other$errmsg != null : !this$errmsg.equals(other$errmsg)) {
                return false;
            }
            Object this$data = this.getData();
            Object other$data = other.getData();
            return !(this$data == null ? other$data != null : !this$data.equals(other$data));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Resource;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getErrcode();
            String $errmsg = this.getErrmsg();
            result = result * 59 + ($errmsg == null ? 43 : $errmsg.hashCode());
            Object $data = this.getData();
            result = result * 59 + ($data == null ? 43 : $data.hashCode());
            return result;
        }

        public String toString() {
            return "BeiJingInDocumentSignatureServiceImpl.Resource(errcode=" + this.getErrcode() + ", errmsg=" + this.getErrmsg() + ", data=" + this.getData() + ")";
        }
    }

    public static class SignatureData {
        private String name;
        private String address;
        private String headphoto;
        private String idcardno;
        private String year;
        private String month;
        private String day;
        private String certificateno;
        private String isSignature;
        private String fzDate;
        private String zYear;
        private String zMonth;
        private String zDay;
        private String signatureImg;
        private String unSignaturePDF;
        private String signaturePDF;

        public String getName() {
            return this.name;
        }

        public String getAddress() {
            return this.address;
        }

        public String getHeadphoto() {
            return this.headphoto;
        }

        public String getIdcardno() {
            return this.idcardno;
        }

        public String getYear() {
            return this.year;
        }

        public String getMonth() {
            return this.month;
        }

        public String getDay() {
            return this.day;
        }

        public String getCertificateno() {
            return this.certificateno;
        }

        public String getIsSignature() {
            return this.isSignature;
        }

        public String getFzDate() {
            return this.fzDate;
        }

        public String getZYear() {
            return this.zYear;
        }

        public String getZMonth() {
            return this.zMonth;
        }

        public String getZDay() {
            return this.zDay;
        }

        public String getSignatureImg() {
            return this.signatureImg;
        }

        public String getUnSignaturePDF() {
            return this.unSignaturePDF;
        }

        public String getSignaturePDF() {
            return this.signaturePDF;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setAddress(String address) {
            this.address = address;
        }

        public void setHeadphoto(String headphoto) {
            this.headphoto = headphoto;
        }

        public void setIdcardno(String idcardno) {
            this.idcardno = idcardno;
        }

        public void setYear(String year) {
            this.year = year;
        }

        public void setMonth(String month) {
            this.month = month;
        }

        public void setDay(String day) {
            this.day = day;
        }

        public void setCertificateno(String certificateno) {
            this.certificateno = certificateno;
        }

        public void setIsSignature(String isSignature) {
            this.isSignature = isSignature;
        }

        public void setFzDate(String fzDate) {
            this.fzDate = fzDate;
        }

        public void setZYear(String zYear) {
            this.zYear = zYear;
        }

        public void setZMonth(String zMonth) {
            this.zMonth = zMonth;
        }

        public void setZDay(String zDay) {
            this.zDay = zDay;
        }

        public void setSignatureImg(String signatureImg) {
            this.signatureImg = signatureImg;
        }

        public void setUnSignaturePDF(String unSignaturePDF) {
            this.unSignaturePDF = unSignaturePDF;
        }

        public void setSignaturePDF(String signaturePDF) {
            this.signaturePDF = signaturePDF;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SignatureData)) {
                return false;
            }
            SignatureData other = (SignatureData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$address = this.getAddress();
            String other$address = other.getAddress();
            if (this$address == null ? other$address != null : !this$address.equals(other$address)) {
                return false;
            }
            String this$headphoto = this.getHeadphoto();
            String other$headphoto = other.getHeadphoto();
            if (this$headphoto == null ? other$headphoto != null : !this$headphoto.equals(other$headphoto)) {
                return false;
            }
            String this$idcardno = this.getIdcardno();
            String other$idcardno = other.getIdcardno();
            if (this$idcardno == null ? other$idcardno != null : !this$idcardno.equals(other$idcardno)) {
                return false;
            }
            String this$year = this.getYear();
            String other$year = other.getYear();
            if (this$year == null ? other$year != null : !this$year.equals(other$year)) {
                return false;
            }
            String this$month = this.getMonth();
            String other$month = other.getMonth();
            if (this$month == null ? other$month != null : !this$month.equals(other$month)) {
                return false;
            }
            String this$day = this.getDay();
            String other$day = other.getDay();
            if (this$day == null ? other$day != null : !this$day.equals(other$day)) {
                return false;
            }
            String this$certificateno = this.getCertificateno();
            String other$certificateno = other.getCertificateno();
            if (this$certificateno == null ? other$certificateno != null : !this$certificateno.equals(other$certificateno)) {
                return false;
            }
            String this$isSignature = this.getIsSignature();
            String other$isSignature = other.getIsSignature();
            if (this$isSignature == null ? other$isSignature != null : !this$isSignature.equals(other$isSignature)) {
                return false;
            }
            String this$fzDate = this.getFzDate();
            String other$fzDate = other.getFzDate();
            if (this$fzDate == null ? other$fzDate != null : !this$fzDate.equals(other$fzDate)) {
                return false;
            }
            String this$zYear = this.getZYear();
            String other$zYear = other.getZYear();
            if (this$zYear == null ? other$zYear != null : !this$zYear.equals(other$zYear)) {
                return false;
            }
            String this$zMonth = this.getZMonth();
            String other$zMonth = other.getZMonth();
            if (this$zMonth == null ? other$zMonth != null : !this$zMonth.equals(other$zMonth)) {
                return false;
            }
            String this$zDay = this.getZDay();
            String other$zDay = other.getZDay();
            if (this$zDay == null ? other$zDay != null : !this$zDay.equals(other$zDay)) {
                return false;
            }
            String this$signatureImg = this.getSignatureImg();
            String other$signatureImg = other.getSignatureImg();
            if (this$signatureImg == null ? other$signatureImg != null : !this$signatureImg.equals(other$signatureImg)) {
                return false;
            }
            String this$unSignaturePDF = this.getUnSignaturePDF();
            String other$unSignaturePDF = other.getUnSignaturePDF();
            if (this$unSignaturePDF == null ? other$unSignaturePDF != null : !this$unSignaturePDF.equals(other$unSignaturePDF)) {
                return false;
            }
            String this$signaturePDF = this.getSignaturePDF();
            String other$signaturePDF = other.getSignaturePDF();
            return !(this$signaturePDF == null ? other$signaturePDF != null : !this$signaturePDF.equals(other$signaturePDF));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SignatureData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $address = this.getAddress();
            result = result * 59 + ($address == null ? 43 : $address.hashCode());
            String $headphoto = this.getHeadphoto();
            result = result * 59 + ($headphoto == null ? 43 : $headphoto.hashCode());
            String $idcardno = this.getIdcardno();
            result = result * 59 + ($idcardno == null ? 43 : $idcardno.hashCode());
            String $year = this.getYear();
            result = result * 59 + ($year == null ? 43 : $year.hashCode());
            String $month = this.getMonth();
            result = result * 59 + ($month == null ? 43 : $month.hashCode());
            String $day = this.getDay();
            result = result * 59 + ($day == null ? 43 : $day.hashCode());
            String $certificateno = this.getCertificateno();
            result = result * 59 + ($certificateno == null ? 43 : $certificateno.hashCode());
            String $isSignature = this.getIsSignature();
            result = result * 59 + ($isSignature == null ? 43 : $isSignature.hashCode());
            String $fzDate = this.getFzDate();
            result = result * 59 + ($fzDate == null ? 43 : $fzDate.hashCode());
            String $zYear = this.getZYear();
            result = result * 59 + ($zYear == null ? 43 : $zYear.hashCode());
            String $zMonth = this.getZMonth();
            result = result * 59 + ($zMonth == null ? 43 : $zMonth.hashCode());
            String $zDay = this.getZDay();
            result = result * 59 + ($zDay == null ? 43 : $zDay.hashCode());
            String $signatureImg = this.getSignatureImg();
            result = result * 59 + ($signatureImg == null ? 43 : $signatureImg.hashCode());
            String $unSignaturePDF = this.getUnSignaturePDF();
            result = result * 59 + ($unSignaturePDF == null ? 43 : $unSignaturePDF.hashCode());
            String $signaturePDF = this.getSignaturePDF();
            result = result * 59 + ($signaturePDF == null ? 43 : $signaturePDF.hashCode());
            return result;
        }

        public String toString() {
            return "BeiJingInDocumentSignatureServiceImpl.SignatureData(name=" + this.getName() + ", address=" + this.getAddress() + ", headphoto=" + this.getHeadphoto() + ", idcardno=" + this.getIdcardno() + ", year=" + this.getYear() + ", month=" + this.getMonth() + ", day=" + this.getDay() + ", certificateno=" + this.getCertificateno() + ", isSignature=" + this.getIsSignature() + ", fzDate=" + this.getFzDate() + ", zYear=" + this.getZYear() + ", zMonth=" + this.getZMonth() + ", zDay=" + this.getZDay() + ", signatureImg=" + this.getSignatureImg() + ", unSignaturePDF=" + this.getUnSignaturePDF() + ", signaturePDF=" + this.getSignaturePDF() + ")";
        }
    }
}

