/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.signature.util;

import com.bcxin.signature.util.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Locale;
import javax.imageio.stream.FileImageInputStream;
import org.apache.commons.io.IOUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public final class FileUtils {
    private FileUtils() {
    }

    public static boolean mkdirs(File file) {
        if (null == file) {
            return false;
        }
        if (file.exists()) {
            return false;
        }
        return file.mkdirs();
    }

    public static boolean mkdirs(String directory) {
        if (StringUtils.isBlank((CharSequence)directory)) {
            return false;
        }
        return FileUtils.mkdirs((File)new File(directory));
    }

    public static boolean delete(File file) {
        if (null == file) {
            return false;
        }
        if (!file.exists()) {
            return false;
        }
        return file.delete();
    }

    public static boolean delete(String file) {
        if (StringUtils.isBlank((CharSequence)file)) {
            return false;
        }
        return FileUtils.delete((File)new File(file));
    }

    public static boolean exists(String fileName) {
        if (StringUtils.isBlank((CharSequence)fileName)) {
            return false;
        }
        File file = new File(fileName);
        return file.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFileHeader(String file) {
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            byte[] header = new byte[4];
            ((InputStream)in).read(header, 0, header.length);
            String string = StringUtils.bytes2Hex((byte[])header);
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (null != in) {
                    ((InputStream)in).close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static String getFileHeader(byte[] fileData) {
        if (null == fileData) {
            return null;
        }
        byte[] header = new byte[4];
        System.arraycopy(fileData, 0, header, 0, header.length);
        return StringUtils.bytes2Hex((byte[])header);
    }

    public static boolean isBmpFile(byte[] fileData) {
        if (null == fileData) {
            return false;
        }
        String header = FileUtils.getFileHeader((byte[])fileData).toUpperCase(Locale.ENGLISH);
        header = header.substring(0, 4);
        return "424D".equals(header);
    }

    public static boolean isPdfFile(byte[] fileData) {
        if (null == fileData) {
            return false;
        }
        String header = FileUtils.getFileHeader((byte[])fileData).toUpperCase(Locale.ENGLISH);
        header = header.substring(0, 4);
        return "2550".equals(header);
    }

    public static boolean isPdfFile(String filePath) {
        if (StringUtils.isBlank((CharSequence)filePath)) {
            return false;
        }
        String header = FileUtils.getFileHeader((String)filePath).toUpperCase(Locale.ENGLISH);
        header = header.substring(0, 4);
        return "2550".equals(header);
    }

    public static boolean isWordOrExcel(byte[] fileData) {
        if (null == fileData) {
            return false;
        }
        String header = FileUtils.getFileHeader((byte[])fileData).toUpperCase(Locale.ENGLISH);
        header = header.substring(0, 4);
        return "D0CF".equals(header);
    }

    public static boolean isPfxFile(byte[] fileData) {
        if (null == fileData) {
            return false;
        }
        String header = FileUtils.getFileHeader((byte[])fileData).toUpperCase(Locale.ENGLISH);
        header = header.substring(0, 4);
        return "3082".equals(header);
    }

    public static String getExpandedNameByFileName(String fileName) {
        if (StringUtils.isBlank((CharSequence)fileName)) {
            return null;
        }
        return fileName.substring(fileName.lastIndexOf(".") + 1);
    }

    public byte[] image2byte(String path) {
        byte[] data = null;
        FileImageInputStream input = null;
        try {
            input = new FileImageInputStream(new File(path));
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            byte[] buf = new byte[1024];
            int numBytesRead = 0;
            while ((numBytesRead = input.read(buf)) != -1) {
                output.write(buf, 0, numBytesRead);
            }
            data = output.toByteArray();
            output.close();
            input.close();
        }
        catch (FileNotFoundException ex1) {
            ex1.printStackTrace();
        }
        catch (IOException ex1) {
            ex1.printStackTrace();
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readInputStreamToBytes(InputStream in) throws IOException {
        byte[] byArray;
        if (null == in) {
            return null;
        }
        ByteArrayOutputStream out = null;
        try {
            out = new ByteArrayOutputStream(4096);
            byte[] data = new byte[4096];
            int len = 0;
            while ((len = in.read(data)) > 0) {
                out.write(data, 0, len);
            }
            byArray = out.toByteArray();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(out);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)out);
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFileTobytes(String filePath) {
        FileInputStream in = null;
        try {
            in = new FileInputStream(filePath);
            byte[] byArray = IOUtils.toByteArray((InputStream)in);
            return byArray;
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (null != in) {
                    ((InputStream)in).close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(byte[] data, String filePath) {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(filePath);
            IOUtils.write((byte[])data, (OutputStream)out);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (null != out) {
                    ((OutputStream)out).close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyFile(String srcFileName, String destFileName, boolean overlay) {
        File srcFile = new File(srcFileName);
        if (!srcFile.exists()) {
            return false;
        }
        if (!srcFile.isFile()) {
            return false;
        }
        File destFile = new File(destFileName);
        if (destFile.exists()) {
            if (overlay) {
                new File(destFileName).delete();
            }
        } else if (!destFile.getParentFile().exists() && !destFile.getParentFile().mkdirs()) {
            return false;
        }
        int byteread = 0;
        FileInputStream in = null;
        OutputStream out = null;
        try {
            in = new FileInputStream(srcFile);
            out = new FileOutputStream(destFile);
            byte[] buffer = new byte[1024];
            while ((byteread = ((InputStream)in).read(buffer)) != -1) {
                out.write(buffer, 0, byteread);
            }
            buffer = null;
            boolean bl = true;
            return bl;
        }
        catch (FileNotFoundException e) {
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
                if (in != null) {
                    ((InputStream)in).close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

