/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.backend.domain.signature.service.impls;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.backend.core.utils.ExceptionUtils;
import com.bcxin.backend.domain.models.SignatureQueuesDTO;
import com.bcxin.backend.domain.repositories.SignatureQueuesRepository;
import com.bcxin.backend.domain.services.impls.ConvertServiceImpl;
import com.bcxin.backend.domain.signature.service.QzSignatureStrategy;
import com.bcxin.backend.domain.signature.service.impls.vos.CertificateVo;
import com.bcxin.backend.domain.syncs.dtos.SharedConvertDto;
import io.jsonwebtoken.lang.Collections;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
@Deprecated
public class BeiJingInSignatureToPDFCompare
implements QzSignatureStrategy {
    private static final Logger log = LoggerFactory.getLogger(BeiJingInSignatureToPDFCompare.class);
    private static final Logger logger = LoggerFactory.getLogger(BeiJingInSignatureToPDFCompare.class);
    private final SignatureQueuesRepository signatureQueuesRepository;
    @Value(value="${myapps.domain.url}")
    String urlHead;
    @Value(value="${myapps.storage.root}")
    String rootPath;
    @Value(value="${myapps.signature.tempPDF}")
    String tempPDF;
    @Value(value="${myapps.signature.mobanPDF}")
    String mobanPDF;
    @Value(value="${myapps.signature.cgiApi}")
    String cgiApi;
    @Autowired
    private ConvertServiceImpl convertService;
    @Autowired
    @Qualifier(value="primaryJdbcTemplate")
    protected JdbcTemplate jdbcTemplate;

    public BeiJingInSignatureToPDFCompare(SignatureQueuesRepository signatureQueuesRepository) {
        this.signatureQueuesRepository = signatureQueuesRepository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cerSignatureQueues() {
        String sql = "select id,item_securityname,item_documentid,item_idaddress,item_certificateno,item_certificatefrom, item_certificatedate,item_headphoto,created,item_signatured_processed_status  from tlk_certificate where ITEM_signatured_processed_status IN (0) and  ITEM_CERTIFICATETYPE='1' and ITEM_isCertified != '0'  order by item_certificateDate desc, ITEM_signatured_time desc limit 300";
        List list = this.jdbcTemplate.query(sql, (RowMapper)new RowMapper<CertificateVo>(){

            public CertificateVo mapRow(ResultSet rs, int rowNum) throws SQLException {
                return CertificateVo.create(rs.getString("id"), rs.getString("item_securityname"), rs.getString("item_documentid"), rs.getString("item_idaddress"), rs.getString("item_certificateno"), rs.getString("item_certificatefrom"), rs.getString("item_certificatedate"), rs.getString("item_headphoto"), rs.getString("created"), rs.getString("item_signatured_processed_status"), rs.getString("AUTHOR"));
            }
        });
        logger.error("\u83b7\u53d6\u5230\u5f85\u7b7e\u7ae0\u7684\u8d44\u683c\u8bc1\u6570\u91cf:{}", (Object)list.size());
        if (!CollectionUtils.isEmpty((Collection)list)) {
            for (CertificateVo certificateVo : list) {
                String securityname = certificateVo.getItem_securityname();
                String documentid = certificateVo.getItem_documentid();
                String IdAddress = certificateVo.getItem_idaddress();
                String certificateno = certificateVo.getItem_certificateno();
                String certificatefrom = certificateVo.getItem_certificatefrom();
                if (!certificateVo.doCheck(this.urlHead)) continue;
                String headphoto = certificateVo.getHeadPhoto();
                String year = String.valueOf(certificateVo.getYearFromIdCard());
                String month = String.valueOf(certificateVo.getMonthFromIdCard());
                String day = String.valueOf(certificateVo.getDayFromIdCard());
                String certificatedate = certificateVo.getCertificatedate();
                String json = "{\"name\":\"" + securityname + "\",\"author\":\"" + certificateVo.getAuthor() + "\",\"address\":\"" + IdAddress + "\",\"headphoto\":\"" + headphoto + "\",\"idcardno\":\"" + documentid + "\",\"year\":\"" + year + "\",\"month\":\"" + month + "\",\"day\":\"" + day + "\",\"certificateno\":\"" + certificateno + "\",\"certificatefrom\":\"" + certificatefrom + "\",\"isSignature\":\"1\",\"fzDate\":\"" + certificatedate + "\"}";
                certificateVo.assignProcessJson(json);
            }
            String moban = this.mobanPDF;
            for (CertificateVo.ProcessStatus status : CertificateVo.ProcessStatus.values()) {
                Collection selectedCertificateVos = list.stream().filter(ii -> ii.getProcessStatus() == status).collect(Collectors.toList());
                String executeSql = null;
                StringBuilder trace = new StringBuilder();
                trace.append(String.format("\u6267\u884c\u7b7e\u7ae0\u7684status=%s;size=%s", status.getText(), selectedCertificateVos.size()));
                try {
                    if (CollectionUtils.isEmpty((Collection)selectedCertificateVos)) continue;
                    executeSql = status.getSql();
                    String idParams = selectedCertificateVos.stream().map(ii -> String.format("'%s'", ii.getId())).collect(Collectors.joining(","));
                    executeSql = String.format("%s where id in (%s)", executeSql, idParams);
                    trace.append(String.format("status=%s;sql=%s;", new Object[]{status, executeSql}));
                    if (status == CertificateVo.ProcessStatus.SUCCESS) {
                        String insertSql = status.getInsertSql();
                        ArrayList<Object[]> params = new ArrayList<Object[]>();
                        for (CertificateVo vi : selectedCertificateVos) {
                            Object[] itemPs = new Object[]{"2.0", moban, vi.getProcessJson(), 0, vi.getId(), Timestamp.from(Instant.now()), "", vi.getCertificatedate()};
                            params.add(itemPs);
                        }
                        trace.append(String.format("insertSql=%s;", insertSql));
                        this.jdbcTemplate.batchUpdate(insertSql, params);
                    }
                    this.jdbcTemplate.batchUpdate(new String[]{executeSql});
                }
                catch (Exception ex) {
                    logger.error("\u6267\u884cSQL({})\u53d1\u751f\u5f02\u5e38", (Object)executeSql, (Object)ex);
                }
                finally {
                    logger.error("\u8ddf\u8e2a\u8d44\u683c\u8bc1\u6267\u884c\u60c5\u51b5:{}", (Object)trace);
                }
            }
        }
    }

    @Override
    public void cerPDF() {
        this.createPDF();
    }

    private boolean activateXMPSignQuicklyExCGI() {
        StringBuilder sb = new StringBuilder();
        try {
            JSONObject json = new JSONObject();
            json.put("service", (Object)"wss://127.0.0.1:8800");
            json.put("sn", (Object)"2171101001009256");
            json.put("pin", (Object)"88888888");
            json.put("in", (Object)"/data/share/in");
            json.put("out", (Object)"/data/share/out");
            JSONArray arr = new JSONArray();
            JSONObject pos = new JSONObject();
            pos.put("centerX", (Object)405);
            pos.put("centerY", (Object)312);
            pos.put("page", (Object)1);
            arr.add((Object)pos);
            json.put("signOnPos", (Object)arr);
            String ret = HttpUtil.post((String)this.cgiApi, (String)json.toJSONString());
            log.info("====> \u7535\u5b50\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb.activateXMPSignQuicklyExCGI.ret\uff1a" + ret);
            if (StringUtils.isEmpty((CharSequence)ret)) {
                return false;
            }
            JSONObject result = JSON.parseObject((String)ret.replace("#", ""));
            return "1".equals(String.valueOf(result.get((Object)"code")));
        }
        catch (Exception e) {
            log.info("====> \u7535\u5b50\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb.activateXMPSignQuicklyExCGI message:" + e.getMessage());
            return false;
        }
    }

    private void createPDF() {
        Page<SignatureQueuesDTO> pageQueues = this.signatureQueuesRepository.pageQueues(0, PageRequest.of((int)0, (int)100));
        List queues = pageQueues.getContent();
        if (Collections.isEmpty((Collection)queues)) {
            log.info("====> \u7535\u5b50\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb.createPDF.queues.\u65e0\u4e1a\u52a1\u6570\u636e ---------------------");
            return;
        }
        log.info("====> \u7535\u5b50\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb.createPDF.queues.size()=" + queues.size());
        for (SignatureQueuesDTO queuesDTO : queues) {
            this.accept(queuesDTO);
        }
    }

    private void accept(SignatureQueuesDTO queue) {
        try {
            log.info("====> \u7535\u5b50\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb.createPDF.accept.\u5355\u6b21\u4e1a\u52a1\u5f00\u59cb\uff1a" + queue.getId());
            Long a = System.currentTimeMillis();
            if (queue.getData().contains("b.photoUrl") || queue.getData().contains("uid")) {
                this.signatureQueuesRepository.deleteById(queue.getId());
                String updateSql = "UPDATE tlk_certificate SET ITEM_SIGNATURED_PROCESSED_STATUS=\"3\",ITEM_LAST_SIGNATURED_PROCESSED_TIME=NOW(),ITEM_LAST_SIGNATURED_PROCESSED_RESULT=\"\u7b7e\u7ae0\u5931\u8d25\uff1a\u8bc1\u4e66\u4fe1\u606f\u4e0d\u5168\uff08\u8eab\u4efd\u8bc1\u5934\u50cf\uff09\" WHERE ID=\"" + queue.getBusiness_id() + "\";";
                this.jdbcTemplate.update(updateSql);
                log.info("====> \u7535\u5b50\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb.createPDF.accept.\u5355\u6b21\u4e1a\u52a1\u5934\u50cf\u4fe1\u606f\u4e0d\u53ef\u7528\uff0cend");
                return;
            }
            SignatureData data = (SignatureData)JSONObject.parseObject((String)queue.getData(), SignatureData.class);
            if (StringUtils.isEmpty((CharSequence)data.getAddress()) || data.getAddress().contains(" ")) {
                this.signatureQueuesRepository.deleteById(queue.getId());
                String updateSql = "UPDATE tlk_certificate SET ITEM_SIGNATURED_PROCESSED_STATUS=\"3\",ITEM_LAST_SIGNATURED_PROCESSED_TIME=NOW(),ITEM_LAST_SIGNATURED_PROCESSED_RESULT=\"\u7b7e\u7ae0\u5931\u8d25\uff1a\u8bc1\u4e66\u4fe1\u606f\u4e0d\u5168\uff08\u8eab\u4efd\u8bc1\u4f4f\u5740\uff09\" WHERE ID=\"" + queue.getBusiness_id() + "\";";
                this.jdbcTemplate.update(updateSql);
                log.info("====> \u7535\u5b50\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb.createPDF.accept.\u5355\u6b21\u4e1a\u52a1\u5730\u5740\u4fe1\u606f\u4e0d\u53ef\u7528\uff0cend");
                return;
            }
            log.info("====> \u7535\u5b50\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb.createPDF.accept.\u5355\u6b21\u4e1a\u52a1\uff1a001\uff1a" + queue.getData());
            data.setUnSignaturePDF(this.tempPDF + "/" + System.currentTimeMillis() + "queueId_" + queue.getId() + ".temp");
            String toDay = data.getFzDate();
            if (StringUtils.isEmpty((CharSequence)toDay)) {
                toDay = DateUtil.today();
            }
            data.setZYear(toDay.split("-")[0]);
            data.setZMonth(toDay.split("-")[1]);
            data.setZDay(toDay.split("-")[2]);
            data.setHeadphoto(data.getHeadphoto().startsWith("http") ? data.getHeadphoto() : this.urlHead + data.getHeadphoto());
            log.info("====> \u7535\u5b50\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb.createPDF.accept.\u5355\u6b21\u4e1a\u52a1\uff1a002");
            SharedConvertDto sharedConvertDto = new SharedConvertDto();
            sharedConvertDto.setTempUrl(queue.getTemplate_url());
            sharedConvertDto.setFormData(data);
            if (!this.doesFileExist(data.getHeadphoto())) {
                log.info("====> \u7535\u5b50\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb.createPDF.accept.Headphoto\uff1a002\uff1afail\uff1a\u65e0\u5934\u50cf\u4fe1\u606f end");
                this.signatureQueuesRepository.updateSignature(2, new Date(), "PDF\u751f\u6210\u5931\u8d25\uff1a\u65e0\u5934\u50cf\u4fe1\u606f", queue.getId());
                String updateSql = "UPDATE tlk_certificate SET ITEM_SIGNATURED_PROCESSED_STATUS=\"3\",ITEM_LAST_SIGNATURED_PROCESSED_TIME=NOW(),ITEM_LAST_SIGNATURED_PROCESSED_RESULT=\"\u7b7e\u7ae0\u5931\u8d25\uff1a\u65e0\u5934\u50cf\u4fe1\u606f\" WHERE ID=\"" + queue.getBusiness_id() + "\";";
                this.jdbcTemplate.update(updateSql);
                log.info("====> \u7535\u5b50\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb.createPDF.accept.\u5355\u6b21\u4e1a\u52a1\uff1a002\uff1afail\uff1a\u65e0\u5934\u50cf\u4fe1\u606f end");
                return;
            }
            String result = this.convertService.execConvertHtmltopdfForTemp(sharedConvertDto);
            log.info("====> \u7535\u5b50\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb.createPDF.accept.\u5355\u6b21\u4e1a\u52a1\uff1a003:" + result);
            if (StringUtils.isNotEmpty((CharSequence)result)) {
                this.signatureQueuesRepository.updateSignature(3, new Date(), "PDF\u5df2\u751f\u6210\u5f85\u7b7e\u7ae0", queue.getId());
                log.info("====> \u7535\u5b50\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb.createPDF.accept.\u5355\u6b21\u4e1a\u52a1\uff1a004:success");
            } else {
                this.signatureQueuesRepository.updateSignature(2, new Date(), "PDF\u751f\u6210\u5931\u8d25", queue.getId());
                log.info("====> \u7535\u5b50\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb.createPDF.accept.\u5355\u6b21\u4e1a\u52a1\uff1a004:fail");
            }
            log.info("====> \u7535\u5b50\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb.createPDF.accept.\u5355\u6b21\u751f\u6210\u6587\u4ef6\u8017\u65f6\uff1a" + (System.currentTimeMillis() - a));
        }
        catch (Exception e) {
            log.error("====> \u7535\u5b50\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb.createPDF.accept.pdf\u751f\u6210\u5f02\u5e38\u5f00\u59cb\uff1a" + e.getMessage());
            this.signatureQueuesRepository.deleteById(queue.getId());
            log.error("====> \u7535\u5b50\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb.createPDF.accept.pdf\u751f\u6210\u5f02\u5e38\u5220\u9664signature_queues\uff1a" + queue.getId());
            String updateSql = "UPDATE tlk_certificate SET ITEM_SIGNATURED_PROCESSED_STATUS=\"3\",ITEM_LAST_SIGNATURED_PROCESSED_TIME=NOW(),ITEM_LAST_SIGNATURED_PROCESSED_RESULT=\"\u7b7e\u7ae0\u5931\u8d25\uff1a" + e.getMessage() + "\" WHERE ID=\"" + queue.getBusiness_id() + "\";";
            log.error("====> \u7535\u5b50\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb.createPDF.accept.pdf\u751f\u6210\u5f02\u5e38\u5220\u9664tlk_certificate\uff1a" + queue.getBusiness_id());
            this.jdbcTemplate.update(updateSql);
            log.error("====> \u7535\u5b50\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb.createPDF.accept.pdf\u751f\u6210\u5f02\u5e38\uff1a" + e.getMessage());
        }
    }

    public boolean doesFileExist(String urlString) {
        log.error("====> \u7535\u5b50\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb.createPDF.accept.doesFileExist.urlString2\uff1a" + urlString);
        HttpResponse response = HttpRequest.get((String)urlString).execute();
        return response.getStatus() == 200;
    }

    @Override
    public void delInPDF() {
        SharedConvertDto sharedConvertDto = new SharedConvertDto();
        sharedConvertDto.setTempUrl(this.tempPDF);
        this.convertService.delInPDF(sharedConvertDto);
    }

    @Override
    public void signQuicklyExCGI() {
        Long a = System.currentTimeMillis();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("tempUrl", (Object)this.tempPDF);
        jsonObject.put("formData", (Object)230);
        try {
            SharedConvertDto sharedConvertDto = new SharedConvertDto();
            String tempUrl = jsonObject.getString("tempUrl");
            String formData = jsonObject.getString("formData");
            sharedConvertDto.setTempUrl(tempUrl);
            sharedConvertDto.setFormData(formData);
            new Thread(() -> {
                try {
                    this.convertService.delInPDF(sharedConvertDto);
                }
                catch (Exception e) {
                    log.error("====> \u7535\u5b50\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb.signQuicklyExCGI\u7b7e\u7ae0\u524d\u6bd4\u5bf9in\u6587\u4ef6\u5220\u9664\uff1a" + e.getMessage());
                }
            }).start();
            this.convertService.existsPdfCopy(sharedConvertDto);
            this.convertService.delInPDF(this.tempPDF);
            this.activateXMPSignQuicklyExCGI();
            new Thread(() -> {
                try {
                    this.convertService.delInPDF(sharedConvertDto);
                }
                catch (Exception e) {
                    log.error("====> \u7535\u5b50\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb.signQuicklyExCGI\u7b7e\u7ae0\u540e\u6bd4\u5bf9in\u6587\u4ef6\u5220\u9664\uff1a" + e.getMessage());
                }
            }).start();
            log.info("====> \u7535\u5b50\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb.signQuicklyExCGI.\u7b7e\u7ae0\u63a5\u53e3\u8017\u65f6\uff1a" + (System.currentTimeMillis() - a));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void changeStatus() {
        String updateSql = "update obpm2_security.signature_queues set status = '0' where status = '3' and TIMESTAMPDIFF(HOUR, last_processed_time, NOW()) > 3";
        this.jdbcTemplate.update(updateSql);
        this.signatureCompensate();
    }

    private void signatureCompensate() {
        Date now = new Date();
        DateTime oneHourAgo = DateUtil.offsetMinute((Date)now, (int)-30);
        DateTime twoHourAgo = DateUtil.offsetMinute((Date)now, (int)-150);
        this.signatureQueuesRepository.updateLastHousePhoto((Date)oneHourAgo, (Date)twoHourAgo);
    }

    @Override
    public void scan() {
        try {
            String[] failS;
            Long a = System.currentTimeMillis();
            String pdfFile = "/uploads/pdf/dianziqianzhang/out";
            SharedConvertDto sharedConvertDto = new SharedConvertDto();
            sharedConvertDto.setTempUrl(pdfFile);
            sharedConvertDto.setFormData(null);
            String result = this.convertService.existsScanSignature(sharedConvertDto);
            if (StringUtils.isEmpty((CharSequence)result)) {
                log.info("====> \u7535\u5b50\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb.scan.result\uff1a\u7a7a");
                return;
            }
            log.info("====> \u7535\u5b50\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb.scan.\u6279\u91cf\u4e0a\u4f20ftp\u7ed3\u675f\u8017\u65f6\uff1a" + (System.currentTimeMillis() - a));
            JSONObject json = JSONObject.parseObject((String)result);
            Object success = json.get((Object)"success");
            Object fail = json.get((Object)"fail");
            List<String> failList = null;
            String successFile = "";
            String failFile = "";
            if (success != null) {
                successFile = (String)success;
            }
            if (fail != null && StringUtils.isNotEmpty((CharSequence)(failFile = (String)fail)) && (failS = failFile.replace(".pdf", "").split("queueId_")[1].split(",")).length > 0) {
                failList = Arrays.asList(failS);
            }
            String fileNames = successFile + failFile;
            new Thread(() -> {
                try {
                    this.convertService.delSetFtpFile(this.tempPDF, fileNames);
                }
                catch (Exception e) {
                    log.error("====> \u7535\u5b50\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb.scan.ftp\u64cd\u4f5c\u8fc7\u7684\u6587\u4ef6\u5220\u9664\uff1a" + e.getMessage());
                }
            }).start();
            if (StringUtils.isNotEmpty((CharSequence)successFile)) {
                String[] successSplit;
                for (String string : successSplit = successFile.split(",")) {
                    String successFilePath = pdfFile + "/" + string;
                    String id = string.split("queueId_")[1].replace(".pdf", "");
                    String business_id = this.signatureQueuesRepository.getBuId(id);
                    String updateSql = "UPDATE tlk_certificate SET ITEM_SIGNATURED_PROCESSED_STATUS=\"2\",LASTMODIFIED=NOW(),ITEM_LAST_SIGNATURED_PROCESSED_TIME=NOW(),ITEM_CERTIFICATEDATE=IFNULL(ITEM_CERTIFICATEDATE,NOW()),ITEM_LAST_SIGNATURED_PROCESSED_RESULT=\"\u5b8c\u6210\",ITEM_ATTACHMENT=\"" + successFilePath + "\" WHERE ID=\"" + business_id + "\";";
                    this.jdbcTemplate.update(updateSql);
                    this.signatureQueuesRepository.updateSignature(1, new Date(), "\u6210\u529f", id);
                }
            }
            if (failList != null) {
                this.signatureQueuesRepository.updateSignatures(2, new Date(), "\u672a\u6210\u529f\u7b7e\u7ae0", failList);
            }
            log.info("====> \u7535\u5b50\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb.scan.50\u4e2aPDF\u5df2\u7b7e\u7ae0\u6587\u4ef6\u5b58FTP\u8017\u65f6\uff1a" + (System.currentTimeMillis() - a));
        }
        catch (Exception e) {
            log.error("====> \u7535\u5b50\u7b7e\u7ae0\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb.scan.updateSql error\uff1a" + ExceptionUtils.getStackMessage((Throwable)e));
        }
    }

    public static class Resource {
        private int errcode;
        private String errmsg;
        private Object data;

        public int getErrcode() {
            return this.errcode;
        }

        public String getErrmsg() {
            return this.errmsg;
        }

        public Object getData() {
            return this.data;
        }

        public void setErrcode(int errcode) {
            this.errcode = errcode;
        }

        public void setErrmsg(String errmsg) {
            this.errmsg = errmsg;
        }

        public void setData(Object data) {
            this.data = data;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Resource)) {
                return false;
            }
            Resource other = (Resource)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getErrcode() != other.getErrcode()) {
                return false;
            }
            String this$errmsg = this.getErrmsg();
            String other$errmsg = other.getErrmsg();
            if (this$errmsg == null ? other$errmsg != null : !this$errmsg.equals(other$errmsg)) {
                return false;
            }
            Object this$data = this.getData();
            Object other$data = other.getData();
            return !(this$data == null ? other$data != null : !this$data.equals(other$data));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Resource;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getErrcode();
            String $errmsg = this.getErrmsg();
            result = result * 59 + ($errmsg == null ? 43 : $errmsg.hashCode());
            Object $data = this.getData();
            result = result * 59 + ($data == null ? 43 : $data.hashCode());
            return result;
        }

        public String toString() {
            return "BeiJingInSignatureToPDFCompare.Resource(errcode=" + this.getErrcode() + ", errmsg=" + this.getErrmsg() + ", data=" + this.getData() + ")";
        }
    }

    public static class SignatureData {
        private String name;
        private String address;
        private String headphoto;
        private String idcardno;
        private String year;
        private String month;
        private String day;
        private String certificateno;
        private String isSignature;
        private String fzDate;
        private String zYear;
        private String zMonth;
        private String zDay;
        private String signatureImg;
        private String unSignaturePDF;
        private String signaturePDF;

        public String getName() {
            return this.name;
        }

        public String getAddress() {
            return this.address;
        }

        public String getHeadphoto() {
            return this.headphoto;
        }

        public String getIdcardno() {
            return this.idcardno;
        }

        public String getYear() {
            return this.year;
        }

        public String getMonth() {
            return this.month;
        }

        public String getDay() {
            return this.day;
        }

        public String getCertificateno() {
            return this.certificateno;
        }

        public String getIsSignature() {
            return this.isSignature;
        }

        public String getFzDate() {
            return this.fzDate;
        }

        public String getZYear() {
            return this.zYear;
        }

        public String getZMonth() {
            return this.zMonth;
        }

        public String getZDay() {
            return this.zDay;
        }

        public String getSignatureImg() {
            return this.signatureImg;
        }

        public String getUnSignaturePDF() {
            return this.unSignaturePDF;
        }

        public String getSignaturePDF() {
            return this.signaturePDF;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setAddress(String address) {
            this.address = address;
        }

        public void setHeadphoto(String headphoto) {
            this.headphoto = headphoto;
        }

        public void setIdcardno(String idcardno) {
            this.idcardno = idcardno;
        }

        public void setYear(String year) {
            this.year = year;
        }

        public void setMonth(String month) {
            this.month = month;
        }

        public void setDay(String day) {
            this.day = day;
        }

        public void setCertificateno(String certificateno) {
            this.certificateno = certificateno;
        }

        public void setIsSignature(String isSignature) {
            this.isSignature = isSignature;
        }

        public void setFzDate(String fzDate) {
            this.fzDate = fzDate;
        }

        public void setZYear(String zYear) {
            this.zYear = zYear;
        }

        public void setZMonth(String zMonth) {
            this.zMonth = zMonth;
        }

        public void setZDay(String zDay) {
            this.zDay = zDay;
        }

        public void setSignatureImg(String signatureImg) {
            this.signatureImg = signatureImg;
        }

        public void setUnSignaturePDF(String unSignaturePDF) {
            this.unSignaturePDF = unSignaturePDF;
        }

        public void setSignaturePDF(String signaturePDF) {
            this.signaturePDF = signaturePDF;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SignatureData)) {
                return false;
            }
            SignatureData other = (SignatureData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$address = this.getAddress();
            String other$address = other.getAddress();
            if (this$address == null ? other$address != null : !this$address.equals(other$address)) {
                return false;
            }
            String this$headphoto = this.getHeadphoto();
            String other$headphoto = other.getHeadphoto();
            if (this$headphoto == null ? other$headphoto != null : !this$headphoto.equals(other$headphoto)) {
                return false;
            }
            String this$idcardno = this.getIdcardno();
            String other$idcardno = other.getIdcardno();
            if (this$idcardno == null ? other$idcardno != null : !this$idcardno.equals(other$idcardno)) {
                return false;
            }
            String this$year = this.getYear();
            String other$year = other.getYear();
            if (this$year == null ? other$year != null : !this$year.equals(other$year)) {
                return false;
            }
            String this$month = this.getMonth();
            String other$month = other.getMonth();
            if (this$month == null ? other$month != null : !this$month.equals(other$month)) {
                return false;
            }
            String this$day = this.getDay();
            String other$day = other.getDay();
            if (this$day == null ? other$day != null : !this$day.equals(other$day)) {
                return false;
            }
            String this$certificateno = this.getCertificateno();
            String other$certificateno = other.getCertificateno();
            if (this$certificateno == null ? other$certificateno != null : !this$certificateno.equals(other$certificateno)) {
                return false;
            }
            String this$isSignature = this.getIsSignature();
            String other$isSignature = other.getIsSignature();
            if (this$isSignature == null ? other$isSignature != null : !this$isSignature.equals(other$isSignature)) {
                return false;
            }
            String this$fzDate = this.getFzDate();
            String other$fzDate = other.getFzDate();
            if (this$fzDate == null ? other$fzDate != null : !this$fzDate.equals(other$fzDate)) {
                return false;
            }
            String this$zYear = this.getZYear();
            String other$zYear = other.getZYear();
            if (this$zYear == null ? other$zYear != null : !this$zYear.equals(other$zYear)) {
                return false;
            }
            String this$zMonth = this.getZMonth();
            String other$zMonth = other.getZMonth();
            if (this$zMonth == null ? other$zMonth != null : !this$zMonth.equals(other$zMonth)) {
                return false;
            }
            String this$zDay = this.getZDay();
            String other$zDay = other.getZDay();
            if (this$zDay == null ? other$zDay != null : !this$zDay.equals(other$zDay)) {
                return false;
            }
            String this$signatureImg = this.getSignatureImg();
            String other$signatureImg = other.getSignatureImg();
            if (this$signatureImg == null ? other$signatureImg != null : !this$signatureImg.equals(other$signatureImg)) {
                return false;
            }
            String this$unSignaturePDF = this.getUnSignaturePDF();
            String other$unSignaturePDF = other.getUnSignaturePDF();
            if (this$unSignaturePDF == null ? other$unSignaturePDF != null : !this$unSignaturePDF.equals(other$unSignaturePDF)) {
                return false;
            }
            String this$signaturePDF = this.getSignaturePDF();
            String other$signaturePDF = other.getSignaturePDF();
            return !(this$signaturePDF == null ? other$signaturePDF != null : !this$signaturePDF.equals(other$signaturePDF));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SignatureData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $address = this.getAddress();
            result = result * 59 + ($address == null ? 43 : $address.hashCode());
            String $headphoto = this.getHeadphoto();
            result = result * 59 + ($headphoto == null ? 43 : $headphoto.hashCode());
            String $idcardno = this.getIdcardno();
            result = result * 59 + ($idcardno == null ? 43 : $idcardno.hashCode());
            String $year = this.getYear();
            result = result * 59 + ($year == null ? 43 : $year.hashCode());
            String $month = this.getMonth();
            result = result * 59 + ($month == null ? 43 : $month.hashCode());
            String $day = this.getDay();
            result = result * 59 + ($day == null ? 43 : $day.hashCode());
            String $certificateno = this.getCertificateno();
            result = result * 59 + ($certificateno == null ? 43 : $certificateno.hashCode());
            String $isSignature = this.getIsSignature();
            result = result * 59 + ($isSignature == null ? 43 : $isSignature.hashCode());
            String $fzDate = this.getFzDate();
            result = result * 59 + ($fzDate == null ? 43 : $fzDate.hashCode());
            String $zYear = this.getZYear();
            result = result * 59 + ($zYear == null ? 43 : $zYear.hashCode());
            String $zMonth = this.getZMonth();
            result = result * 59 + ($zMonth == null ? 43 : $zMonth.hashCode());
            String $zDay = this.getZDay();
            result = result * 59 + ($zDay == null ? 43 : $zDay.hashCode());
            String $signatureImg = this.getSignatureImg();
            result = result * 59 + ($signatureImg == null ? 43 : $signatureImg.hashCode());
            String $unSignaturePDF = this.getUnSignaturePDF();
            result = result * 59 + ($unSignaturePDF == null ? 43 : $unSignaturePDF.hashCode());
            String $signaturePDF = this.getSignaturePDF();
            result = result * 59 + ($signaturePDF == null ? 43 : $signaturePDF.hashCode());
            return result;
        }

        public String toString() {
            return "BeiJingInSignatureToPDFCompare.SignatureData(name=" + this.getName() + ", address=" + this.getAddress() + ", headphoto=" + this.getHeadphoto() + ", idcardno=" + this.getIdcardno() + ", year=" + this.getYear() + ", month=" + this.getMonth() + ", day=" + this.getDay() + ", certificateno=" + this.getCertificateno() + ", isSignature=" + this.getIsSignature() + ", fzDate=" + this.getFzDate() + ", zYear=" + this.getZYear() + ", zMonth=" + this.getZMonth() + ", zDay=" + this.getZDay() + ", signatureImg=" + this.getSignatureImg() + ", unSignaturePDF=" + this.getUnSignaturePDF() + ", signaturePDF=" + this.getSignaturePDF() + ")";
        }
    }
}

