package com.bcxin.signature.util.SM;

//import com.alibaba.druid.support.json.JSONUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.pqc.math.linearalgebra.ByteUtils;

import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.spec.SecretKeySpec;
import java.security.*;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

/**
 * sm4加密算法工具类
 * @explain sm4加密、解密与加密结果验证
 *          可逆算法
 */
public class Sm4Util {

    static {
        Security.addProvider(new BouncyCastleProvider());
    }

    private static final String ENCODING = "UTF-8";
    public static final String ALGORITHM_NAME = "SM4";
    /*@Value("${sm4.key}")
    private static String KEY;*/
    public static final String KEY="86C63180C2806ED1F47B859DE501215C"; //特别注意,不要乱改
    // 加密算法/分组加密模式/分组填充方式
    // PKCS5Padding-以8个字节为一组进行分组加密
    // 定义分组加密模式使用：PKCS5Padding
    public static final String ALGORITHM_NAME_ECB_PADDING = "SM4/ECB/PKCS5Padding";
    // 128-32位16进制；256-64位16进制
    public static final int DEFAULT_KEY_SIZE = 128;

    /**
     * 生成ECB暗号
     * @explain ECB模式（电子密码本模式：Electronic codebook）
     * @param algorithmName
     *            算法名称
     * @param mode
     *            模式
     * @param key
     * @return
     * @throws Exception
     */
    private static Cipher generateEcbCipher(String algorithmName, int mode, byte[] key) throws Exception {
        Cipher cipher = Cipher.getInstance(algorithmName, BouncyCastleProvider.PROVIDER_NAME);
        Key sm4Key = new SecretKeySpec(key, ALGORITHM_NAME);
        cipher.init(mode, sm4Key);
        return cipher;
    }
    /**
     * 自动生成密钥
     * @explain
     * @return
     * @throws NoSuchAlgorithmException
     * @throws NoSuchProviderException
     */
    public static byte[] generateKey() throws Exception {
        return generateKey(DEFAULT_KEY_SIZE);
    }

    /**
     * @explain
     * @param keySize
     * @return
     * @throws Exception
     */
    public static byte[] generateKey(int keySize) throws Exception {
        KeyGenerator kg = KeyGenerator.getInstance(ALGORITHM_NAME, BouncyCastleProvider.PROVIDER_NAME);
        kg.init(keySize, new SecureRandom());
        return kg.generateKey().getEncoded();
    }
    /**
     * sm4加密
     * @explain 加密模式：ECB
     *          密文长度不固定，会随着被加密字符串长度的变化而变化
     * @param hexKey
     *            16进制密钥（忽略大小写）
     * @param paramStr
     *            待加密字符串
     * @return 返回16进制的加密字符串
     * @throws Exception
     */
    public static String encryptEcb(String hexKey, String paramStr) throws Exception {
        String cipherText = "";
        // 16进制字符串-->byte[]
        byte[] keyData = ByteUtils.fromHexString(hexKey);
        // String-->byte[]
        byte[] srcData = paramStr.getBytes(ENCODING);
        // 加密后的数组
        byte[] cipherArray = encrypt_Ecb_Padding(keyData, srcData);
        // byte[]-->hexString
        cipherText = ByteUtils.toHexString(cipherArray);
        return cipherText;
    }

    /**
     * 加密模式之Ecb
     * @explain
     * @param key
     * @param data
     * @return
     * @throws Exception
     */
    public static byte[] encrypt_Ecb_Padding(byte[] key, byte[] data) throws Exception {
        Cipher cipher = generateEcbCipher(ALGORITHM_NAME_ECB_PADDING, Cipher.ENCRYPT_MODE, key);
        return cipher.doFinal(data);
    }
    /**
     * sm4解密
     * @explain 解密模式：采用ECB
     * @param hexKey
     *            16进制密钥
     * @param cipherText
     *            16进制的加密字符串（忽略大小写）
     * @return 解密后的字符串
     * @throws Exception
     */
    public static String decryptEcb(String hexKey, String cipherText) throws Exception {
        // 用于接收解密后的字符串
        String decryptStr = "";
        // hexString-->byte[]
        byte[] keyData = ByteUtils.fromHexString(hexKey);
        // hexString-->byte[]
        byte[] cipherData = ByteUtils.fromHexString(cipherText);
        // 解密
        byte[] srcData = decrypt_Ecb_Padding(keyData, cipherData);
        // byte[]-->String
        decryptStr = new String(srcData, ENCODING);
        return decryptStr;
    }

    /**
     * 解密
     * @explain
     * @param key
     * @param cipherText
     * @return
     * @throws Exception
     */
    public static byte[] decrypt_Ecb_Padding(byte[] key, byte[] cipherText) throws Exception {
        Cipher cipher = generateEcbCipher(ALGORITHM_NAME_ECB_PADDING, Cipher.DECRYPT_MODE, key);
        return cipher.doFinal(cipherText);
    }
    /**
     * 校验加密前后的字符串是否为同一数据
     * @explain
     * @param hexKey
     *            16进制密钥（忽略大小写）
     * @param cipherText
     *            16进制加密后的字符串
     * @param paramStr
     *            加密前的字符串
     * @return 是否为同一数据
     * @throws Exception
     */
    public static boolean verifyEcb(String hexKey, String cipherText, String paramStr) throws Exception {
        // 用于接收校验结果
        boolean flag = false;
        // hexString-->byte[]
        byte[] keyData = ByteUtils.fromHexString(hexKey);
        // 将16进制字符串转换成数组
        byte[] cipherData = ByteUtils.fromHexString(cipherText);
        // 解密
        byte[] decryptData = decrypt_Ecb_Padding(keyData, cipherData);
        // 将原字符串转换成byte[]
        byte[] srcData = paramStr.getBytes(ENCODING);
        // 判断2个数组是否一致
        flag = Arrays.equals(decryptData, srcData);
        return flag;
    }
    //默认密钥
    public static String  encryptEcbWithKey(String paramStr){
        //KEY = key;
        String cipher = null;
        try {
            if(paramStr != null && paramStr != "") {
                cipher = Sm4Util.encryptEcb(KEY, paramStr);
            }

        } catch (Exception e) {
            e.printStackTrace();
        }finally {
        }
        return  cipher;
    }
    public static String decryptEcbWithKey(String cipherText){
        String paramStr = null;
        try {
            if(cipherText !=null && cipherText !="") {
                paramStr = Sm4Util.decryptEcb(KEY, cipherText);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }finally {
        }
        return paramStr;
    }
    /**
     * 字节数组转成16进制表示格式的字符串
     *
     * @param byteArray
     *            需要转换的字节数组
     * @return 16进制表示格式的字符串
     **/
    public static String toHexString(byte[] byteArray) {
        if (byteArray == null || byteArray.length < 1)
            throw new IllegalArgumentException("this byteArray must not be null or empty");

        final StringBuilder hexString = new StringBuilder();
        for (int i = 0; i < byteArray.length; i++) {
            if ((byteArray[i] & 0xff) < 0x10)//0~F前面不零
                hexString.append("0");
            hexString.append(Integer.toHexString(0xFF & byteArray[i]));
        }
        return hexString.toString().toLowerCase();
    }
    public static void main(String[] args) {
        try {
            Map map = new HashMap();
            map.put("ee","test");
            map.put("12","test1");
            map.put("13","test2");
            //String  str = JSONUtils.toJSONString(map);
            System.out.println((String)map.get("asdad"));
            System.out.println(123);
           /* ThirdApp bean = new ThirdApp();
            bean.setAppSecret("test");
            System.out.println(bean.getAppSecret());
            bean.decryptData(bean);
            System.out.println(bean.getAppSecret());*/
           // System.out.println(KEY);
            /*String json = "四五六七八九十一二三四五六七八九十一二三四五六七八九十一二三四五六七八九十一二三四五六七八九十一二三四五六七八九十一二三四五六七八九十一二三四五六七八九十一二三四五六七八九十一二三四五六七八九十一二三四五六七八九十一二三四五六七八九十一二三四五六七八九十一二三四五六七八九十一二三四五六七八九十一二三四五六七八九十一二三四五六七八九十一二三四五六七八九十一二三四五六七八九十一二三四五六七八九十一二三四五六七八九十一二三四五六七八九十一二三四五六七八九十一二三四五六七八九十一二三四五六七八九十一二三四五";
            System.out.println(json.length());
            String cipher = Sm4Util.encryptEcbWithKey(json);
            System.out.println(cipher);
            System.out.println(cipher.length());
          *//*  System.out.println(Sm4Util.verifyEcb(KEY, cipher, json));*//*
            String plant = Sm4Util.decryptEcbWithKey( "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");
            System.out.println(plant);*/
           /* // 自定义的32位16进制密钥
            //String key = "86C63180C2806ED1F47B859DE501215B";
            String key = "86C63180C2806ED1F47B859DE501215C";
            String cipher = Sm4Util.encryptEcb(key, json);
            System.out.println(cipher);//05a087dc798bb0b3e80553e6a2e73c4ccc7651035ea056e43bea9d125806bf41c45b4263109c8770c48c5da3c6f32df444f88698c5c9fdb5b0055b8d042e3ac9d4e3f7cc67525139b64952a3508a7619
            System.out.println(Sm4Util.verifyEcb(key, cipher, json));// true
            json = Sm4Util.decryptEcb(key, cipher);
            System.out.println(json);*/
            /*byte[] key = generateKey();
            System.out.println(toHexString(key));*/

        } catch (Exception e) {
            e.printStackTrace();
        }
    }

}
