package com.baichuanxin.openrestapi.service;

import com.baichuanxin.openrestapi.entity.Notice;

import java.util.List;

public interface NoticeService {
    /**
     * 接收办件通知
     * @param noticeData
     * @return
     */
    void getNotice(String noticeData);

    /***
     *@Author duxiangyun
     *@Description 获取还没拿到数据的办件
     *@Date 2024/8/26
     */
    Notice getUnFinishTask();
    /**
     *@Author duxiangyun
     *@Description  根据taskID 修改办件状态
     *@Date 2024/8/26
     */
    boolean updateNoticeStatus(String taskId,int status,int fileStatus);
    boolean updateNoticeSentFileStatus(String taskId,int fileStatus);
    /**
     *@Author duxiangyun
     *@Description 取回办件业务数据后更新办件通知数据
     *@Date 2024/8/26
     */
    int updateNoticeOneByTaskId(Notice notice);

    List<Notice> getUnReturnList(int status,int fileStatus,String matId);

    List<Notice> getUnReturnListBymatIdList(int status, List<String> matIdList);

    List<Notice> getUnSentResultFile(String MatId);

    List<Notice> getCheckTaskFile();

}
