package com.baichuanxin.openrestapi.factorys;

import com.baichuanxin.openrestapi.common.OnlineTaskConstant;
import com.baichuanxin.openrestapi.common.utils.SpringContextUtils;
import com.baichuanxin.openrestapi.service.TaskInfoService;
import com.baichuanxin.openrestapi.service.impl.*;
import lombok.extern.slf4j.Slf4j;

@Slf4j
public class TaskFactory {
    public static TaskInfoService creatTaskService(String matId){
        switch (matId) {
            case OnlineTaskConstant.MAT_ID_0:
                return SpringContextUtils.getBean(SecurityServicekTaskInfoServiceImpl.class);
            case OnlineTaskConstant.MAT_ID_1:
                return SpringContextUtils.getBean(ChangeLegalPersonTaskInfoServiceImpl.class);
            case OnlineTaskConstant.MAT_ID_2:
                return SpringContextUtils.getBean(ExamTaskInfoServiceImpl.class);
            case OnlineTaskConstant.MAT_ID_3:
                return SpringContextUtils.getBean(SelfRecruitmentFilingTaskInfoImpl.class);
            case OnlineTaskConstant.MAT_ID_4:
                return SpringContextUtils.getBean(RegistrationBranchTaskInfoServiceImpl.class);
            case OnlineTaskConstant.MAT_ID_5:
                return SpringContextUtils.getBean(CrossRegionalFilingTaskInfoServiceImpl.class);
        }
        throw new RuntimeException(String.format("获取处置策略异常，无此处置类型，auditTypeEnum：%s", matId));
    }

}
