package com.baichuanxin.openrestapi.dtos;

import ch.qos.logback.core.joran.action.NOPAction;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.baichuanxin.openrestapi.common.OnlineTaskConstant;
import com.baichuanxin.openrestapi.common.utils.OnlineTaskUtil;
import com.baichuanxin.openrestapi.entity.Notice;
import com.baichuanxin.openrestapi.entity.SelfRecruitmentFiling;
import lombok.Data;

import java.util.Date;

@Data
public class SelfRecruitmentFilingDto {
    /**
     * 1、选择办事区域
     */
    //所属监管机构
    private String item_officePoliceAddress;
    //所属区县监管机构
    private String  ylcsjyssq;
    /**
     * 2、填写单位信息
     */
    //单位名称
    private String item_companyName;
    //单位地址
    private String  item_address;
    //单位类型
    private String item_unit_type;
    //统一社会信用代码
    private String item_creditCode;
    //所服务项目名称
    private String item_serviceArea;
    //开展保安服务地点
    private String  item_service_place;
    //保安员数
    private String  item_recordPeronNum;

    /**
     * 3、填写法人信息
     */

    //姓名
    private String  item_legal_name;
    //联系电话
    private String  item_legal_phone;
    //证件类型
    private String  item_legal_type;
    //证件号码
    private String  item_legai_number;
    /**
     * 4、填写分管保安负责人信息
     */
    //姓名
    private String  item_chargeName;
    //身份证号码
    private String  item_chargeCardNumber;
    //手机号
    private String  item_chargePhone;

    /**
     * 5、经办人信息
     */
    //姓名
    private String  item_applicant_name;
    //身份证号
    private String  item_applicant_card_num;
    //联系电话
    private String  item_applicant_phone;
    /***
     *@Author duxiangyun
     *@Description  承诺填报信息真实有效
     *@Date 2024/9/2
     */
    private String item_premit;

    public SelfRecruitmentFiling convert(Notice notice){
        SelfRecruitmentFiling selfRecruitmentFiling = new SelfRecruitmentFiling();
        Date now = new Date();
        //审核数据
        selfRecruitmentFiling.setItemAuditStatus("3");
        //办件数据
        selfRecruitmentFiling.setTaskId(notice.getTaskId());
        //表单需求数据
        selfRecruitmentFiling.setId(StrUtil.join("--",notice.getTaskId(), OnlineTaskConstant.SELF_RECRUITMENT));
        selfRecruitmentFiling.setCreated(now);
        selfRecruitmentFiling.setLastmodified(now);
        selfRecruitmentFiling.setFormname("");
        selfRecruitmentFiling.setFormid(OnlineTaskConstant.SELF_RECRUITMENT);
        selfRecruitmentFiling.setIstmp(true);
        selfRecruitmentFiling.setApplicationid("__JvOHkqjhV41mUo4ITRv");
        selfRecruitmentFiling.setDomainid("__UDa4uPMdcOYgP7HETaf");
        selfRecruitmentFiling.setItemRegion("湖南省");
        selfRecruitmentFiling.setIsdelivery("0");


//        selfRecruitmentFiling.setItemitemOfficePoliceAddressid(this.getYlcsjyssq());
        //填写单位信息
        //单位名称
        selfRecruitmentFiling.setItemCompanyName(this.getItem_companyName());
        //办公住所格式化
        AddressDto addressDto = JSON.parseObject(this.getItem_address(), AddressDto.class);
        selfRecruitmentFiling.setItemAddress(addressDto.convert());
        selfRecruitmentFiling.setItemUnitType(this.getItem_unit_type());
        selfRecruitmentFiling.setItemCreditCode(this.getItem_creditCode());
        selfRecruitmentFiling.setItemServiceArea(this.getItem_serviceArea());
        selfRecruitmentFiling.setItemServicePlace(this.getItem_service_place());
        selfRecruitmentFiling.setItemRecordPeronNum(this.getItem_recordPeronNum());

        //填写法人
        selfRecruitmentFiling.setItemLegalName(this.getItem_legal_name());
        selfRecruitmentFiling.setItemLegalPhone(this.getItem_legal_type());
        selfRecruitmentFiling.setItemLegalType(OnlineTaskUtil.idCardTypeConvert(this.getItem_legai_number()));
        selfRecruitmentFiling.setItemLegaiNumber(this.getItem_legal_phone());
        //4、填写分管保安负责人信息
        selfRecruitmentFiling.setItemChargeName(this.getItem_chargeName());
        selfRecruitmentFiling.setItemChargeCardNumber(OnlineTaskUtil.decrypt(this.getItem_chargeCardNumber()));
        selfRecruitmentFiling.setItemChargePhone(this.getItem_chargePhone());
        //5、经办人信息
        selfRecruitmentFiling.setItemApplicantName(this.getItem_applicant_name());
        selfRecruitmentFiling.setItemApplicantCardNum(OnlineTaskUtil.decrypt(this.getItem_applicant_card_num()));
        selfRecruitmentFiling.setItemApplicantPhone(this.getItem_applicant_phone());
        //7、承诺上述填报信息真实有效
        selfRecruitmentFiling.setItemPermit(this.getItem_premit());


        return selfRecruitmentFiling;
    }


}
