package com.baichuanxin.openrestapi.common.utils;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.ZipUtil;
import cn.hutool.http.HttpUtil;
import lombok.extern.slf4j.Slf4j;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Base64;

@Slf4j
public class FileHandleUtil {
    /***
     *@Author duxiangyun
     *@Description 文件处理   审核结果返回结果午文件，传入文件路径
     *
     *@Date 2024/8/28
     */
    public static File fileHandle(String fileStr){
        /**
         * 还缺少图片数据处理 ，通过读取本地服务器读取文件
         */
        log.info("获取本地图片，图片地址：{}",fileStr);
        File file = FileUtil.file(fileStr);
        return file;
    }

    public static String  strHandle(String strFront,String strBack){
        StringBuilder stringBuilder  =new StringBuilder();
        stringBuilder.append(strFront);
        stringBuilder.append(strBack);
        String s = stringBuilder.toString();
        return s;
    }

    /***
     *@Author duxiangyun
     *@Description  保存用户申请提交的附件到服务器
     *@Date 2024/8/28   //第一个字段填写下载地址 ，第二个字段填写 保存路径 只写到路径 如 /data/tmp
     *  第三个写文件保存的全路径  如 /data/tmp/aaa.txt
     */
    public static void  saveApplyFileHandle(String url,String savePath,String saveFilePathStr) throws IOException {
        log.info("=======================开始保存文件到服务器：savePath{}====================",savePath);
        if (isImagesTrue(url)){
            URL downLoadUrl =new URL(url);
            //判断路径是否存在，不存在则创建目录
            Path saveDir = Paths.get(savePath);
            boolean exists = Files.exists(saveDir);
            if(!exists){
                Files.createDirectories(saveDir);
            }
            Path path = Paths.get(saveFilePathStr);
            InputStream in =  downLoadUrl.openStream();
            Files.copy(in,path, StandardCopyOption.REPLACE_EXISTING);
            log.info("=======================文件已经存到服务器存服务器====================");
        }else {
            log.info("===============文件保存至服务器失败===================");
        }

    }

    public static boolean  isImagesTrue(String url){
        boolean ok = HttpUtil.createGet(url).execute().isOk();
        return ok;
    }
    /***
     *@Author duxiangyun
     *@Description   文件复制
     *@Date 2024/10/28
     */
    public static void moveFile(String taskIdPath,String sourcePath,String destPath) throws IOException {
        //判断路径是否存在，不存在则创建目录
        Path saveDir = Paths.get(taskIdPath);
        boolean exists = Files.exists(saveDir);
        if(!exists){
            Files.createDirectories(saveDir);
        }
        Path sourPath = Paths.get(sourcePath);
        Path destinationPath = Paths.get(destPath);
        Files.copy(sourPath,destinationPath,StandardCopyOption.REPLACE_EXISTING);
    }

    public static void filePackage(String zipFilePath ,String foldPath ) throws IOException {
        // 压缩文件夹
        ZipUtil.zip(foldPath,zipFilePath);
        // 检查ZIP文件是否创建成功
        if (FileUtil.isFile(zipFilePath)) {
            log.info("文件夹已成功压缩为:{} " + zipFilePath);
        } else {
            log.info("压缩失败！");
        }
    }
    /**
     * base644编码处理,存入本地
     */
    public static String  fileSave(String baseEncode,String id, String fileName) throws IOException {
        StringBuffer eCPath  = new StringBuffer();
        eCPath.append("/data/v5-runing/storage/uploads/ecfile/" ).append(id).append("/").append(fileName).append(".ofd");
        Path path = Paths.get("/data/v5-runing/storage/uploads/ecfile/"+id);
        Files.createDirectories(path);
        byte[] decodedBytes = Base64.getDecoder().decode(baseEncode);
        //文件存储路径固定
        FileOutputStream fileOutputStream = new FileOutputStream(eCPath.toString());
        fileOutputStream.write(decodedBytes);
        fileOutputStream.close();
        return eCPath.toString();
    }
}
